/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.batch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.reg.domain.service.bill.IBatchRegBillService;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;
import kd.hr.hdm.common.reg.util.RegPageHelperUtil;

public class BatchRegListDataProvider
extends ListDataProvider {
    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        if (rows.isEmpty()) {
            return rows;
        }
        this.addAndSetParttimeStatisticsProperty(rows);
        return rows;
    }

    private void addAndSetParttimeStatisticsProperty(DynamicObjectCollection rows) {
        DynamicSimpleProperty regNumber = new DynamicSimpleProperty("regnumber", Integer.class, (Object)0);
        DynamicSimpleProperty regedNumber = new DynamicSimpleProperty("regednumber", Integer.class, (Object)0);
        rows.getDynamicObjectType().addProperty((DynamicProperty)regNumber);
        rows.getDynamicObjectType().addProperty((DynamicProperty)regedNumber);
        List ids = rows.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        QFilter idsFilter = new QFilter("id", "in", ids);
        DynamicObject[] batchParttimeList = IBatchRegBillService.getInstance().query(RegPageHelperUtil.BATCHQUERYFIELD, idsFilter.toArray());
        HashMap<Long, DynamicObjectCollection> entryDyCollectionMap = new HashMap<Long, DynamicObjectCollection>(rows.size());
        for (DynamicObject item2 : batchParttimeList) {
            entryDyCollectionMap.put(item2.getLong("id"), item2.getDynamicObjectCollection("entryentity"));
        }
        for (DynamicObject row : rows) {
            DynamicObjectCollection entryDyCollection = (DynamicObjectCollection)entryDyCollectionMap.get(row.getLong("id"));
            Map<String, Object> statisticsMap = this.regStatistics(entryDyCollection);
            row.set("regnumber", statisticsMap.get("regnumber"));
            row.set("regednumber", statisticsMap.get("regednumber"));
        }
    }

    private Map<String, Object> regStatistics(DynamicObjectCollection entryDyCollection) {
        HashMap<String, Object> statisticsMap = new HashMap<String, Object>(2);
        int regNumber = 0;
        int regedNumber = 0;
        if (Objects.nonNull(entryDyCollection)) {
            for (DynamicObject item : entryDyCollection) {
                String regStatus = item.getString("regstatus");
                if (RegBusinessStatusEnum.ALREADY_REGED.getCode().equals(regStatus)) {
                    ++regedNumber;
                }
                ++regNumber;
            }
        }
        statisticsMap.put("regnumber", regNumber);
        statisticsMap.put("regednumber", regedNumber);
        return statisticsMap;
    }
}

