/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.batch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.service.hssc.IHSSCService;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IBatchRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;

public class BatchRegTermEdit
extends AbstractFormPlugin {
    private static final String KEY_OK = "btnok";
    private static final Log LOGGER = LogFactory.getLog(BatchRegTermEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_OK});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (HRStringUtils.equals((String)KEY_OK, (String)key)) {
            this.checkTermination(evt);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_OK) && this.validateMustInputAndLength()) {
            Long billId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
            DynamicObject batchBillDy = IBatchRegBillService.getInstance().queryOne("termuser,termdate,termreason,billstatus,auditstatus,entryentity.id,entryentity.regstatus,entrytity.syncstatus", billId.longValue());
            DynamicObjectCollection entryDyCollection = batchBillDy.getDynamicObjectCollection("entryentity");
            String billstatus = batchBillDy.getString("billstatus");
            if ("B".equals(billstatus) || "D".equals(billstatus) || "G".equals(billstatus)) {
                batchBillDy.set("billstatus", (Object)"F");
                batchBillDy.set("auditstatus", (Object)"F");
                this.terminateWorkFlow(batchBillDy);
            } else if ("C".equals(billstatus)) {
                batchBillDy.set("auditstatus", (Object)"F");
            }
            String reason = (String)this.getModel().getValue("termreason");
            Date date = new Date();
            long currUserId = RequestContext.get().getCurrUserId();
            batchBillDy.set("termuser", (Object)currUserId);
            batchBillDy.set("termdate", (Object)date);
            batchBillDy.set("termreason", (Object)reason);
            List<Long> successPkIds = entryDyCollection.stream().filter(temp -> !RegBusinessStatusEnum.REJECT_REG.getCode().equals(temp.getString("regstatus")) && !RegBusinessStatusEnum.ALREADY_REGED.getCode().equals(temp.getString("regstatus"))).map(o -> o.getLong("id")).collect(Collectors.toList());
            DynamicObject[] bills = this.getBillsByPks(successPkIds);
            if (bills == null || bills.length < 1) {
                IFormView view = this.getView();
                IFormView parentView = view.getParentView();
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u5931\u8d25\uff1a\u5206\u5f55\u4e2d\u6ca1\u6709\u6ee1\u8db3\u7ec8\u6b62\u8981\u6c42\u7684\u6570\u636e\u3002", (String)"RegTermPlugin_10", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                parentView.invokeOperation("refresh");
                view.sendFormAction(parentView);
                this.getView().close();
                return;
            }
            ArrayList<DynamicObject> successDys = new ArrayList<DynamicObject>(bills.length);
            for (DynamicObject bill : bills) {
                if (!successPkIds.contains((Long)bill.getPkValue())) continue;
                bill.set("termreason", (Object)reason);
                bill.set("termdate", (Object)date);
                bill.set("termuser", (Object)currUserId);
                bill.set("modifytime", (Object)date);
                successDys.add(bill);
            }
            IRegBillService.getInstance().doBatchTerminateProcess(successDys.toArray(new DynamicObject[successDys.size()]));
            successDys.forEach(dy -> IPersonAboutService.getInstance().syncHPFSAfterTerminate(dy));
            IBatchRegBillService.getInstance().update(new DynamicObject[]{batchBillDy});
            IFormView view = this.getView();
            IFormView parentView = view.getParentView();
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u6210\u529f\u3002", (String)"RegTermPlugin_11", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            parentView.invokeOperation("refresh");
            view.sendFormAction(parentView);
            this.getView().close();
        }
    }

    private boolean validateMustInputAndLength() {
        String termReason = String.valueOf(this.getModel().getValue("termreason"));
        if (!StringUtils.isEmpty((CharSequence)termReason) && termReason.length() > 255) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u7ec8\u6b62\u6d41\u7a0b\u539f\u56e0\u201d\u8f93\u5165\u957f\u5ea6\u5e94\u5c0f\u4e8e255\u5b57\u7b26\u3002", (String)"RegTermPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private DynamicObject[] getBillsByPks(List<Long> successPkIds) {
        String selectProperties = "billstatus,person,org,billno,ermanfile,probation,affaction,probationunit,probationex,probationunitex,auditstatus,regbilltype,billstatus,regstatus,entrydate,effectdate,ismobile,bemployee,regcategory,termreason,termdate,termuser,modifytime,preactualdate,postponeprobation,regcomment";
        return HDMRegBaseBillRepository.getInstance().query(selectProperties, new QFilter[]{new QFilter("id", "in", successPkIds)});
    }

    private void checkTermination(BeforeClickEvent evt) {
        Long billId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        DynamicObject batchBillDy = IBatchRegBillService.getInstance().queryOne("billstatus,entryentity.id,entryentity.regstatus,entryentity.syncstatus", billId.longValue());
        if (ObjectUtils.isEmpty((Object)batchBillDy)) {
            return;
        }
        String billStatus = batchBillDy.getString("billstatus");
        String message = "";
        if (RegBillStatusEnum.TEMPSTORAGE.getCode().equals(billStatus)) {
            message = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\uff0c\u65e0\u9700\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"RegTermPlugin_5", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        } else if (RegBillStatusEnum.APPROVEREJECTED.getCode().equals(billStatus)) {
            message = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5ba1\u6279\u4e0d\u901a\u8fc7\u201d\uff0c\u4e0d\u53ef\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"RegTermPlugin_6", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        } else if (RegBillStatusEnum.ABANDONED.getCode().equals(billStatus)) {
            message = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5e9f\u5f03\u201d\uff0c\u4e0d\u53ef\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"RegTermPlugin_7", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        } else if (RegBillStatusEnum.APPROVEPASSED.getCode().equals(billStatus)) {
            DynamicObjectCollection entryDyCollection = batchBillDy.getDynamicObjectCollection("entryentity");
            if (ObjectUtils.isEmpty((Collection)entryDyCollection)) {
                return;
            }
            List listSync = entryDyCollection.stream().filter(o -> RegBusinessStatusEnum.REG_PENDINGTOBEVALID.getCode().equals(o.getString("regstatus")) && "-1".equals(o.getString("syncstatus"))).collect(Collectors.toList());
            List listReg = entryDyCollection.stream().filter(o -> RegBusinessStatusEnum.REG_PENDINGTOBEVALID.getCode().equals(o.getString("regstatus"))).collect(Collectors.toList());
            if (listSync.size() > 0) {
                message = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u5355\u636e\u4e2d\u6709\u4eba\u5458\u7684\u8f6c\u6b63\u72b6\u6001\u4e3a\u201c\u8f6c\u6b63\u5f85\u751f\u6548\u201d\u4e14\u540c\u6b65\u4eba\u5458\u72b6\u6001\u4e3a\u201c\u540c\u6b65\u4e2d\u201d\uff0c\u4e0d\u53ef\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"RegTermPlugin_8", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            }
            if (listReg.size() == 0) {
                message = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5ba1\u6279\u901a\u8fc7\u201d\uff0c\u4e14\u5f85\u8f6c\u6b63\u4eba\u5458\u7684\u8f6c\u6b63\u72b6\u6001\u5747\u4e3a\u201c\u5df2\u8f6c\u6b63\u201d\u6216\u201c\u4e0d\u4e88\u8f6c\u6b63\u201d\uff0c\u4e0d\u53ef\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"RegTermPlugin_9", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            }
        }
        if (!ObjectUtils.isEmpty((Object)message)) {
            this.getView().showErrorNotification(message);
            evt.setCancel(true);
            return;
        }
    }

    private void terminateWorkFlow(DynamicObject dy) {
        String billId = dy.get("id").toString();
        Long instanceId = WorkflowServiceHelper.getProcessInstanceIdByBusinessKey((String)billId);
        if (!Objects.isNull(instanceId) && !instanceId.equals(0L)) {
            try {
                LOGGER.info("BatchRegbill terminate work flow , instanceid : [{}]", (Object)instanceId);
                try (TXHandle txHandle = TX.notSupported();){
                    WorkflowServiceHelper.abandon((Long)instanceId);
                    IHSSCService.getInstance().terminateSSCTask(dy);
                }
            }
            catch (Exception exception) {
                LOGGER.error((Throwable)exception);
            }
        }
    }
}

