/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.batch.importvalidator;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;
import kd.hr.hdm.business.personnelchange.servicehelper.PersonnelChangeServiceHelper;
import kd.hr.hdm.business.reg.RegServiceHelper;
import kd.hr.hdm.business.reg.domain.repository.database.RegCateGoryRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.repository.LaborrelstatusRepository;
import kd.hr.hdm.common.reg.constants.LabRelConstants;
import kd.hr.hdm.common.reg.enums.RegCategoryEnum;
import kd.hr.hdm.common.reg.enums.RegDateUnitEnum;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hrmp.hies.entry.core.validate.AbstractEntryValidateHandler;

public class RegEntryErmanFileValidator
extends AbstractEntryValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(RegEntryErmanFileValidator.class);
    private static final String ZH_CN = "zh_CN";
    private static final String EN_US = "en_US";
    private static final String ZH_TW = "zh_TW";
    private Map<String, String> existDataMap = new HashMap<String, String>();
    private long org = 0L;
    private List<QFilter> filters = new ArrayList<QFilter>();
    private Map<Long, DynamicObject> labrelstatusclsMap = new HashMap<Long, DynamicObject>(0);
    private Map<Long, DynamicObject> regcategoryMap = new HashMap<Long, DynamicObject>(0);
    private Map<Long, DynamicObject> erfiletypeMap = new HashMap<Long, DynamicObject>(0);

    public RegEntryErmanFileValidator() {
    }

    public RegEntryErmanFileValidator(Map<String, Object> paramMap) {
        this.org = (Long)paramMap.get("org");
        this.filters = (List)paramMap.get("filters");
        DynamicObject[] labrelstatuscls = LaborrelstatusRepository.getInstance().queryAll("id, name, labrelstatuscls");
        this.labrelstatusclsMap = Arrays.stream(labrelstatuscls).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        DynamicObject[] regcategorys = RegCateGoryRepository.getInstance().listRegCateGory("id, group, enable", new QFilter("1", "=", (Object)1));
        this.regcategoryMap = Arrays.stream(regcategorys).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hspm_erfiletype");
        DynamicObject[] erfiletypes = helper.query("id, erfiletypeassign", new QFilter("1", "=", (Object)1).toArray());
        this.erfiletypeMap = Arrays.stream(erfiletypes).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
    }

    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.BEFORE;
    }

    public void validate(List<ImportBillData> list, ImportLog importLog) {
        HashMap dataMap = new HashMap(list.size());
        ArrayList ermanfileIds = new ArrayList(list.size());
        ArrayList ermanfileNumbers = new ArrayList(list.size());
        HashSet affactionIds = new HashSet(list.size());
        list.forEach(importBillData -> {
            JSONObject entry = importBillData.getData().getJSONObject("entryentity");
            if (entry.containsKey((Object)"MustInputPass") && !entry.getBoolean("MustInputPass").booleanValue()) {
                return;
            }
            affactionIds.add(entry.getJSONObject("affaction").getLong("id"));
            JSONObject ermanfile = entry.getJSONObject("ermanfile");
            String number = ermanfile.getString("number");
            if (ermanfile.containsKey((Object)"id")) {
                Long ermanfileId = ermanfile.getLong("id");
                ermanfileIds.add(ermanfileId);
                List importBillDatas = dataMap.getOrDefault(ermanfileId, new ArrayList());
                importBillDatas.add(importBillData);
                dataMap.put(ermanfileId, importBillDatas);
            } else {
                ermanfileNumbers.add(number);
            }
        });
        LOGGER.info("cannot find ermanfileNumbers:{}", ermanfileNumbers);
        Map laborrelstatusStatusMap = PersonnelChangeServiceHelper.getLaborrelstatusByAffactions(new ArrayList(affactionIds));
        List ermanfiles = PersonExternalService.getInstance().invokeGetCardFields(ermanfileIds.stream().distinct().collect(Collectors.toList()));
        List employeeIds = ermanfiles.stream().map(map -> (Long)map.get("employee_id")).distinct().collect(Collectors.toList());
        List trialperiods = IPersonAboutService.getInstance().batchBuildRegInfo(employeeIds);
        Map trialperiodMap = trialperiods.stream().collect(Collectors.toMap(map -> (Long)map.get("employee"), Function.identity()));
        HRBaseServiceHelper ermanfileHelper = new HRBaseServiceHelper("hspm_ermanfile");
        QFilter qf = new QFilter("id", "in", ermanfileIds);
        this.filters.forEach(filter -> qf.and(filter));
        DynamicObject[] permErmanfiles = ermanfileHelper.queryOriginalArray("id", qf.toArray());
        Set filterErmanfiles = Arrays.stream(permErmanfiles).map(file -> file.getLong("id")).collect(Collectors.toSet());
        ermanfiles.forEach(map -> {
            Long ermanfileId = (Long)map.get("id");
            String ermanfileNameInDb = (String)map.get("name");
            String number = (String)map.get("number");
            List importBillDatas = (List)dataMap.get(ermanfileId);
            importBillDatas.forEach(importBillData -> {
                Object regstatus;
                DynamicObject group;
                DynamicObject regcategory;
                long regcategoryId;
                Object isviewflow;
                long orgId;
                long laborrelstatusId;
                DynamicObject laborrelstatus;
                JSONObject data = importBillData.getData().getJSONObject("entryentity");
                JSONObject ermanfile = data.getJSONObject("ermanfile");
                Long employeeId = (Long)map.get("employee_id");
                Map trialperiod = trialperiodMap.getOrDefault(employeeId, new HashMap());
                Date preregulardate = (Date)trialperiod.get("preregulardate");
                ermanfile.put("person_id", map.get("person_id"));
                ermanfile.put("employee_id", map.get("employee_id"));
                ermanfile.put("depemp_id", map.get("depemp_id"));
                ermanfile.put("cmpemp_id", map.get("cmpemp_id"));
                ermanfile.put("preregulardate", (Object)preregulardate);
                ermanfile.put("ermanfileNameInDb", (Object)ermanfileNameInDb);
                data.put("preactualdate", (Object)preregulardate);
                data.put("bcompany", (Object)this.genJsonObject((Long)map.get("company_id")));
                data.put("badminorg", (Object)this.genJsonObject((Long)map.get("adminorg_id")));
                data.put("bposition", (Object)this.genJsonObject((Long)map.get("position_id")));
                data.put("standardpost", (Object)this.genJsonObject((Long)map.get("stdposition_id")));
                data.put("bjob", (Object)this.genJsonObject((Long)map.get("job_id")));
                data.put("probation", trialperiod.get("probation"));
                data.put("probationtext", (Object)(trialperiod.get("probation") + RegDateUnitEnum.getName((String)((String)trialperiod.get("probationunit")))));
                data.put("probationunit", (Object)RegDateUnitEnum.getName((String)((String)trialperiod.get("probationunit"))));
                data.put("bemployee", (Object)this.genJsonObject((Long)map.get("employee_id")));
                data.put("person", (Object)this.genJsonObject((Long)map.get("person_id")));
                String inputName = ermanfile.getString("name");
                if (StringUtils.isNotEmpty((CharSequence)ermanfileNameInDb) && StringUtils.isNotEmpty((CharSequence)inputName) && !ermanfileNameInDb.equals(inputName)) {
                    RegServiceHelper.writeErmanFileErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8be5\u5458\u5de5\u7684\u5de5\u53f7\u3001\u59d3\u540d\u662f\u5426\u6b63\u786e\u3002", (String)"RegEntryErmanFileValidator_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                }
                if ((laborrelstatus = this.labrelstatusclsMap.get(laborrelstatusId = ((Long)map.get("laborrelstatus_id")).longValue())) != null && laborrelstatus.getDynamicObject("labrelstatuscls").getLong("id") != LabRelConstants.PROBATION.longValue()) {
                    RegServiceHelper.writeErmanFileErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)ResManager.loadKDString((String)"\u5f53\u524d\u5458\u5de5\u7684\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u4e3a\u201c%s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RegEntryErmanFileValidator_2", (String)"hr-hdm-formplugin", (Object[])new Object[]{laborrelstatus.getString("name")}));
                }
                if (this.org != (orgId = ((Long)map.get("org_id")).longValue())) {
                    RegServiceHelper.writeErmanFileErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)ResManager.loadKDString((String)"\u5f85\u8f6c\u6b63\u5458\u5de5\u4e0d\u5728\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u7684\u7ba1\u7406\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RegEntryErmanFileValidator_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                }
                long filetypeId = (Long)map.get("filetype_id");
                if (!filterErmanfiles.contains(ermanfileId)) {
                    RegServiceHelper.writeErmanFileErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)ResManager.loadKDString((String)"\u5f53\u524d\u5458\u5de5\u7684\u6863\u6848\u7c7b\u578b\u5f52\u5c5e\u4e3a\u201c%s\u201d\u3002", (String)"RegEntryErmanFileValidator_3", (String)"hr-hdm-formplugin", (Object[])new Object[]{this.erfiletypeMap.get(filetypeId).getString("erfiletypeassign.name")}));
                }
                long regcommentId = 0L;
                if (data.getJSONObject("regcomment").containsKey((Object)"id")) {
                    regcommentId = data.getJSONObject("regcomment").getLong("id");
                }
                if (1010L != regcommentId && 1020L != regcommentId) {
                    RegServiceHelper.writeErmanFileErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)ResManager.loadKDString((String)"\u8f6c\u6b63\u610f\u89c1\u53ea\u80fd\u586b\u5199\u201c\u540c\u610f\u8f6c\u6b63\u201d\u6216\u201c\u4e0d\u540c\u610f\u8f6c\u6b63\u201d\u3002", (String)"RegEntryErmanFileValidator_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                }
                Date effectdate = null;
                try {
                    effectdate = data.getDate("effectdate");
                    if (1010L == regcommentId && effectdate == null) {
                        RegServiceHelper.writeErmanFileErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)ResManager.loadKDString((String)"\u5982\u679c\u8f6c\u6b63\u610f\u89c1\u4e3a\u201c\u540c\u610f\u8f6c\u6b63\u201d\uff0c\u9700\u586b\u5199\u201c\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u201d\u3002", (String)"RegEntryErmanFileValidator_5", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error("effectdate parse error:", (Throwable)numberFormatException);
                }
                JSONObject afterlaborrelstatus = data.getJSONObject("laborrelstatus");
                if (1010L == regcommentId && afterlaborrelstatus == null) {
                    RegServiceHelper.writeErmanFileErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)ResManager.loadKDString((String)"\u8f6c\u6b63\u610f\u89c1\u4e3a\u201c\u540c\u610f\u8f6c\u6b63\u201d\u65f6\uff0c\u201c\u8f6c\u6b63\u540e\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RegEntryErmanFileValidator_15", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                } else if (1010L == regcommentId && afterlaborrelstatus != null) {
                    Long affactionId = data.getJSONObject("affaction").getLong("id");
                    if (affactionId == null || affactionId == 0L) {
                        return;
                    }
                    List laborrelstatusDys = laborrelstatusStatusMap.getOrDefault(affactionId, new ArrayList(0));
                    Set laborrelstatusStatuses = laborrelstatusDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
                    if (laborrelstatusStatuses == null || laborrelstatusStatuses.isEmpty() || !laborrelstatusStatuses.contains(afterlaborrelstatus.getLong("id"))) {
                        RegServiceHelper.writeErmanFileErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)ResManager.loadKDString((String)"\u201c\u8f6c\u6b63\u540e\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u201d\u586b\u5199\u6709\u8bef\uff0c \u8bf7\u4fee\u6539\u3002", (String)"RegEntryErmanFileValidator_16", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    }
                }
                Date startdate = (Date)map.get("startdate");
                data.put("entrydate", (Object)startdate);
                if (1010L == regcommentId && effectdate != null && effectdate.before(startdate)) {
                    RegServiceHelper.writeErmanFileErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)ResManager.loadKDString((String)"\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5165\u804c\u65e5\u671f\u201c%s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RegEntryErmanFileValidator_6", (String)"hr-hdm-formplugin", (Object[])new Object[]{DateUtils.dateToString((Date)startdate, (DatePattern)DatePattern.YYYY_MM_DD)}));
                }
                if (!((isviewflow = data.get((Object)"isviewflow")) instanceof Boolean)) {
                    RegServiceHelper.writeErmanFileErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)ResManager.loadKDString((String)"\u201c\u662f\u5426\u5141\u8bb8\u5458\u5de5\u53ef\u89c1\u6d41\u7a0b\u201d\u53ea\u80fd\u586b\u5199\u201c\u662f\u201d\u6216\u201c\u5426\u201d\u3002", (String)"RegEntryErmanFileValidator_11", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                }
                if ((regcategoryId = data.getJSONObject("regcategory").getLongValue("id")) == 0L) {
                    return;
                }
                if (effectdate != null && 1010L == regcommentId && regcategoryId == RegCategoryEnum.INADVANCE.getId() && (effectdate.after(preregulardate) || effectdate.getTime() == preregulardate.getTime())) {
                    RegServiceHelper.writeErmanFileErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)ResManager.loadKDString((String)"\u5982\u679c\u8f6c\u6b63\u5206\u7c7b\u4e3a\u201c\u63d0\u524d\u8f6c\u6b63\u201d\uff0c\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u9884\u8f6c\u6b63\u65e5\u671f\u201c%s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RegEntryErmanFileValidator_7", (String)"hr-hdm-formplugin", (Object[])new Object[]{DateUtils.dateToString((Date)preregulardate, (DatePattern)DatePattern.YYYY_MM_DD)}));
                }
                if ((regcategory = this.regcategoryMap.get(regcategoryId)) != null && "0".equals(regcategory.getString("enable"))) {
                    RegServiceHelper.writeErmanFileErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)ResManager.loadKDString((String)"\u8f6c\u6b63\u5206\u7c7b\u201c%s\u201d\u5df2\u7981\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RegEntryErmanFileValidator_8", (String)"hr-hdm-formplugin", (Object[])new Object[]{regcategory.getString("name")}));
                }
                if ((group = regcategory.getDynamicObject("group")).getLong("id") != regcommentId) {
                    RegServiceHelper.writeErmanFileErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)String.format(ResManager.loadKDString((String)"\u8f6c\u6b63\u5206\u7c7b\u201c%1$s\u201d\u5bf9\u5e94\u7684\u8f6c\u6b63\u610f\u89c1\u5e94\u4e3a\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RegEntryErmanFileValidator_9", (String)"hr-hdm-formplugin", (Object[])new Object[0]), regcategory.getString("name"), group.getString("name")));
                }
                if (regcategoryId == RegCategoryEnum.POSTPHONE.getId()) {
                    RegServiceHelper.writeErmanFileErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u8f6c\u6b63\u5206\u7c7b\u4e3a\u201c\u5ef6\u671f\u8f6c\u6b63\u201d\uff0c\u6279\u91cf\u8f6c\u6b63\u7533\u8bf7\u6682\u4e0d\u652f\u6301\u5ef6\u671f\u8f6c\u6b63\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RegEntryErmanFileValidator_10", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                }
                if (Objects.nonNull(regstatus = trialperiod.get("regstatus")) && StringUtils.isNotEmpty((CharSequence)((String)regstatus)) && !"1010".equals((String)regstatus)) {
                    RegServiceHelper.writeErmanFileErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)ResManager.loadKDString((String)"\u53ea\u53ef\u4e3a\u5f85\u8f6c\u6b63\u5458\u5de5\u53d1\u8d77\u8f6c\u6b63\u7533\u8bf7\u3002", (String)"RegEntryErmanFileValidator_14", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                }
                if (this.existDataMap.containsKey(number)) {
                    RegServiceHelper.writeErmanFileErrorInfo((ImportBillData)importBillData, (ImportLog)importLog, (String)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u4e2d\u5f85\u8f6c\u6b63\u4eba\u5458\u5b58\u5728\u91cd\u590d\u6570\u636e\uff1a%1$s%2$s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RegEntryErmanFileValidator_13", (String)"hr-hdm-formplugin", (Object[])new Object[0]), number, ermanfileNameInDb));
                } else {
                    this.existDataMap.put(number, ermanfileNameInDb);
                }
            });
        });
    }

    private JSONObject genJsonObject(Long id) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)id);
        return jsonObject;
    }
}

