/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.exam;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hdm.business.reg.RegExamServiceHelper;
import kd.hr.hdm.business.reg.RegMessageServiceHelper;
import kd.hr.hdm.business.reg.domain.repository.database.RegExamTemplateRepository;
import kd.hr.hdm.business.reg.domain.repository.database.RegProcessRepository;
import kd.hr.hdm.business.reg.validator.RegCommonValidatorHelper;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.formplugin.reg.web.RegAskAndExamSingleCommon;
import org.apache.commons.lang.StringUtils;

public class RegExamPersonPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(RegExamPersonPlugin.class);
    private static final String CALCULATE_TYPE = "calculatetype";
    private static final String TEMPLATE = "template";
    private RegAskAndExamSingleCommon singleCommon = new RegAskAndExamSingleCommon();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"return"});
    }

    public void onGetControl(OnGetControlArgs e) {
        this.singleCommon.onGetControl(e, this.getView(), (IFormPlugin)this);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        this.singleCommon.loadCustomControlMetas(e, false, false);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("RegExamPersonPlugin", exp.getMessage()), new Object[0]);
        }
        this.singleCommon.registDynamicProps(newMainType, this.getView());
        e.setNewEntityType(newMainType);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long employee = (Long)this.getView().getFormShowParameter().getCustomParam("employee");
        if (this.isNeverApplyExam(employee) && this.haveDefaultTemplate()) {
            return;
        }
        QFilter filter = new QFilter("bemployee", "=", (Object)employee);
        DynamicObject resultObject = RegExamServiceHelper.RESULT_SERVICE_HELPER.queryOne("template,calculatetype", filter);
        if (resultObject != null) {
            boolean isChanged = this.getView().getModel().getDataChanged();
            Long templateId = resultObject.getLong("template_id");
            String calculatetype = resultObject.getString(CALCULATE_TYPE);
            this.getModel().setValue(TEMPLATE, (Object)templateId);
            this.getModel().setValue(CALCULATE_TYPE, (Object)calculatetype);
            this.getPageCache().put(TEMPLATE, templateId + "");
            this.getPageCache().put(CALCULATE_TYPE, calculatetype);
            if (!isChanged) {
                this.getView().getModel().setDataChanged(false);
            }
        }
    }

    private boolean haveDefaultTemplate() {
        DynamicObject defaultExamTemplate = RegExamTemplateRepository.getInstance().queryDefaultTemplate();
        if (ObjectUtils.isEmpty((Object)defaultExamTemplate)) {
            LOGGER.info(((Object)((Object)this)).getClass().getName() + " : there is no default exam template ... ");
            return false;
        }
        this.getModel().setValue(TEMPLATE, (Object)defaultExamTemplate);
        this.getModel().setValue(CALCULATE_TYPE, (Object)defaultExamTemplate.getString(CALCULATE_TYPE));
        return true;
    }

    private boolean isNeverApplyExam(Long employeeId) {
        QFilter filter = new QFilter("bemployee", "=", (Object)employeeId);
        String selectProperties = "bemployee,person,examstatus";
        DynamicObject object = RegProcessRepository.getInstance().queryOne(selectProperties, new QFilter[]{filter});
        return ObjectUtils.isEmpty((Object)object) || StringUtils.isEmpty((String)object.getString("examstatus")) || "1010".equals(object.getString("examstatus"));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        this.singleCommon.afterBindData(view, false);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String oldTemplate = this.getPageCache().get(TEMPLATE);
        DynamicObject templateObject = (DynamicObject)this.getModel().getValue(TEMPLATE);
        boolean isSameTemplete = false;
        if (templateObject != null) {
            String newTemplate = templateObject.getString("id");
            isSameTemplete = HRStringUtils.equals((String)oldTemplate, (String)newTemplate);
        }
        this.singleCommon.customEvent(this.getView(), e.getKey(), isSameTemplete);
    }

    public void click(EventObject evt) {
        Control sControl = (Control)evt.getSource();
        switch (sControl.getKey()) {
            case "headimage": {
                this.singleCommon.clickAdd(this.getView(), (IFormPlugin)this);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equalsIgnoreCase((String)"save", (String)operateKey)) {
            String pageId = this.getView().getPageId();
            Map<String, Object> returnResult = this.singleCommon.clickReturn(this.getView(), pageId);
            HashSet examPersons = (HashSet)returnResult.get("askperson");
            Map roleMap = (Map)returnResult.get("rolemap");
            this.beforeAddExamPerson(examPersons, roleMap, args);
            if (!args.cancel) {
                OperateOption option = operate.getOption();
                option.setVariableValue("examperson", JSONObject.toJSONString((Object)examPersons));
                option.setVariableValue("rolemap", JSONObject.toJSONString((Object)roleMap));
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                Long personId = (Long)formShowParameter.getCustomParam("person");
                Long employeeId = (Long)formShowParameter.getCustomParam("employee");
                Long erManFileId = (Long)formShowParameter.getCustomParam("ermanfile");
                option.setVariableValue("person", String.valueOf(personId));
                option.setVariableValue("employee", String.valueOf(employeeId));
                option.setVariableValue("ermanfile", String.valueOf(erManFileId));
                option.setVariableValue("cache_self", this.getPageCache().get("cache_self"));
                this.retractOldTemplate(this.getPageCache().get(TEMPLATE), this.getModel().getDataEntity(), employeeId);
                ArrayList messageIds = new ArrayList(examPersons.size());
                HashMap detailMap = new HashMap(2 * examPersons.size());
                String userId = this.getPageCache().get("cache_self");
                for (Long examPerson : examPersons) {
                    String messageTemplateNumber = StringUtils.equals((String)String.valueOf(examPerson), (String)userId) ? "hdm_regexam_yourself" : "hdm_regexam_other";
                    Map examMessageResultMap = RegExamServiceHelper.sendExamMessageToUser((Long)erManFileId, (Long)examPerson, (String)messageTemplateNumber);
                    messageIds.add(examMessageResultMap.get("messageId"));
                    detailMap.put(examMessageResultMap.get("messageId"), examMessageResultMap.get("detailId"));
                }
                option.setVariableValue("messageIds", JSONObject.toJSONString(messageIds));
                option.setVariableValue("detailMap", JSONObject.toJSONString(detailMap));
            }
        }
    }

    private void retractOldTemplate(String oldTemplate, DynamicObject dynamicObject, Long employeeId) {
        QFilter statusFilter;
        QFilter isNewestFilter;
        QFilter employeeFilter;
        HRBaseServiceHelper helper;
        DynamicObject[] objects;
        String newTemplate = String.valueOf(dynamicObject.getLong("template_id"));
        if (!StringUtils.equals((String)oldTemplate, (String)newTemplate) && !Objects.isNull(objects = (helper = new HRBaseServiceHelper("hdm_regexamdetails")).query("message", new QFilter[]{employeeFilter = new QFilter("bemployee", "=", (Object)employeeId), isNewestFilter = new QFilter("isnewest", "in", (Object)Boolean.TRUE), statusFilter = new QFilter("status", "=", (Object)"1020")})) && objects.length > 0) {
            for (DynamicObject item : objects) {
                RegMessageServiceHelper.retractMessage((Long)item.getLong("message"));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        boolean isSuccess = afterDoOperationEventArgs.getOperationResult().isSuccess();
        if (StringUtils.equalsIgnoreCase((String)"save", (String)operateKey) && isSuccess) {
            this.getView().returnDataToParent((Object)Boolean.TRUE);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        String oldTemplate = this.getPageCache().get(TEMPLATE);
        String pageId = this.getView().getPageId();
        if (propertyName.contains("cbox")) {
            this.cBoxChange(propertyName, oldTemplate, pageId);
        } else if (HRStringUtils.equals((String)propertyName, (String)TEMPLATE)) {
            this.templateChange(e, oldTemplate, pageId);
        }
    }

    private void cBoxChange(String propertyName, String oldTemplate, String pageId) {
        DynamicObject templateObject = (DynamicObject)this.getModel().getValue(TEMPLATE);
        if (templateObject == null) {
            return;
        }
        String newTemplate = templateObject.getString("id");
        Boolean isSelcet = (Boolean)this.getModel().getValue(propertyName);
        String[] proName = propertyName.split("_");
        if (!StringUtils.isNumeric((String)proName[1])) {
            if (isSelcet.booleanValue()) {
                this.getModel().setValue(propertyName, (Object)Boolean.FALSE);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u7cfb\u7edf\u4eba\u5458\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RegExamPersonPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        Long person = Long.valueOf(proName[1]);
        boolean isSameTemplate = HRStringUtils.equals((String)oldTemplate, (String)newTemplate);
        if (isSameTemplate) {
            this.getView().setVisible(isSelcet, new String[]{"repeatasklbl" + person});
        }
        List<Long> hasSendNotDoList = this.singleCommon.getListTypeCache("cache_hassendnotdo", pageId);
        Map<Long, String> hasSendNotDoMap = this.singleCommon.getMapTypeCache("cache_hassendnotdomap", pageId);
        if (isSelcet.booleanValue() && hasSendNotDoList.contains(person) && isSameTemplate) {
            boolean isChanged = this.getView().getModel().getDataChanged();
            this.getModel().setValue(propertyName, (Object)Boolean.FALSE);
            if (!isChanged) {
                this.getView().getModel().setDataChanged(false);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"repeatasklbl" + person});
            String message = MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u5b58\u5728\u672a\u5904\u7406\u7684\u95ee\u8be2\u4efb\u52a1\uff0c\u4e0d\u53ef\u91cd\u590d\u53d1\u9001\u3002", (String)"RegExamPersonPlugin_7", (String)"hr-hdm-formplugin", (Object[])new Object[0]), hasSendNotDoMap.get(person));
            this.getView().showErrorNotification(message);
        }
    }

    private void templateChange(PropertyChangedArgs e, String oldTemplate, String pageId) {
        DynamicObject oldObjects = (DynamicObject)e.getChangeSet()[0].getOldValue();
        String oldValue = "";
        if (oldObjects != null) {
            oldValue = oldObjects.getString("id");
        }
        String newValue = "";
        DynamicObject newObjects = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (newObjects == null) {
            return;
        }
        newValue = newObjects.getString("id");
        if (!HRStringUtils.isEmpty((String)oldTemplate) && HRStringUtils.equals((String)oldValue, (String)oldTemplate)) {
            String message = ResManager.loadKDString((String)"\u5207\u6362\u8003\u8bc4\u6a21\u677f\u540e\uff0c\u5c06\u5e9f\u5f03\u5df2\u5904\u7406\u7684\u8003\u8bc4\u7ed3\u679c\uff0c\u64a4\u56de\u672a\u5904\u7406\u7684\u8003\u8bc4\u6d88\u606f\uff0c\u8bf7\u614e\u91cd\u9009\u62e9\u3002", (String)"RegExamPersonPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
        }
        boolean isSameTemplate = HRStringUtils.equals((String)oldTemplate, (String)newValue);
        this.getView().setVisible(Boolean.valueOf(isSameTemplate), new String[]{"allsendflex"});
        if (!HRStringUtils.isEmpty((String)oldTemplate) && HRStringUtils.equals((String)oldTemplate, (String)newValue)) {
            boolean isChanged = this.getView().getModel().getDataChanged();
            Long self = this.singleCommon.getSelfUserId(this.getView());
            this.getModel().setValue("cbox_" + self + "_" + "D", (Object)Boolean.FALSE);
            List<Long> tutorList = this.singleCommon.getListTypeCache("cache_tutor", pageId);
            for (Long l : tutorList) {
                this.getModel().setValue("cbox_" + l + "_" + "B", (Object)Boolean.FALSE);
            }
            List<Long> leaderList = this.singleCommon.getListTypeCache("cache_leader", pageId);
            for (Long leader : leaderList) {
                this.getModel().setValue("cbox_" + leader + "_" + "A", (Object)Boolean.FALSE);
            }
            if (!isChanged) {
                this.getView().getModel().setDataChanged(false);
            }
            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
            ArrayList nowPersonList = new ArrayList();
            this.singleCommon.putPageCache(pageId, "cache_nowInfos", arrayList);
            this.singleCommon.putPageCache(pageId, "cache_nowperson", nowPersonList);
            FlexPanelAp panelAp = this.singleCommon.getAddFlex(arrayList, pageId, true);
            this.getModel().setValue(CALCULATE_TYPE, (Object)this.getPageCache().get(CALCULATE_TYPE));
            this.getView().updateControlMetadata("addflex", panelAp.createControl());
        } else {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hdm_regtestmodel");
            DynamicObject model = helper.queryOne(CALCULATE_TYPE, (Object)Long.valueOf(newValue));
            this.getModel().setValue(CALCULATE_TYPE, model.get(CALCULATE_TYPE));
        }
    }

    private void beforeAddExamPerson(Set<Long> examPersons, Map<Long, String> roleMap, BeforeDoOperationEventArgs args) {
        String fromForm = this.getView().getParentView().getEntityId();
        if (HRStringUtils.equals((String)fromForm, (String)"hdm_personregview") || HRStringUtils.equals((String)fromForm, (String)"bos_list")) {
            if (examPersons.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u53d1\u9001\u7684\u8003\u8bc4\u4eba\u3002", (String)"RegExamPersonPlugin_6", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long employeeId = (Long)formShowParameter.getCustomParam("employee");
            Map validate = RegCommonValidatorHelper.getInstance().validateExamRegStatus(employeeId, this.getView().getParentView());
            Boolean flag = Boolean.parseBoolean((String)validate.get("validateResult"));
            if (!flag.booleanValue()) {
                String msg = (String)validate.get("msg");
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"hers_ermanfilef7list")) {
            ListSelectedRowCollection selectRowCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (selectRowCollection == null || selectRowCollection.size() < 1) {
                return;
            }
            String pageId = this.getView().getPageId();
            List<Map<String, Object>> nowReturnData = this.singleCommon.getNowAllInfoCache(pageId);
            List<Long> nowPersonList = this.singleCommon.getListTypeCache("cache_nowperson", pageId);
            List<Long> hasSendNotDoList = this.singleCommon.getListTypeCache("cache_hassendnotdo", pageId);
            Map<Long, String> hasSendNotDoMap = this.singleCommon.getMapTypeCache("cache_hassendnotdomap", pageId);
            StringBuilder message = new StringBuilder();
            int messagePerson = 0;
            int messageAllPerson = 0;
            String oldTemplate = this.getPageCache().get(TEMPLATE);
            DynamicObject templateObject = (DynamicObject)this.getModel().getValue(TEMPLATE);
            boolean isSameTemplete = false;
            if (templateObject != null) {
                String newTemplate = templateObject.getString("id");
                isSameTemplete = HRStringUtils.equals((String)oldTemplate, (String)newTemplate);
            }
            List<Long> tutorList = this.singleCommon.getListTypeCache("cache_tutor", pageId);
            List<Long> leaderList = this.singleCommon.getListTypeCache("cache_leader", pageId);
            Long self = (Long)this.getView().getFormShowParameter().getCustomParam("person");
            Object[] ids = selectRowCollection.getPrimaryKeyValues();
            HRBaseServiceHelper userServiceHelper = new HRBaseServiceHelper("bos_user");
            QFilter filter = new QFilter("id", "in", (Object)ids);
            DynamicObject[] userObjects = userServiceHelper.query("id,name,picturefield", new QFilter[]{filter});
            boolean isChanged = this.getModel().getDataChanged();
            for (DynamicObject userObject : userObjects) {
                String filed;
                boolean isNotSelect;
                Long person = userObject.getLong("id");
                HashMap<String, Object> returnRow = new HashMap<String, Object>();
                returnRow.put("person", person);
                returnRow.put("personName", userObject.getString("name"));
                returnRow.put("headsculpture", userObject.getString("picturefield"));
                boolean isNotRole = !person.equals(self) && !tutorList.contains(person) && !leaderList.contains(person);
                boolean bl = isNotSelect = !nowPersonList.contains(person);
                if (isSameTemplete && hasSendNotDoList.contains(person)) {
                    ++messageAllPerson;
                    if (messagePerson >= 3) continue;
                    message.append('\u3010').append(hasSendNotDoMap.get(person)).append('\u3011');
                    ++messagePerson;
                    continue;
                }
                if (isSameTemplete && isNotSelect && isNotRole) {
                    nowPersonList.add(person);
                    nowReturnData.add(returnRow);
                    continue;
                }
                if (isSameTemplete && isNotSelect) {
                    filed = "cbox" + person;
                    this.getModel().setValue(filed, (Object)Boolean.TRUE);
                    continue;
                }
                if (!isSameTemplete && isNotSelect && isNotRole) {
                    nowPersonList.add(person);
                    nowReturnData.add(returnRow);
                    continue;
                }
                if (isSameTemplete || !isNotSelect) continue;
                filed = "cbox" + person;
                this.getModel().setValue(filed, (Object)Boolean.TRUE);
            }
            if (!isChanged) {
                this.getModel().setDataChanged(false);
            }
            if (message.length() > 0) {
                String errorMsg = null;
                errorMsg = messagePerson > 2 ? String.format(ResManager.loadKDString((String)"%1$s\u7b49\uff08\u603b\u4eba\u6570\uff1a%2$s\uff09\u5b58\u5728\u672a\u5904\u7406\u8003\u8bc4\u4efb\u52a1\uff0c\u4e0d\u53ef\u91cd\u590d\u53d1\u9001\u3002", (String)"RegExamPersonPlugin_8", (String)"hr-hdm-formplugin", (Object[])new Object[0]), message, messageAllPerson) : String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b58\u5728\u672a\u5904\u7406\u8003\u8bc4\u4efb\u52a1\uff0c\u4e0d\u53ef\u91cd\u590d\u53d1\u9001\u3002", (String)"RegExamPersonPlugin_9", (String)"hr-hdm-formplugin", (Object[])new Object[0]), message);
                this.getView().showErrorNotification(errorMsg);
            }
            this.singleCommon.putPageCache(this.getView().getPageId(), "cache_nowInfos", nowReturnData);
            this.singleCommon.putPageCache(this.getView().getPageId(), "cache_nowperson", nowPersonList);
            FlexPanelAp panelAp = this.singleCommon.getAddFlex(nowReturnData, pageId, isSameTemplete);
            this.getView().updateControlMetadata("addflex", panelAp.createControl());
        }
    }
}

