/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.exam;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.control.HRVectorAp;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hdm.business.reg.RegExamServiceHelper;
import kd.hr.hdm.formplugin.reg.web.exam.RegExamCommon;

public class RegExamSocrePlugin
extends HRDynamicFormBasePlugin {
    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        String detailsId = (String)formShowParameter.getCustomParam("detailsId");
        DynamicObject detailsObject = RegExamServiceHelper.DETAILS_SERVICE_HELPER.queryOne("entryentity.examtype,entryentity.examitem,entryentity.entryscore", (Object)Long.valueOf(detailsId));
        DynamicObjectCollection scoreObjects = detailsObject.getDynamicObjectCollection("entryentity");
        List<Map<String, Object>> examTypeList = RegExamCommon.parseEntryEntityData(scoreObjects);
        FlexPanelAp evaluatePanelAp = this.createExamEvaluatePanelAp(examTypeList);
        HashMap<String, String> paramsMap = new HashMap<String, String>(16);
        paramsMap.put("id", evaluatePanelAp.getKey());
        paramsMap.put("items", (String)evaluatePanelAp.createControl().get("items"));
        e.getItems().add(paramsMap);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String detailsId = (String)formShowParameter.getCustomParam("detailsId");
        DynamicObject detailsObject = RegExamServiceHelper.DETAILS_SERVICE_HELPER.queryOne("opinion,score,comment", (Object)Long.valueOf(detailsId));
        String opinion = detailsObject.getString("opinion");
        BigDecimal score = detailsObject.getBigDecimal("score");
        String comment = detailsObject.getString("comment");
        this.getModel().setValue("opinion", (Object)opinion);
        this.getModel().setValue("score", (Object)score);
        this.getModel().setValue("comment", (Object)comment);
    }

    private FlexPanelAp createExamEvaluatePanelAp(List<Map<String, Object>> examTypeList) {
        FlexPanelAp examEvaluatePanel = new FlexPanelAp();
        examEvaluatePanel.setWrap(false);
        examEvaluatePanel.setKey("flexevaluate");
        for (int i = 0; i < examTypeList.size(); ++i) {
            Map<String, Object> examTypeMap = examTypeList.get(i);
            String examTypeId = String.valueOf(examTypeMap.get("examtypeid"));
            String examTypeName = String.valueOf(examTypeMap.get("examtypename"));
            List examItemList = (List)examTypeMap.get("examitemlist");
            FlexPanelAp examItemPanelAp = this.createExamTypeNamePanelAp("panelexamitem" + i, examTypeId, examTypeName);
            examEvaluatePanel.getItems().add(examItemPanelAp);
            FlexPanelAp examItemContainerPanelAp = this.createExamItemContainerPanelAp("itemcontainer" + i, examItemList);
            examEvaluatePanel.getItems().add(examItemContainerPanelAp);
        }
        return examEvaluatePanel;
    }

    private FlexPanelAp createExamTypeNamePanelAp(String apKey, String examTypeId, String examTypeName) {
        FlexPanelAp flexPanelAp = new HRFlexPanelAp.Builder(apKey).setGrow(0).setShrink(0).setWrap(false).setDirection("row").setJustifyContent("flex-start").setAlignItems("center").setBackColor("#f5f5f5").setHeight("24px").build();
        LabelAp labelAp = ((HRLabelAp.Builder)new HRLabelAp.Builder(apKey + examTypeId).setGrow(0).setShrink(0).setName(examTypeName).setFontSize(14).setForeColor("#212121").setMarginLeft("10px")).build();
        labelAp.setFontWeight("bolder");
        flexPanelAp.getItems().add(labelAp);
        return flexPanelAp;
    }

    private FlexPanelAp createExamItemContainerPanelAp(String apKey, List<Map<String, Object>> examItemList) {
        FlexPanelAp examItemContainerPanelAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(apKey).setGrow(0).setShrink(0).setWrap(false).setDirection("column").setJustifyContent("flex-start").setAlignItems("stretch").setMarginTop("12px")).setPaddingLeft("10px")).build();
        for (int j = 0; j < examItemList.size(); ++j) {
            Map<String, Object> examItemMap = examItemList.get(j);
            Long examItemId = Long.valueOf(examItemMap.get("examitemid").toString());
            String examItemName = (String)examItemMap.get("examitemname");
            Integer score = (Integer)examItemMap.get("examscore");
            FlexPanelAp evaluateItemPanelAp = this.createEvaluateItemPanelAp("panelevaluateitem" + j);
            FlexPanelAp itemNamePanelAp = this.createExamItemNamePanelAp("lblexamitemname" + j, examItemName);
            evaluateItemPanelAp.getItems().add(itemNamePanelAp);
            if (score == null) {
                score = 0;
            }
            FlexPanelAp starListPanelAp = this.createStarListPanelAp(score, examItemId);
            evaluateItemPanelAp.getItems().add(starListPanelAp);
            examItemContainerPanelAp.getItems().add(evaluateItemPanelAp);
        }
        return examItemContainerPanelAp;
    }

    private FlexPanelAp createExamItemNamePanelAp(String apKey, String examItemName) {
        FlexPanelAp flexPanelAp = new HRFlexPanelAp.Builder(apKey).setGrow(5).setShrink(0).setWrap(false).setDirection("row").build();
        LabelAp labelAp = new HRLabelAp.Builder(apKey + "lab").setGrow(0).setShrink(0).setName(examItemName).setForeColor("#212121").setFontSize(14).build();
        flexPanelAp.getItems().add(labelAp);
        return flexPanelAp;
    }

    private FlexPanelAp createEvaluateItemPanelAp(String apKey) {
        return ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(apKey).setGrow(0).setShrink(0).setWrap(false).setDirection("row").setMarginBottom("10px")).build();
    }

    private FlexPanelAp createStarListPanelAp(int score, Long itemId) {
        FlexPanelAp starListPanelAp = this.customStarListPanelAp("flexstarlist" + itemId);
        String grade = RegExamCommon.getGradeText(score);
        LabelAp gradeLabelAp = this.customGradeLabelAp("grade" + itemId, grade);
        starListPanelAp.getItems().add(gradeLabelAp);
        for (int j = 0; j < score; ++j) {
            VectorAp starVectorAp = this.customStarVectorAp("star" + itemId + j, "#FDC200");
            starListPanelAp.getItems().add(starVectorAp);
        }
        for (int k = score; k < 5; ++k) {
            VectorAp greyStarVectorAp = this.customStarVectorAp("greystar" + itemId + k, "#E5E5E5");
            starListPanelAp.getItems().add(greyStarVectorAp);
        }
        return starListPanelAp;
    }

    private FlexPanelAp customStarListPanelAp(String apKey) {
        return new HRFlexPanelAp.Builder(apKey).setGrow(0).setShrink(0).setWrap(false).setDirection("row").setJustifyContent("flex-end").build();
    }

    private VectorAp customStarVectorAp(String apKey, String foreColor) {
        return ((HRVectorAp.Builder)((HRVectorAp.Builder)new HRVectorAp.Builder(apKey).setGrow(0).setShrink(0).setNeedHoverClass(false).setClickable(false).setFontSize(14).setForeColor(foreColor).setfontClass("kdfont kdfont-xingxing_shixin").setWidth(new LocaleString("14px")).setHeight(new LocaleString("20px")).setMarginTop("3px")).setMarginLeft("10px")).build();
    }

    private LabelAp customGradeLabelAp(String apKey, String grade) {
        return ((HRLabelAp.Builder)new HRLabelAp.Builder(apKey).setName(grade).setFontSize(14).setForeColor("#999999").setShrink(0).setMarginRight("2px")).build();
    }

    private LabelAp customRegAdviceLabelAp(String apKey, String text, String foreColor) {
        String borderStyle = "1px_solid_" + foreColor;
        return ((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)new HRLabelAp.Builder(apKey).setName(text).setFontSize(14).setForeColor(foreColor).setRadius("10px").setTextAlign("center").setMarginRight("30px")).setBorderTop(borderStyle)).setBorderBottom(borderStyle)).setBorderLeft(borderStyle)).setBorderRight(borderStyle)).setPaddingTop("2px")).setPaddingBottom("2px")).setPaddingLeft("8px")).setPaddingRight("8px")).build();
    }
}

