/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.person;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hdm.business.reg.RegProcessServiceHelper;

public class RegAttachPlugin
extends HRDynamicFormBasePlugin
implements UploadListener {
    private static final String FILE_PKID = "filepkid";
    private static final String PANEL_ATTACHMENT = "attachmentpanel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(PANEL_ATTACHMENT);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long employeeId = this.getCustomId("employee");
        String regularStatus = RegProcessServiceHelper.getRegStatusByEmployee((Long)employeeId);
        if (HRStringUtils.isNotEmpty((String)regularStatus) && regularStatus.equals("1040")) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    public void afterBindData(EventObject e) {
        List attachments;
        super.afterBindData(e);
        Object pkId = this.getView().getFormShowParameter().getCustomParam("ermanfile");
        this.getPageCache().put(FILE_PKID, String.valueOf(pkId));
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(PANEL_ATTACHMENT);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hdm_regapplysource");
        QFilter filter = new QFilter("bemployee", "=", this.getView().getFormShowParameter().getCustomParam("employee"));
        QFilter auditFilter = new QFilter("billstatus", "in", (Object)new String[]{"B", "C", "D", "E"});
        DynamicObject bill = helper.queryOne("id", new QFilter[]{filter, auditFilter}, "createtime desc");
        if (!Objects.isNull(bill) && (attachments = AttachmentServiceHelper.getAttachments((String)"hdm_regbasebill", (Object)(pkId = Long.valueOf(bill.getLong("id"))), (String)PANEL_ATTACHMENT, (boolean)false)).size() != 0) {
            attachmentPanel.bindData(attachments);
            IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
            String cacheJsonString = cache.get("TampAttCache" + this.getView().getPageId());
            cacheJsonString = attachmentPanel.getAttachmentModel().getCacheJsonString(PANEL_ATTACHMENT, attachments, cacheJsonString);
            cache.put("TampAttCache" + this.getView().getPageId(), cacheJsonString);
            cache.put("AttEntityIdattachmentpanel", this.getView().getEntityId());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        cache.remove("TampAttCache" + this.getView().getPageId());
    }

    public void upload(UploadEvent evt) {
        Object[] attachs = evt.getUrls();
        ArrayList<Map> list = new ArrayList<Map>(attachs.length);
        HashMap<String, ArrayList<Map>> atts = new HashMap<String, ArrayList<Map>>();
        for (Object attach : attachs) {
            Map map = (Map)attach;
            list.add(map);
        }
        atts.put(PANEL_ATTACHMENT, list);
        String pkId = this.getPageCache().get(FILE_PKID);
        AttachmentServiceHelper.saveTempAttachments((String)this.getView().getFormShowParameter().getFormId(), (Object)pkId, (String)"hers", atts);
    }

    public void remove(UploadEvent evt) {
        String pkId = this.getPageCache().get(FILE_PKID);
        Object[] attachs = evt.getUrls();
        Map map = (Map)attachs[0];
        AttachmentServiceHelper.remove((String)this.getView().getFormShowParameter().getFormId(), (Object)pkId, map.get("uid"));
    }

    private Long getCustomId(String paramKey) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object param = customParams.get(paramKey);
        if (null != param) {
            return Long.valueOf(param.toString());
        }
        return 0L;
    }
}

