/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.person;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hdm.business.reg.RegAskServiceHelper;
import kd.hr.hdm.business.reg.RegDetailInfoHelper;
import kd.hr.hdm.business.reg.RegExamServiceHelper;
import kd.hr.hdm.business.reg.RegPeronalBillHelper;
import kd.hr.hdm.business.reg.RegProcessServiceHelper;
import kd.hr.hdm.business.reg.RegTraceHelper;
import kd.hr.hdm.business.reg.RegTraceServiceHelper;
import kd.hr.hdm.business.reg.validator.RegCommonValidatorHelper;
import kd.hr.hdm.common.reg.constants.LabRelConstants;
import kd.hr.hdm.common.reg.constants.ProbationKeyEventConstants;
import kd.hr.hdm.common.reg.constants.RegBillTypeEnum;
import kd.hr.hdm.common.reg.util.RegStatusUtil;
import kd.hr.hdm.formplugin.reg.common.ProbationKeyEventService;
import kd.hr.hdm.formplugin.reg.web.applybill.RegPageUtils;
import kd.hr.hdm.formplugin.reg.web.applybill.RegularValidatUtils;
import org.apache.commons.lang.StringUtils;

public class RegPersonalBillViewPlugin
extends HRDynamicFormBasePlugin
implements TipsListener {
    private static final String CURRENT_SELECT_ROW_ID = "CURRENT_SELECT_ROW_ID";
    private static final String TOOLBARAP = "toolbarap";
    private static final String TOOLBARAP_KEYEVENT = "toolbarap_keyevent";
    private static final String BAR_INQUIRE = "bar_inquire";
    private static final String BAR_APPRAISAL = "bar_appraisal";
    private static final String BAR_APPROVE = "bar_approve";
    private static final String BAR_DIRECTREG = "bar_directreg";
    private static final String BAR_MODIFY = "bar_modify";
    private static final String BAR_EXTENDED = "bar_extended";
    private static final String BAR_ADDKEYEVENT = "bar_addkeyevent";
    private static final String LBL_ADD = "lbl_add";
    private static final String CALLBACKID_MYCALLBACK = "mycallback";
    private static final String REGULAR_STATUS = "regularStatus";
    private static final String FLEX_REGING = "flexreging";
    private static final String FLEX_ENDREG = "flexendreg";
    private static final String BILLLIST_ASK = "ask_billlistap";
    private static final String FLEX_ASKFILE = "flexaskfile";
    private static final String FLEX_ASKFILE_NODATA = "flexaskfilenodata";
    private static final String LBL_NEW = "newlabel";
    private static final String ADV_CONTROLAP = "advcontoolbarap";
    private static final String ADD_ASK = "add_ask";
    private static final String REFRESH_ASK = "refresh_ask";
    private static final String REFRESH_EXAM = "refresh_exam";
    private static final String BTN_URGE = "btn_urge";
    private static final String BTN_RETRACT = "btn_retract";
    private static final String ASK_PANEL = "advconchildpanelap1";
    private static final String BILLLIST_EXAM = "exam_billlistap";
    private static final String ADD_EXAM = "add_exam";
    private static final String LBL_NEW_EXAM = "newlabel_exam";
    private static final String BTN_URGE_EXAM = "btn_urge_exam";
    private static final String BTN_RETRACT_EXAM = "btn_retract_exam";
    private static final String BTN_VIEWSCORE = "btn_viewscore";
    private static final String EXAM_PANEL = "advconchildpanelap2";
    private static String FLEXNODATA = "flexnodata";
    private static String FLEXCONTENT = "flexcontent";
    private static final String OP_URGE_ASK = "urgeask";
    private static final String OP_RETRACT_ASK = "retractask";
    private static final String OP_URGE_EXAM = "urgeexam";
    private static final String OP_RETRACT_EXAM = "retractexam";
    private static final String OP_INQUIRE = "inquire";
    private static final String OP_APPRAISAL = "appraisal";
    private static final String OP_APPROVE = "approve";
    private static List<Map<String, Object>> ermanfileList = null;
    private static final String[] BUSINESS_CARD_ARR = new String[]{"superior", "charge"};
    private static final Log LOGGER = LogFactory.getLog(RegPersonalBillViewPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        this.addItemClickListeners(new String[]{TOOLBARAP_KEYEVENT});
        this.addItemClickListeners(new String[]{ADV_CONTROLAP, "advcontoolbarap1"});
        this.addClickListeners(new String[]{LBL_ADD, LBL_NEW, LBL_NEW_EXAM, BTN_URGE, BTN_RETRACT, BTN_URGE_EXAM, BTN_RETRACT_EXAM, BTN_VIEWSCORE});
        Arrays.stream(BUSINESS_CARD_ARR).forEach(this::addTipsListener);
        this.registerAskList();
        this.registerExamList();
    }

    public void createNewData(BizDataEventArgs e) {
        Object entity = EntityMetadataCache.getDataEntityType((String)"hdm_personregview").createInstance();
        e.setDataEntity(entity);
        Long employeeId = this.getCustomId("employee");
        String regularStatus = RegProcessServiceHelper.getRegStatusByEmployee((Long)employeeId);
        this.getView().getPageCache().put(REGULAR_STATUS, regularStatus);
        this.getView().setStatus(OperationStatus.VIEW);
        Long erManFileId = this.getCustomId("ermanfile");
        ArrayList<Long> erManFileIdList = new ArrayList<Long>();
        erManFileIdList.add(erManFileId);
        ermanfileList = (List)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getCardFields", (Object[])new Object[]{erManFileIdList});
        if (!CollectionUtils.isEmpty(ermanfileList)) {
            Map<String, Object> ermanfile = ermanfileList.get(0);
            List superiorList = (List)ermanfile.get("superiorinfo");
            List chargeList = (List)ermanfile.get("chargeinfo");
            if (!CollectionUtils.isEmpty((Collection)superiorList)) {
                this.getPageCache().put("superior", JSONObject.toJSONString((Object)superiorList));
            }
            if (!CollectionUtils.isEmpty((Collection)chargeList)) {
                this.getPageCache().put("charge", JSONObject.toJSONString((Object)chargeList));
            }
            RegPeronalBillHelper.getInstance().loadCommonPersonInfo(ermanfile, this.getView());
            this.loadErmanFilePanel(ermanfile, (DynamicObject)entity);
        }
        RegPeronalBillHelper.getInstance().loadRegularBaseInfo(employeeId, regularStatus, (DynamicObject)entity, this.getView());
        this.loadEmptutorInfo(employeeId, (DynamicObject)entity);
        this.loadRegularAskPage(employeeId, (DynamicObject)entity);
        this.loadRegularAppraisalPage(employeeId, (DynamicObject)entity);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (!CollectionUtils.isEmpty(ermanfileList)) {
            Map<String, Object> erManfile = ermanfileList.get(0);
            RegPeronalBillHelper.getInstance().loadChargeInfoAndSup(erManfile, this.getView());
        }
        String regularStatus = this.getPageCache().get(REGULAR_STATUS);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        boolean isQuit = this.isQuit((Long)formShowParameter.getCustomParam("employee"));
        this.getPageCache().put("isQuit", String.valueOf(isQuit));
        this.loadKeyEventPanel();
        this.showAskList(regularStatus, isQuit);
        this.showExamList(regularStatus, isQuit);
    }

    private boolean isQuit(Long employeeId) {
        Long laborrelStatus = RegPeronalBillHelper.getInstance().queryLabRelStatusCls(employeeId);
        return LabRelConstants.QUIT.equals(laborrelStatus);
    }

    private void showAskList(String regularStatus, boolean isQuit) {
        boolean regComplete;
        QFilter isNew;
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("hdm_regaskdetails");
        Long bemployee = (Long)this.getView().getFormShowParameter().getCustomParam("employee");
        QFilter employeeFilter = new QFilter("bemployee", "=", (Object)bemployee);
        boolean askList = detailHelper.isExists(new QFilter[]{employeeFilter, isNew = new QFilter("isnewest", "=", (Object)Boolean.TRUE)});
        if (askList) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_ASKFILE_NODATA});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_ASKFILE, ADV_CONTROLAP});
            this.registerAskList();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_ASKFILE, ADV_CONTROLAP});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_ASKFILE_NODATA});
        }
        boolean bl = regComplete = HRStringUtils.equals((String)regularStatus, (String)"1040") || HRStringUtils.equals((String)regularStatus, (String)"1050");
        if (regComplete || isQuit) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_REGING, ADD_ASK, REFRESH_ASK});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_ENDREG});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_ENDREG});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_REGING, ADD_ASK, REFRESH_ASK});
        }
    }

    private void registerAskList() {
        final IFormView view = this.getView();
        Long bemployee = (Long)this.getView().getFormShowParameter().getCustomParam("employee");
        final QFilter employeeFilter = new QFilter("bemployee", "=", (Object)bemployee);
        BillList askBillList = (BillList)this.getView().getControl(BILLLIST_ASK);
        askBillList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent setFilterEvent) {
                QFilter isNew = new QFilter("isnewest", "=", (Object)Boolean.TRUE);
                setFilterEvent.getQFilters().add(employeeFilter);
                setFilterEvent.getQFilters().add(isNew);
                setFilterEvent.setOrderBy("fmodifytime desc");
            }
        });
        askBillList.addPackageDataListener((Consumer)new Consumer<PackageDataEvent>(){

            @Override
            public void accept(PackageDataEvent packageDataEvent) {
                AbstractColumnDesc columnDesc = (AbstractColumnDesc)packageDataEvent.getSource();
                DynamicObject rowObject = packageDataEvent.getRowData();
                switch (columnDesc.getFieldKey()) {
                    case "comment": {
                        String comment = rowObject.getString("comment");
                        String opinion = rowObject.getString("opinion");
                        if (!HRStringUtils.isEmpty((String)comment) || !HRStringUtils.isEmpty((String)opinion)) break;
                        packageDataEvent.setFormatValue((Object)ResManager.loadKDString((String)"\u672a\u53cd\u9988", (String)"RegPersonalBillViewPlugin_18", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case "visible": {
                        boolean visible = true;
                        packageDataEvent.setFormatValue((Object)visible);
                        break;
                    }
                    case "askperson.picturefield": {
                        if (!StringUtils.isBlank((String)((String)packageDataEvent.getFormatValue()))) break;
                        packageDataEvent.setFormatValue((Object)"/images/pc/emotion/default_person_82_82.png");
                        break;
                    }
                }
            }
        });
        askBillList.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                if (!Objects.isNull(evt.getCurrentListSelectedRow())) {
                    view.getPageCache().put(RegPersonalBillViewPlugin.CURRENT_SELECT_ROW_ID, evt.getCurrentListSelectedRow().getPrimaryKeyValue().toString());
                }
            }
        });
    }

    private void showExamList(String regularStatus, boolean isQuit) {
        boolean regComplete;
        QFilter isNew;
        IFormView view = this.getView();
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("hdm_regexamdetails");
        Long bemployee = (Long)this.getView().getFormShowParameter().getCustomParam("employee");
        QFilter employeeFilter = new QFilter("bemployee", "=", (Object)bemployee);
        boolean examList = detailHelper.isExists(new QFilter[]{employeeFilter, isNew = new QFilter("isnewest", "=", (Object)Boolean.TRUE)});
        if (examList) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexexamfilenodata"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"fieldsetpanelap3", BILLLIST_EXAM, "advcontoolbarap1"});
            this.registerExamList();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap3", BILLLIST_EXAM, "advcontoolbarap1"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexexamfilenodata"});
        }
        boolean bl = regComplete = HRStringUtils.equals((String)regularStatus, (String)"1040") || HRStringUtils.equals((String)regularStatus, (String)"1050");
        if (regComplete || isQuit) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexreging_exam", ADD_EXAM, REFRESH_EXAM});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexendreg_exam"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexendreg_exam"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexreging_exam", ADD_EXAM, REFRESH_EXAM});
        }
    }

    private void registerExamList() {
        final IFormView view = this.getView();
        Long bemployee = (Long)this.getView().getFormShowParameter().getCustomParam("employee");
        final QFilter employeeFilter = new QFilter("bemployee", "=", (Object)bemployee);
        BillList examBillList = (BillList)this.getView().getControl(BILLLIST_EXAM);
        examBillList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent setFilterEvent) {
                QFilter isNew = new QFilter("isnewest", "=", (Object)Boolean.TRUE);
                setFilterEvent.getQFilters().add(employeeFilter);
                setFilterEvent.getQFilters().add(isNew);
                setFilterEvent.setOrderBy("fmodifytime desc");
            }
        });
        examBillList.addPackageDataListener((Consumer)new Consumer<PackageDataEvent>(){

            @Override
            public void accept(PackageDataEvent packageDataEvent) {
                AbstractColumnDesc columnDesc = (AbstractColumnDesc)packageDataEvent.getSource();
                DynamicObject rowObject = packageDataEvent.getRowData();
                switch (columnDesc.getFieldKey()) {
                    case "comment": {
                        String comment = rowObject.getString("comment");
                        String opinion = rowObject.getString("opinion");
                        if (!HRStringUtils.isEmpty((String)comment) || !HRStringUtils.isEmpty((String)opinion)) break;
                        packageDataEvent.setFormatValue((Object)ResManager.loadKDString((String)"\u672a\u53cd\u9988", (String)"RegPersonalBillViewPlugin_18", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    case "visible": {
                        boolean visible = (Boolean)view.getFormShowParameter().getCustomParam("visible");
                        packageDataEvent.setFormatValue((Object)visible);
                        break;
                    }
                    case "examperson.picturefield": {
                        if (!StringUtils.isBlank((String)((String)packageDataEvent.getFormatValue()))) break;
                        packageDataEvent.setFormatValue((Object)"/images/pc/emotion/default_person_82_82.png");
                        break;
                    }
                }
            }
        });
        examBillList.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                if (!Objects.isNull(evt.getCurrentListSelectedRow())) {
                    view.getPageCache().put(RegPersonalBillViewPlugin.CURRENT_SELECT_ROW_ID, evt.getCurrentListSelectedRow().getPrimaryKeyValue().toString());
                }
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String regStatus = this.getView().getPageCache().get(REGULAR_STATUS);
        Long employeeId = this.getCustomId("employee");
        this.hideViewByBillStatus(employeeId, regStatus);
        this.setRegStatusLabel();
    }

    private void setRegStatusLabel() {
        String regStatus = this.getView().getPageCache().get(REGULAR_STATUS);
        IFormView formView = this.getView();
        String content = RegStatusUtil.getRegStatusDesc((String)regStatus);
        LabelAp statusLabel = new LabelAp();
        statusLabel.setKey("regstatus");
        statusLabel.setName(new LocaleString(content));
        Style style = new Style();
        Border border = new Border();
        String borderColor = "";
        style.setBorder(border);
        switch (regStatus) {
            case "1010": {
                statusLabel.setForeColor("#FF991C");
                statusLabel.setBackColor("#FFFBF2");
                borderColor = "#FFCB78";
                break;
            }
            case "1020": 
            case "1030": {
                statusLabel.setForeColor("#276FF5");
                statusLabel.setBackColor("#F2F9FF");
                borderColor = "#85B8FF";
                break;
            }
            case "1040": {
                statusLabel.setForeColor("#1BA854");
                statusLabel.setBackColor("#F2FFF5");
                borderColor = "#6DD18E";
                break;
            }
            case "1050": {
                statusLabel.setForeColor("#666666");
                statusLabel.setBackColor("#F5F5F5");
                borderColor = " #CCCCCC";
            }
        }
        String borderType = "1px_solid_" + borderColor;
        border.setTop(borderType);
        border.setBottom(borderType);
        border.setLeft(borderType);
        border.setRight(borderType);
        style.setBorder(border);
        Padding padding = new Padding();
        padding.setTop("2px");
        padding.setBottom("2px");
        padding.setLeft("8px");
        padding.setRight("8px");
        style.setPadding(padding);
        statusLabel.setStyle(style);
        formView.updateControlMetadata(statusLabel.getKey(), statusLabel.createControl());
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        String regStatus = "";
        Long employeeId = this.getCustomId("employee");
        boolean isQuit = this.isQuit(employeeId);
        switch (itemKey) {
            case "bar_addkeyevent": {
                this.openKeyEvent();
                break;
            }
            case "refresh_ask": {
                regStatus = RegProcessServiceHelper.getRegStatusByEmployee((Long)employeeId);
                this.refreshAskPanel(regStatus, isQuit, employeeId);
                break;
            }
            case "refresh_exam": {
                regStatus = RegProcessServiceHelper.getRegStatusByEmployee((Long)employeeId);
                this.refreshExamPanel(regStatus, isQuit, employeeId);
                break;
            }
        }
    }

    private void addRegExam() {
        FormShowParameter currentForm = this.getView().getFormShowParameter();
        Long employeeId = (Long)currentForm.getCustomParam("employee");
        Map validate = RegCommonValidatorHelper.getInstance().validateExamRegStatus(employeeId, this.getView());
        Boolean flag = Boolean.parseBoolean((String)validate.get("validateResult"));
        if (!flag.booleanValue()) {
            String msg = (String)validate.get("msg");
            String regStatus = this.getPageCache().get("regstatus");
            boolean isQuit = this.isQuit(employeeId);
            this.getView().showErrorNotification(msg);
            this.refreshExamPanel(regStatus, isQuit, employeeId);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hdm_examperson");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("employee", currentForm.getCustomParam("employee"));
        showParameter.setCustomParam("person", currentForm.getCustomParam("person"));
        showParameter.setCustomParam("ermanfile", currentForm.getCustomParam("ermanfile"));
        this.buildSupAndTutorParameter(showParameter);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hdm_examperson"));
        showParameter.setHasRight(true);
        this.getView().showForm(showParameter);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "lbl_add": {
                this.openKeyEvent();
                break;
            }
            case "btn_viewscore": {
                this.viewExamScore();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        Long employeeId = (Long)this.getView().getFormShowParameter().getCustomParam("employee");
        String detailsId = this.getView().getPageCache().get(CURRENT_SELECT_ROW_ID);
        Long erManFileId = this.getCustomId("ermanfile");
        Map validateResult = new HashMap();
        Boolean flag = Boolean.TRUE;
        OperateOption option = operate.getOption();
        switch (operateKey) {
            case "urgeask": {
                validateResult = RegCommonValidatorHelper.getInstance().validateUrgeAsk(Long.valueOf(detailsId), employeeId);
                flag = Boolean.parseBoolean((String)validateResult.get("validateResult"));
                if (!flag.booleanValue()) {
                    this.getView().showErrorNotification((String)validateResult.get("msg"));
                    args.setCancel(true);
                    break;
                }
                Long newMessageId = RegDetailInfoHelper.getInstance().urgeRegAsk(detailsId, erManFileId);
                option.setVariableValue("newMessageId", String.valueOf(newMessageId));
                break;
            }
            case "retractask": {
                validateResult = RegCommonValidatorHelper.getInstance().validateRetractAsk(Long.valueOf(detailsId));
                flag = Boolean.parseBoolean((String)validateResult.get("validateResult"));
                if (flag.booleanValue()) break;
                this.getView().showErrorNotification((String)validateResult.get("msg"));
                args.setCancel(true);
                break;
            }
            case "urgeexam": {
                validateResult = RegCommonValidatorHelper.getInstance().validateUrgeExam(Long.valueOf(detailsId), employeeId);
                flag = Boolean.parseBoolean((String)validateResult.get("validateResult"));
                if (!flag.booleanValue()) {
                    this.getView().showErrorNotification((String)validateResult.get("msg"));
                    args.setCancel(true);
                    break;
                }
                Long newMessageId = RegDetailInfoHelper.getInstance().urgeRegExam(detailsId, erManFileId);
                option.setVariableValue("newMessageId", String.valueOf(newMessageId));
                break;
            }
            case "retractexam": {
                validateResult = RegCommonValidatorHelper.getInstance().validateRetractExam(Long.valueOf(detailsId));
                flag = Boolean.parseBoolean((String)validateResult.get("validateResult"));
                if (flag.booleanValue()) break;
                this.getView().showErrorNotification((String)validateResult.get("msg"));
                args.setCancel(true);
                break;
            }
        }
        option.setVariableValue(CURRENT_SELECT_ROW_ID, detailsId);
        option.setVariableValue("ermanfile", String.valueOf(erManFileId));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        Long employeeId = this.getCustomId("employee");
        boolean isQuit = this.isQuit(employeeId);
        String regularStatus = RegProcessServiceHelper.getRegStatusByEmployee((Long)employeeId);
        if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "urgeask": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u9001\u95ee\u8be2\u50ac\u529e\u3002", (String)"RegPersonalBillViewPlugin_14", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    this.refreshAskPanel(regularStatus, isQuit, employeeId);
                    break;
                }
                case "retractask": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u56de\u6210\u529f", (String)"RegPersonalBillViewPlugin_13", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    this.refreshAskPanel(regularStatus, isQuit, employeeId);
                    break;
                }
                case "urgeexam": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u9001\u8003\u8bc4\u50ac\u529e\u3002", (String)"RegPersonalBillViewPlugin_15", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    this.refreshExamPanel(regularStatus, isQuit, employeeId);
                    break;
                }
                case "retractexam": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u56de\u6210\u529f", (String)"RegPersonalBillViewPlugin_13", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    this.refreshExamPanel(regularStatus, isQuit, employeeId);
                    break;
                }
                case "approve": {
                    if (!RegPageUtils.haveLicence(this.getCustomId("person"), this.getView())) {
                        return;
                    }
                    HashMap<String, Object> focusRowMap = new HashMap<String, Object>();
                    focusRowMap.put("employee", employeeId);
                    focusRowMap.put("regstatus", regularStatus);
                    RegularValidatUtils.validatEmployeeForList(focusRowMap);
                    this.regularApply("hdm_regbasebill", ResManager.loadKDString((String)"\u8f6c\u6b63\u7533\u8bf7\u5355", (String)"RegPersonalBillViewPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]), RegBillTypeEnum.HR.getStatus());
                    break;
                }
                case "inquire": {
                    this.addRegAsk();
                    break;
                }
                case "appraisal": {
                    this.addRegExam();
                    break;
                }
            }
        }
    }

    private void refreshAskPanel(String regularStatus, boolean isQuit, Long employeeId) {
        this.loadRegularAskPage(employeeId, this.getModel().getDataEntity());
        this.showAskList(regularStatus, isQuit);
        this.getView().updateView(ASK_PANEL);
    }

    private void refreshExamPanel(String regularStatus, boolean isQuit, Long employeeId) {
        this.loadRegularAppraisalPage(employeeId, this.getModel().getDataEntity());
        this.showExamList(regularStatus, isQuit);
        this.getView().updateView(EXAM_PANEL);
    }

    private void viewExamScore() {
        String detailsId = this.getView().getPageCache().get(CURRENT_SELECT_ROW_ID);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hdm_regexamview");
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("detailsId", (Object)detailsId);
        this.getView().showForm(parameter);
    }

    private void addRegAsk() {
        FormShowParameter currentForm = this.getView().getFormShowParameter();
        Long employeeId = (Long)currentForm.getCustomParam("employee");
        Map validate = RegCommonValidatorHelper.getInstance().validateAskRegStatus(employeeId, this.getView());
        Boolean flag = Boolean.parseBoolean((String)validate.get("validateResult"));
        if (!flag.booleanValue()) {
            String msg = (String)validate.get("msg");
            String regStatus = this.getPageCache().get("regstatus");
            boolean isQuit = this.isQuit(employeeId);
            this.getView().showErrorNotification(msg);
            this.refreshAskPanel(regStatus, isQuit, employeeId);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hdm_askperson");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("employee", (Object)employeeId);
        showParameter.setCustomParam("person", currentForm.getCustomParam("person"));
        showParameter.setCustomParam("ermanfile", currentForm.getCustomParam("ermanfile"));
        this.buildSupAndTutorParameter(showParameter);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hdm_askperson"));
        showParameter.setHasRight(true);
        this.getView().showForm(showParameter);
    }

    private void buildSupAndTutorParameter(FormShowParameter showParameter) {
        String tutorStr;
        String superiorStr = this.getPageCache().get("superior");
        if (StringUtils.isNotBlank((String)superiorStr)) {
            List superiorList = (List)JSONObject.parseObject((String)superiorStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
            showParameter.setCustomParam("superior", (Object)superiorList);
        }
        if (StringUtils.isNotBlank((String)(tutorStr = this.getPageCache().get("tutor")))) {
            List tutorList = (List)JSONObject.parseObject((String)tutorStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
            showParameter.setCustomParam("tutor", (Object)tutorList);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Long employeeId = this.getCustomId("employee");
        boolean isQuit = this.isQuit(employeeId);
        String regStatus = "";
        Boolean isSuccess = (Boolean)closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "hdm_askperson": {
                regStatus = RegProcessServiceHelper.getRegStatusByEmployee((Long)employeeId);
                this.refreshAskPanel(regStatus, isQuit, employeeId);
                this.refreshRegTrace(employeeId);
                if (isSuccess == null || !isSuccess.booleanValue()) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u9001\u6210\u529f", (String)"RegPersonalBillViewPlugin_17", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "hdm_examperson": {
                regStatus = RegProcessServiceHelper.getRegStatusByEmployee((Long)employeeId);
                this.refreshExamPanel(regStatus, isQuit, employeeId);
                this.refreshRegTrace(employeeId);
                if (isSuccess == null || !isSuccess.booleanValue()) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u9001\u6210\u529f", (String)"RegPersonalBillViewPlugin_17", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)CALLBACKID_MYCALLBACK)) {
            this.loadKeyEventPanel();
        }
    }

    private void refreshRegTrace(Long employeeId) {
        boolean isExist = RegTraceServiceHelper.isExistTrace((Long)employeeId);
        if (isExist) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXNODATA});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXCONTENT});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXCONTENT});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXNODATA});
        }
        FlexPanelAp askTraceAp = RegTraceHelper.getInstance().createRegMsgFlowPanelAp(employeeId);
        this.getView().updateControlMetadata("flexmsgflowlist", askTraceAp.createControl());
    }

    private void regularApply(String pageKey, String caption, String billType) {
        Long employeeId = this.getCustomId("employee");
        Long personId = this.getCustomId("person");
        Long erManFileId = this.getCustomId("ermanfile");
        ArrayList<Long> employeeList = new ArrayList<Long>();
        employeeList.add(employeeId);
        DynamicObject personObj = new HRBaseServiceHelper("hrpi_person").queryOne((Object)personId);
        String personName = personObj == null ? "" : "-" + personObj.getString("name");
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(pageKey);
        billShowParameter.setCaption(caption + personName);
        billShowParameter.setCustomParam("regbilltype", (Object)billType);
        HashMap<String, Object> customParamMap = new HashMap<String, Object>();
        customParamMap.put("person", Collections.singletonList(personId));
        customParamMap.put("employee", employeeList);
        customParamMap.put("regbilltype", billType);
        customParamMap.put("ermanfile", erManFileId);
        billShowParameter.setCustomParams(customParamMap);
        billShowParameter.setCustomParam("reg_apply_source_other_tag", (Object)"reg_apply_source_other_tag");
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void openKeyEvent() {
        Map<String, Object> paramMap = this.buildKeyEventParamMap();
        ProbationKeyEventService.getInstance().openKeyEventByWeb((AbstractFormPlugin)this, this.getView(), paramMap, CALLBACKID_MYCALLBACK);
    }

    private void hideViewByBillStatus(Long employeeId, String regularStatus) {
        this.initViewState();
        switch (regularStatus = HRStringUtils.isEmpty((String)regularStatus) ? "1010" : regularStatus) {
            case "1010": {
                this.getView().setVisible(Boolean.TRUE, new String[]{BAR_INQUIRE, BAR_APPRAISAL, BAR_APPROVE, BAR_DIRECTREG});
                break;
            }
            case "1020": {
                this.getView().setVisible(Boolean.TRUE, new String[]{BAR_INQUIRE, BAR_APPRAISAL});
                break;
            }
            case "1030": {
                this.getView().setVisible(Boolean.TRUE, new String[]{BAR_INQUIRE, BAR_APPRAISAL});
                break;
            }
            case "1040": {
                break;
            }
            case "1050": {
                break;
            }
        }
        this.hiddenBtnByIsQuit();
    }

    private void hiddenBtnByIsQuit() {
        boolean isQuit = Boolean.parseBoolean(this.getPageCache().get("isQuit"));
        if (isQuit) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_DIRECTREG, BAR_INQUIRE, BAR_APPRAISAL, BAR_APPROVE, BAR_EXTENDED, BAR_MODIFY});
        }
    }

    private void initViewState() {
        this.getView().setVisible(Boolean.FALSE, new String[]{BAR_APPROVE});
        this.getView().setVisible(Boolean.FALSE, new String[]{BAR_DIRECTREG});
        this.getView().setVisible(Boolean.FALSE, new String[]{BAR_MODIFY});
        this.getView().setVisible(Boolean.FALSE, new String[]{BAR_INQUIRE});
        this.getView().setVisible(Boolean.FALSE, new String[]{BAR_APPRAISAL});
        this.getView().setVisible(Boolean.FALSE, new String[]{BAR_EXTENDED});
    }

    private void loadErmanFilePanel(Map<String, Object> ermanfile, DynamicObject entity) {
        if (!Objects.isNull(ermanfile)) {
            Label org = (Label)this.getControl("org");
            org.setText((String)ermanfile.get("org"));
            Label affiliateAdminOrg = (Label)this.getControl("affiliateadminorg");
            affiliateAdminOrg.setText((String)ermanfile.get("affiliateadminorg"));
            Label empgroup = (Label)this.getControl("empgroup");
            empgroup.setText((String)ermanfile.get("empgroup"));
        }
    }

    private void loadEmptutorInfo(Long employeeId, DynamicObject entity) {
        List tutorList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listBatchPropEmployeeAttachs", (Object[])new Object[]{Collections.singletonList(employeeId), "tutor.name,tutor.headsculpture,tutor_id", "hrpi_emptutor"});
        if (!CollectionUtils.isEmpty((Collection)tutorList) && (Long)((Map)tutorList.get(0)).get("tutor_id") != 0L) {
            this.getPageCache().put("tutor", JSONObject.toJSONString((Object)tutorList));
            Map tutor = (Map)tutorList.get(0);
            entity.set("tutor", tutor.get("tutor.name"));
            Long tutorId = (Long)tutor.get("tutor_id");
            DynamicObject ermanfile = (DynamicObject)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getPrimaryErmanfFile", (Object[])new Object[]{tutorId});
            if (!Objects.isNull(ermanfile)) {
                DynamicObject empposorgrel = (DynamicObject)ermanfile.get("empposrel");
                entity.set("tutorenterprise", (Object)empposorgrel.getString("company.name"));
                entity.set("tutoradminorg", (Object)empposorgrel.getString("adminorg.name"));
                String position = empposorgrel.getString("position.name");
                String stdposition = empposorgrel.getString("stdposition.name");
                entity.set("tutorposition", (Object)(StringUtils.isNotEmpty((String)stdposition) ? stdposition : position));
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap9"});
        }
    }

    private void loadRegularAskPage(Long bemployee, DynamicObject entity) {
        QFilter employeeFilter = new QFilter("bemployee", "=", (Object)bemployee);
        DynamicObject resultObject = RegAskServiceHelper.RESULT_SERVICE_HELPER.queryOne("askresult", employeeFilter);
        if (resultObject != null) {
            String result = resultObject.getString("askresult");
            entity.set("result", (Object)result);
        }
    }

    private void loadRegularAppraisalPage(Long bemployee, DynamicObject entity) {
        QFilter employeeFilter = new QFilter("bemployee", "=", (Object)bemployee);
        DynamicObject resultObject = RegExamServiceHelper.RESULT_SERVICE_HELPER.queryOne("template,examresult,calculatetype,examscore", employeeFilter);
        if (resultObject != null) {
            DynamicObject templete = (DynamicObject)resultObject.get("template");
            entity.set("template", templete.get("name"));
            entity.set("calculatetype", resultObject.get("calculatetype"));
            entity.set("examscore", resultObject.get("examscore"));
            entity.set("examresult", resultObject.get("examresult"));
        }
    }

    private void loadKeyEventPanel() {
        Map<String, Object> paramMap = this.buildKeyEventParamMap();
        ProbationKeyEventService.getInstance().loadKeyEventPanel(this.getView(), "flexkeyeventmain", paramMap);
    }

    private Map<String, Object> buildKeyEventParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        Long employeeId = this.getCustomId("employee");
        paramMap.put("employee", employeeId);
        paramMap.put("person", this.getCustomId("person"));
        paramMap.put("entrydate", this.getModel().getDataEntity().get("entrydate"));
        paramMap.put("importsource", "1");
        String regStatus = RegProcessServiceHelper.getRegStatusByEmployee((Long)employeeId);
        paramMap.put("regstatus", regStatus);
        if (HRStringUtils.equals((String)"1010", (String)regStatus)) {
            paramMap.put("isvisible", ProbationKeyEventConstants.VISIBLE);
        } else {
            paramMap.put("isvisible", ProbationKeyEventConstants.INVISIBLE);
        }
        return paramMap;
    }

    private Long getCustomId(String paramKey) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object param = customParams.get(paramKey);
        if (null != param) {
            return Long.valueOf(param.toString());
        }
        return 0L;
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        Control source = (Control)evt.getSource();
        FormShowParameter formshowParameter = evt.getFormshowParameter();
        if (formshowParameter == null) {
            formshowParameter = new FormShowParameter();
        }
        String controlKey = source.getKey();
        for (String businessKey : BUSINESS_CARD_ARR) {
            if (!controlKey.startsWith(businessKey)) continue;
            String key = businessKey;
            String leaderStr = this.getPageCache().get(key);
            List leaderList = (List)JSONObject.parseObject((String)leaderStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
            Map leaderMap = (Map)leaderList.get(0);
            formshowParameter.setCustomParam("id", (Object)String.valueOf(leaderMap.get("id")));
            formshowParameter.setCustomParam("name", (Object)String.valueOf(leaderMap.get("name")));
            formshowParameter.setCustomParam("number", (Object)String.valueOf(leaderMap.get("number")));
            evt.setFormshowParameter(formshowParameter);
        }
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
    }

    private void addTipsListener(String key) {
        IFormView formView = this.getView();
        Image image = (Image)formView.getControl(String.format("%simage1", key));
        if (image != null) {
            image.addTipsListener((TipsListener)this);
        }
    }
}

