/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.workbench;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.repository.RegApplyRepository;
import kd.hr.hdm.business.repository.RegProbationPersonQueryRepository;
import kd.hr.hdm.common.reg.constants.RegBillTypeEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.util.RegCommonUtil;
import kd.hr.hdm.formplugin.reg.web.workbench.common.ProbationPersonCommonQueryListPlugin;

public class DueRegularQueryListPlugin
extends ProbationPersonCommonQueryListPlugin {
    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        QFilter filter = RegProbationPersonQueryRepository.getInstance().getDueRegQFilters(null);
        event.getQFilters().add(filter);
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        super.listRegStatusColumnCompareTypesSet(args, "hrpi_trialperiod.regstatus");
    }

    @Override
    public void beforePackageData(BeforePackageDataEvent event) {
        super.beforePackageData(event);
        DynamicObjectCollection collection = event.getPageData();
        if (collection.isEmpty()) {
            return;
        }
        List erManFileIds = collection.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        Map regBillMap = RegApplyRepository.getRepository().queryWaitRegBills(erManFileIds, new String[]{"ermanfile.id", "regbilltype", "regcategory.name", "billstatus"});
        RegCommonUtil.registerCommonProp((DynamicObjectCollection)collection, (String[])new String[]{"regbilltype", "regcategory", "billstatus"});
        collection.forEach(dy -> {
            DynamicObject regBill = (DynamicObject)regBillMap.get(dy.getLong("id"));
            if (!HRObjectUtils.isEmpty((Object)regBill)) {
                String regBillType = regBill.getString("regbilltype");
                dy.set("regbilltype", (Object)RegBillTypeEnum.getNameByNumber((String)regBillType));
                dy.set("regcategory", (Object)regBill.getString("regcategory.name"));
                String billStatus = regBill.getString("billstatus");
                dy.set("billstatus", (Object)RegBillStatusEnum.getName((String)billStatus));
            }
            this.setDefaultValue((DynamicObject)dy);
        });
    }

    @Override
    public void packageData(PackageDataEvent event) {
        String key;
        super.packageData(event);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        switch (key = columnDesc.getKey()) {
            case "regbilltype": {
                String regBillType = event.getRowData().getString("regbilltype");
                event.setFormatValue((Object)regBillType);
                break;
            }
            case "regcategory": {
                String regCategory = event.getRowData().getString("regcategory");
                event.setFormatValue((Object)regCategory);
                break;
            }
            case "billstatus": {
                String billStatus = event.getRowData().getString("billstatus");
                event.setFormatValue((Object)billStatus);
                break;
            }
        }
    }

    public void afterExportFile(ExportFileEvent evt) {
        evt.setFileName(ResManager.loadKDString((String)"\u5bfc\u51fa\u5217\u8868_\u5230\u671f\u5408\u89c4\u8f6c\u6b63\u4eba\u5458_%s", (String)"DueRegularQueryListPlugin_0", (String)"hr-hdm-formplugin", (Object[])new Object[]{HRDateTimeUtils.format((Date)new Date(), (String)"MMddHHmmss")}));
    }

    private void setDefaultValue(DynamicObject dynamicObject) {
        String examStatus;
        String askStatus = dynamicObject.getString("hrpi_trialperiod.askstatus");
        if (HRStringUtils.isEmpty((String)askStatus)) {
            dynamicObject.set("hrpi_trialperiod.askstatus", (Object)"1010");
        }
        if (HRStringUtils.isEmpty((String)(examStatus = dynamicObject.getString("hrpi_trialperiod.examstatus")))) {
            dynamicObject.set("hrpi_trialperiod.examstatus", (Object)"1010");
        }
    }
}

