/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.workbench;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.repository.RegApplyRepository;
import kd.hr.hdm.business.repository.RegProbationPersonQueryRepository;
import kd.hr.hdm.common.reg.constants.RegBillTypeEnum;
import kd.hr.hdm.common.reg.enums.PostponeAskResultEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.util.RegCommonUtil;
import kd.hr.hdm.formplugin.reg.web.workbench.provider.ProDelayWaitHandleListDataProvider;

public class ProDelayWaitHandleListPlugin
extends AbstractListPlugin {
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        RegCommonUtil.fixedListColumns((List)args.getListColumns(), (List)Lists.newArrayList((Object[])new String[]{"postponeaskresult", "handletime", "person.headsculpture", "person.name"}));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String orgStr = (String)parameter.getCustomParam("borg");
        String affiliateAdminOrgStr = (String)parameter.getCustomParam("baffiliateadminorg");
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            String fieldName = filterColumn.getFieldName();
            if (HRStringUtils.equals((String)fieldName, (String)"baffiliateadminorg.name")) {
                RegProbationPersonQueryRepository.getInstance().setMulBaseDataDefaultFilter(filterColumn, "haos_adminorghr", affiliateAdminOrgStr);
            }
            if (!HRStringUtils.equals((String)fieldName, (String)"org.name")) continue;
            RegProbationPersonQueryRepository.getInstance().setMulBaseDataDefaultFilter(filterColumn, "bos_org", orgStr);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ProDelayWaitHandleListDataProvider());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        BillShowParameter billShowParameter = new BillShowParameter();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        Object primaryKey = listSelectedRow.getPrimaryKeyValue();
        DynamicObject currentBill = HDMRegBaseBillRepository.getInstance().queryOne(primaryKey);
        String billType = currentBill.getString("regbilltype");
        if (RegBillTypeEnum.EMP.getStatus().equals(billType)) {
            billShowParameter.setFormId("hdm_regselfhelp_supply");
        } else {
            billShowParameter.setFormId("hdm_regbasebill");
        }
        billShowParameter.setPkId(billList.getFocusRowPkId());
        billShowParameter.setCustomParam("list", (Object)"list");
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        block3: {
            String listFieldKey;
            block2: {
                super.listColumnCompareTypesSet(args);
                listFieldKey = args.getListFieldKey();
                if (!HRStringUtils.equals((String)listFieldKey, (String)"postponeaskresult")) break block2;
                List comboItems = args.getComboItems();
                for (int i = comboItems.size() - 1; i >= 0; --i) {
                    ValueMapItem valueMapItem = (ValueMapItem)comboItems.get(i);
                    String value = valueMapItem.getValue();
                    if (HRStringUtils.equals((String)value, (String)PostponeAskResultEnum.PENDING_FEEDBACK.getCode()) || HRStringUtils.equals((String)value, (String)PostponeAskResultEnum.DISAGREE.getCode())) continue;
                    comboItems.remove(valueMapItem);
                }
                break block3;
            }
            if (!HRStringUtils.equals((String)listFieldKey, (String)"billstatus")) break block3;
            List comboItems = args.getComboItems();
            for (int i = comboItems.size() - 1; i >= 0; --i) {
                ValueMapItem valueMapItem = (ValueMapItem)comboItems.get(i);
                String value = valueMapItem.getValue();
                if (HRStringUtils.equals((String)value, (String)RegBillStatusEnum.ALREADYSUBMIT.getCode()) || HRStringUtils.equals((String)value, (String)RegBillStatusEnum.APPROVING.getCode()) || HRStringUtils.equals((String)value, (String)RegBillStatusEnum.WAITRESUBMIT.getCode())) continue;
                comboItems.remove(valueMapItem);
            }
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        IListView listView = (IListView)this.getView();
        EntityType entityType = listView.getListModel().getDataEntityType();
        entityType.setDisplayName(new LocaleString(this.getView().getFormShowParameter().getCaption()));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"remindconfirmdelay")) {
            FormOperate operate = (FormOperate)args.getSource();
            Map variables = operate.getOption().getVariables();
            String remindReason = (String)variables.get("remindreason");
            if (!HRStringUtils.isEmpty((String)remindReason)) {
                return;
            }
            Object[] pkValues = this.getSelectedRows().getPrimaryKeyValues();
            List ids = Arrays.stream(pkValues).map(Object::toString).map(Long::valueOf).collect(Collectors.toList());
            Map regBillMap = RegApplyRepository.getRepository().queryByIds(new String[]{"person"}, ids);
            List personNames = regBillMap.values().stream().map(regBill -> regBill.getDynamicObject("person")).map(person -> person.getString("name")).collect(Collectors.toList());
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("hdm_remindconfirmdelay");
            formShowParameter.setCustomParam("user", (Object)JSONObject.toJSONString(personNames));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "remindconfirmdelay"));
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"remindconfirmdelay") && !HRObjectUtils.isEmpty((Object)(returnData = event.getReturnData()))) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("remindreason", returnData.toString());
            operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
            OperationResult operationResult = this.getView().invokeOperation("remindconfirmdelay", operateOption);
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u50ac\u529e\u6210\u529f", (String)"ProDelayWaitHandleListPlugin_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterExportFile(ExportFileEvent evt) {
        evt.setFileName(ResManager.loadKDString((String)"\u5bfc\u51fa\u5217\u8868_\u8bd5\u7528\u5ef6\u671f\u5f85\u5904\u7406\u4eba\u5458_%s", (String)"ProDelayWaitHandleListPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[]{HRDateTimeUtils.format((Date)new Date(), (String)"MMddHHmmss")}));
    }
}

