/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.workbench;

import java.util.EventObject;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.repository.RegProbationPersonQueryRepository;
import kd.hr.hdm.formplugin.reg.web.workbench.common.RegWorkBenchCardPlugin;

public class RegTaskPlugin
extends RegWorkBenchCardPlugin {
    private static final String REG_ASK_COUNT = "regaskcount";
    private static final String REG_EXAM_COUNT = "regexamcount";

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{REG_ASK_COUNT, REG_EXAM_COUNT});
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "regaskcount": {
                this.openListPage("hdm_regaskquerylist");
                break;
            }
            case "regexamcount": {
                this.openListPage("hdm_regexamquerylist");
                break;
            }
        }
    }

    public void afterBindData(EventObject args) {
        super.afterBindData(args);
        IFormView formView = this.getView();
        QFilter filter = RegProbationPersonQueryRepository.getInstance().getOrgAndAffiliateAdminOrgFilter(formView, "affiliateadminorg", "org");
        this.setRegAskCount(filter);
        this.setRegExamCount(filter);
    }

    private void setRegAskCount(QFilter filter) {
        Label label = (Label)this.getView().getControl(REG_ASK_COUNT);
        int count = RegProbationPersonQueryRepository.getInstance().regAskCount(filter);
        label.setText(this.getDisplayText(count));
    }

    private void setRegExamCount(QFilter filter) {
        Label label = (Label)this.getView().getControl(REG_EXAM_COUNT);
        int count = RegProbationPersonQueryRepository.getInstance().regExamCount(filter);
        label.setText(this.getDisplayText(count));
    }
}

