/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.workbench.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.service.hrpi.IHRPIService;
import kd.hr.hdm.business.domain.service.hspm.IHSPMService;
import kd.hr.hdm.business.repository.RegProcessRepository;
import kd.hr.hdm.common.reg.util.RegCommonUtil;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;
import kd.hr.hdm.formplugin.reg.web.applybill.RegularBaseUtils;

public class ProbationPersonCommonListPlugin
extends AbstractListPlugin {
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        RegCommonUtil.fixedListColumns((List)args.getListColumns(), (List)Lists.newArrayList((Object[])new String[]{"person.headsculpture", "name"}));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Map<String, Object> customParams = RegularBaseUtils.getFocusRowId((Long)billList.getFocusRowPkId());
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hdm_personregview");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String name = (String)customParams.get("person_name");
        String caption = ResManager.loadKDString((String)"\u8bd5\u7528\u671f\u4fe1\u606f\u5355 - %s", (String)"ProbationPersonCommonListPlugin_0", (String)"hr-hdm-formplugin", (Object[])new Object[]{name});
        formShowParameter.setCaption(caption);
        formShowParameter.setCustomParams(customParams);
        this.getView().showForm(formShowParameter);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        IListView listView = (IListView)this.getView();
        EntityType entityType = listView.getListModel().getDataEntityType();
        entityType.setDisplayName(new LocaleString(this.getView().getFormShowParameter().getCaption()));
    }

    protected void listRegStatusColumnCompareTypesSet(ListColumnCompareTypesSetEvent args, String filedKey) {
        super.listColumnCompareTypesSet(args);
        String listFieldKey = args.getListFieldKey();
        if (HRStringUtils.equals((String)listFieldKey, (String)filedKey)) {
            List comboItems = args.getComboItems();
            for (int i = comboItems.size() - 1; i >= 0; --i) {
                ValueMapItem valueMapItem = (ValueMapItem)comboItems.get(i);
                String value = valueMapItem.getValue();
                if (!HRStringUtils.equals((String)value, (String)"1040") && !HRStringUtils.equals((String)value, (String)"1050")) continue;
                comboItems.remove(valueMapItem);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        if (result != null && result.isSuccess()) {
            switch (operateKey) {
                case "regask": {
                    this.regAskOrExam("hdm_askperson");
                    break;
                }
                case "regexam": {
                    this.regAskOrExam("hdm_examperson");
                    break;
                }
                case "regapply": {
                    RegularBaseUtils.batchRegApply((AbstractFormPlugin)this);
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "hdm_askperson": 
            case "hdm_examperson": {
                Boolean isSuccess = (Boolean)closedCallBackEvent.getReturnData();
                if (isSuccess == null || !isSuccess.booleanValue()) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u9001\u6210\u529f", (String)"ProbationPersonCommonListPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                break;
            }
            case "hdm_batchregmulconfirm": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData == null) {
                    return;
                }
                int successNum = (Integer)returnData.get("successNum");
                if (successNum == 0) {
                    return;
                }
                if (successNum > 1) {
                    TransferPageUtil.showFormViewOfNewTable((IFormView)this.getView(), (String)"hdm_batchregbill", (Map)returnData);
                    break;
                }
                JSONArray data = (JSONArray)returnData.get("data");
                JSONObject jsonObject = (JSONObject)data.get(0);
                JSONObject regInfo = (JSONObject)jsonObject.get((Object)"data");
                JSONObject ermanfileMap = (JSONObject)regInfo.get((Object)"ermanfileMap");
                long id = (Long)ermanfileMap.get((Object)"id");
                RegularBaseUtils.btnRegApply((AbstractFormPlugin)this, id);
                break;
            }
        }
    }

    private void regAskOrExam(String formId) {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        Object[] selectedRowIds = selectedRows.getPrimaryKeyValues();
        boolean isAskPage = HRStringUtils.equals((String)formId, (String)"hdm_askperson");
        if (selectedRowIds.length > 1) {
            String message = isAskPage ? ResManager.loadKDString((String)"\u4ec5\u80fd\u4e3a\u5355\u4e2a\u8bd5\u7528\u4eba\u5458\u53d1\u8d77\u8f6c\u6b63\u95ee\u8be2\u3002", (String)"ProbationPersonCommonListPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ec5\u80fd\u4e3a\u5355\u4e2a\u8bd5\u7528\u4eba\u5458\u53d1\u8d77\u8f6c\u6b63\u8003\u8bc4\u3002", (String)"ProbationPersonCommonListPlugin_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            return;
        }
        Map erManFile = IHSPMService.getInstance().getCardFieldByErManFileId((Long)selectedRowIds[0]);
        Long employeeId = (Long)erManFile.get("employee_id");
        Long personId = (Long)erManFile.get("person_id");
        DynamicObject regProcess = RegProcessRepository.getRepository().queryByEmployeeId(employeeId, new String[]{"bemployee", "regstatus", "askresult", "examresult"});
        if (!HRObjectUtils.isEmpty((Object)regProcess) && Lists.newArrayList((Object[])new String[]{"1040", "1050"}).contains(regProcess.getString("regstatus"))) {
            this.getView().showErrorNotification(isAskPage ? ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u8f6c\u6b63\u72b6\u6001\u4e3a\u201c\u5f85\u8f6c\u6b63\u201d\u201c\u8f6c\u6b63\u4e2d\u201d\u201c\u8f6c\u6b63\u5f85\u751f\u6548\u201d\u7684\u5458\u5de5\u53d1\u8d77\u201c\u8f6c\u6b63\u95ee\u8be2\u201d\u64cd\u4f5c\u3002", (String)"ProbationPersonCommonListPlugin_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u8f6c\u6b63\u72b6\u6001\u4e3a\u201c\u5f85\u8f6c\u6b63\u201d\u201c\u8f6c\u6b63\u4e2d\u201d\u201c\u8f6c\u6b63\u5f85\u751f\u6548\u201d\u7684\u5458\u5de5\u53d1\u8d77\u201c\u8f6c\u6b63\u8003\u8bc4\u201d\u64cd\u4f5c\u3002", (String)"ProbationPersonCommonListPlugin_5", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("person", (Object)personId);
        showParameter.setCustomParam("employee", (Object)employeeId);
        showParameter.setCustomParam("ermanfile", selectedRowIds[0]);
        List tutor = IHRPIService.getInstance().getTutorByEmployeeId(employeeId);
        showParameter.setCustomParam("superior", erManFile.get("superiorinfo"));
        showParameter.setCustomParam("tutor", (Object)tutor);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        showParameter.setHasRight(true);
        this.getView().showForm(showParameter);
    }
}

