/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.workbench.common;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.service.hrpi.IHRPIService;
import kd.hr.hdm.common.reg.enums.RegOpinionEnum;

public class RegAskExamExpandItemsCommonPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(RegAskExamExpandItemsCommonPlugin.class);
    protected static final String VIEW_REG_ASK = "viewregask";
    protected static final String REG_ASK_UN_SUBMIT = "regaskunsubmit";
    protected static final String VIEW_REG_EXAM = "viewregexam";
    protected static final String REG_EXAM_UN_SUBMIT = "regexamunsubmit";
    protected static final String VIEW_OPERATION_COLUMN = "viewoperationcolumn";
    protected static final String UN_SUBMIT_OPERATION_COLUMN = "unsubmitoperationcolumn";
    private static final String ORDER_BY = "modifytime desc";

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter formShowParameter = args.getFormShowParameter();
        formShowParameter.setAppId("hpb");
    }

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        this.addPackageDataListener(billList);
        this.addBeforePackageDataListener(billList);
        QFilter filter = this.getFilter();
        billList.setFilter(filter);
        billList.setOrderBy(ORDER_BY);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String message = this.handleReCheckRight();
        if (HRStringUtils.isNotEmpty((String)message)) {
            this.getView().showConfirm(message, MessageBoxOptions.OK);
            args.setCancel(true);
        }
    }

    private String handleReCheckRight() {
        IFormView formView = this.getView();
        IFormView parentView = formView.getParentView();
        if (parentView != null) {
            FormShowParameter formShowParameter = parentView.getFormShowParameter();
            if (formShowParameter.getCancelRight() == 2) {
                return this.handleCancelRight(formShowParameter);
            }
            if (formShowParameter.isCancelDataRight()) {
                return ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"RegAskExamExpandItemsCommonPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            }
        }
        return null;
    }

    private String handleCancelRight(FormShowParameter formShowParameter) {
        FormConfig config = formShowParameter.getFormConfig();
        String formName = config.getCaption().toString();
        String permItem = formShowParameter.getPermissionItemId();
        String msg = "47156aff000000ac".equals(permItem) ? String.format(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c%1$s\u201d\u65b0\u589e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"RegAskExamExpandItemsCommonPlugin_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]), formName) : ("4715a0df000000ac".equals(permItem) ? String.format(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c%1$s\u201d\u4fee\u6539\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"RegAskExamExpandItemsCommonPlugin_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]), formName) : String.format(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c%1$s\u201d\u67e5\u8be2\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"RegAskExamExpandItemsCommonPlugin_5", (String)"hr-hdm-formplugin", (Object[])new Object[0]), formName));
        return msg;
    }

    private void addBeforePackageDataListener(BillList billList) {
        billList.addBeforePackageDataListener(event -> {
            DynamicObjectCollection collection = event.getPageData();
            if (collection.size() > 0) {
                collection.forEach(row -> {
                    String opinion = row.getString("opinion");
                    if (HRStringUtils.isEmpty((String)opinion)) {
                        row.set("opinion", (Object)ResManager.loadKDString((String)"\u672a\u53cd\u9988", (String)"RegAskExamExpandItemsCommonPlugin_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    }
                });
            }
        });
    }

    private void addPackageDataListener(BillList billList) {
        billList.addPackageDataListener(pkEvent -> {
            boolean isOperationColumn;
            DynamicObject rowData = pkEvent.getRowData();
            Object opinion = rowData.get("opinion");
            boolean bl = isOperationColumn = pkEvent.getSource() instanceof ListOperationColumnDesc && Lists.newArrayList((Object[])new String[]{VIEW_OPERATION_COLUMN, UN_SUBMIT_OPERATION_COLUMN}).contains(((ListOperationColumnDesc)pkEvent.getSource()).getKey());
            if (isOperationColumn) {
                boolean opinionIsEmpty = HRStringUtils.isEmpty((String)RegOpinionEnum.getNameByNumber((String)opinion.toString()));
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    String operationKey = operationColItem.getOperationKey();
                    if (HRStringUtils.equals((String)REG_ASK_UN_SUBMIT, (String)operationKey) || HRStringUtils.equals((String)REG_EXAM_UN_SUBMIT, (String)operationKey)) {
                        operationColItem.setVisible(opinionIsEmpty);
                        continue;
                    }
                    operationColItem.setVisible(!opinionIsEmpty);
                }
            }
        });
    }

    private QFilter getFilter() {
        Long erManFileId = this.getErManFileId();
        QFilter filter = new QFilter("isnewest", "=", (Object)"1");
        DynamicObject[] erManFiles = IHRPIService.getInstance().listFieldsFilterInfo("person,employee", new QFilter("id", "=", (Object)erManFileId), "hspm_ermanfile");
        if (erManFiles.length > 0) {
            Long employeeId = Optional.ofNullable(erManFiles[0].get("employee_id")).map(Object::toString).map(Long::valueOf).orElse(0L);
            filter.and(new QFilter("bemployee", "=", (Object)employeeId));
        }
        return filter;
    }

    private Long getErManFileId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Long erManFileId = Optional.ofNullable(customParams.get("pkId")).map(Object::toString).map(Long::valueOf).orElse(0L);
        LOGGER.info("erManFileId:{}", (Object)erManFileId);
        return erManFileId;
    }

    protected void unSubmitRefreshParentView(OperationResult operationResult) {
        if (operationResult == null) {
            return;
        }
        IFormView formView = this.getView();
        IFormView parentView = formView.getParentView();
        String message = this.getOperationMessage(operationResult, ResManager.loadKDString((String)"\u64a4\u56de\u6210\u529f", (String)"RegAskExamExpandItemsCommonPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        BillList billListAp = (BillList)parentView.getControl("billlistap");
        billListAp.refresh();
        if (operationResult.isSuccess()) {
            parentView.showSuccessNotification(message);
        } else {
            parentView.showTipNotification(message);
        }
        formView.sendFormAction(parentView);
    }

    private String getOperationMessage(OperationResult operationResult, String successMessage) {
        if (operationResult != null && !operationResult.isSuccess()) {
            List validateErrors = operationResult.getAllErrorOrValidateInfo();
            if (validateErrors.size() > 0) {
                return ((IOperateInfo)validateErrors.get(0)).getMessage();
            }
            return operationResult.getMessage();
        }
        return successMessage;
    }
}

