/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.workbench.provider;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.mvc.list.ListDataProvider;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hdm.business.repository.RegApplyRepository;
import kd.hr.hdm.business.repository.RegAskResultRepository;
import kd.hr.hdm.business.repository.RegExamResultRepository;
import kd.hr.hdm.common.reg.constants.RegBillTypeEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.enums.RegResultEnum;
import kd.hr.hdm.common.reg.util.RegCommonUtil;

public class NearPreRegDateListDataProvider
extends ListDataProvider {
    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        if (rows.isEmpty()) {
            return rows;
        }
        List erManFileIds = rows.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        Map regBillMap = RegApplyRepository.getRepository().queryNearPreRegBills(erManFileIds, new String[]{"ermanfile.id", "regcategory.name", "regbilltype", "billstatus"});
        List employeeIds = rows.stream().map(dy -> dy.getLong("employee_id")).collect(Collectors.toList());
        Map askResultMap = RegAskResultRepository.getRepository().queryByPersonIds(employeeIds, new String[]{"person", "askresult"});
        Map examResultMap = RegExamResultRepository.getRepository().queryByPersonIds(employeeIds, new String[]{"person", "examresult"});
        RegCommonUtil.addTextProps((DynamicObjectCollection)rows, (String[])new String[]{"preregulardateremain", "regcategory", "regbilltype", "billstatus", "askresult", "examresult"});
        for (DynamicObject row : rows) {
            DynamicObject examResult;
            long personId;
            DynamicObject askResult;
            DynamicObject regBill;
            Date preRegularDate = row.getDate("preregulardate");
            if (preRegularDate != null) {
                row.set("preregulardateremain", (Object)ResManager.loadKDString((String)"%s\u5929", (String)"NearPreRegQueryListPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[]{HRDateTimeUtils.dateDiff((String)"d", (Date)RegCommonUtil.getNowDate(), (Date)preRegularDate)}));
            }
            if (!HRObjectUtils.isEmpty((Object)(regBill = (DynamicObject)regBillMap.get(row.getLong("id"))))) {
                row.set("regcategory", regBill.get("regcategory.name"));
                row.set("regbilltype", (Object)RegBillTypeEnum.getNameByNumber((String)regBill.getString("regbilltype")));
                row.set("billstatus", (Object)RegBillStatusEnum.getName((String)regBill.getString("billstatus")));
            }
            if (!HRObjectUtils.isEmpty((Object)(askResult = (DynamicObject)askResultMap.get(personId = row.getLong("person.id"))))) {
                row.set("askresult", (Object)RegResultEnum.getNameByNumber((String)askResult.getString("askresult")));
            }
            if (HRObjectUtils.isEmpty((Object)(examResult = (DynamicObject)examResultMap.get(personId)))) continue;
            row.set("examresult", (Object)RegResultEnum.getNameByNumber((String)examResult.getString("examresult")));
        }
        return rows;
    }
}

