/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.workbench.provider;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.util.CollectionUtils;
import kd.hr.hdm.business.domain.service.hspm.IHSPMService;
import kd.hr.hdm.business.repository.RegExamDetailsRepository;
import kd.hr.hdm.common.reg.util.RegCommonUtil;

public class RegExamItemsListDataProvider
extends ListDataProvider {
    private static final Log LOGGER = LogFactory.getLog(RegExamItemsListDataProvider.class);

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        if (rows.isEmpty()) {
            return rows;
        }
        RegCommonUtil.addTextProps((DynamicObjectCollection)rows, (String[])new String[]{"exampersonadminorg", "exampersonposition", "exampersonstdposition", "exampersonjob", "handletime"});
        List ids = rows.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        Map regExamDetailMap = RegExamDetailsRepository.getRepository().queryByIds(ids, new String[]{"examperson.id", "initiatetime", "finshtime"});
        if (regExamDetailMap.isEmpty()) {
            LOGGER.error("regExamDetailMap is empty");
            return rows;
        }
        List userIds = regExamDetailMap.values().stream().filter(dy -> dy.getLong("examperson.id") != 0L).map(dy -> dy.getLong("examperson.id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userIds)) {
            LOGGER.error("userIds is empty");
            return rows;
        }
        Map erManFileMap = IHSPMService.getInstance().getCardFieldByBosUserIds(userIds);
        rows.forEach(row -> {
            DynamicObject regExamDetail = (DynamicObject)regExamDetailMap.get(row.getLong("id"));
            String examPersonNumber = regExamDetail.getString("examperson.number");
            Map erManFile = (Map)erManFileMap.get(examPersonNumber);
            if (erManFile != null) {
                row.set("exampersonadminorg", erManFile.get("adminorg"));
                row.set("exampersonposition", erManFile.get("position"));
                row.set("exampersonstdposition", erManFile.get("stdposition"));
                row.set("exampersonjob", erManFile.get("job"));
            }
            Date initiateTime = regExamDetail.getDate("initiatetime");
            Date finishTime = regExamDetail.getDate("finshtime");
            String handleTime = RegCommonUtil.getHandleTime((Date)initiateTime, (Date)(finishTime != null ? finishTime : new Date()));
            row.set("handletime", (Object)handleTime);
        });
        return rows;
    }
}

