/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.workflow;

import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.constants.WFAuditResultTypeEnum;
import kd.bos.workflow.api.constants.WFTaskResultEnum;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IRegProbationService;
import kd.hr.hdm.common.reg.enums.PostponeAskResultUpdateSourceEnum;
import kd.hr.hdm.common.reg.enums.ProbationRemarkUpdateSourceEnum;

public class RegPostponeConfirmPlugin
implements IWorkflowPlugin {
    private static final Log LOGGER = LogFactory.getLog(RegPostponeConfirmPlugin.class);
    private static final String SELECT_PROPERTIES = "regcategory,postponeaskresult,probationremark,postponeaskstarttime,postponeaskendtime";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(AgentExecution execution) {
        try (TXHandle txHandle = TX.required();){
            String businessKey = execution.getBusinessKey();
            LOGGER.info("get businessKey:", (Object)businessKey);
            if (StringUtils.isEmpty((String)businessKey)) {
                return;
            }
            DynamicObject regObject = HDMRegBaseBillRepository.getInstance().queryOne(SELECT_PROPERTIES, (Object)Long.parseLong(businessKey));
            if (Objects.isNull(regObject)) {
                LOGGER.error("get businessKey is error,query nothing", (Object)businessKey);
                return;
            }
            Object currentTaskResult = execution.getCurrentTaskResult(WFTaskResultEnum.auditType);
            if (HRObjectUtils.isEmpty((Object)currentTaskResult)) {
                regObject.set("postponeaskstarttime", (Object)new Date());
                regObject.set("postponeaskendtime", null);
            } else {
                regObject.set("postponeaskendtime", (Object)new Date());
            }
            PostponeAskResultUpdateSourceEnum postponeAskResultUpdateSourceEnum = PostponeAskResultUpdateSourceEnum.ENTER_POSTPONE_CONFIRM_NODE;
            ProbationRemarkUpdateSourceEnum probationRemarkUpdateSourceEnum = null;
            if (HRObjectUtils.equals((Object)currentTaskResult, (Object)WFAuditResultTypeEnum.reject.getValue())) {
                postponeAskResultUpdateSourceEnum = PostponeAskResultUpdateSourceEnum.PERSONNEL_DISAGREE;
            }
            if (HRObjectUtils.equals((Object)currentTaskResult, (Object)WFAuditResultTypeEnum.approve.getValue())) {
                postponeAskResultUpdateSourceEnum = PostponeAskResultUpdateSourceEnum.PERSONNEL_AGREE;
                probationRemarkUpdateSourceEnum = ProbationRemarkUpdateSourceEnum.PERSONNEL_AGREE;
            }
            IRegProbationService.getInstance().setPostponeAskResult(new DynamicObject[]{regObject}, postponeAskResultUpdateSourceEnum);
            IRegProbationService.getInstance().setProbationRemark(new DynamicObject[]{regObject}, probationRemarkUpdateSourceEnum);
            HDMRegBaseBillRepository.getInstance().updateOne(regObject);
        }
    }
}

