/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.mobile.base;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.common.transfer.enums.TransferOriginatorEnum;
import kd.hr.hdm.common.transfer.enums.WorkFlowFlagEnum;
import kd.hr.hdm.common.transfer.util.DyTransferUtil;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;

public class TransferBaseAuditMobPlugin
extends AbstractMobBillPlugIn {
    private static final String PANEL_HEAD = "headpanel";
    private static final String PANEL_TRANSFER_JOBINFO = "transferjobinfopanel";
    private static final String PANEL_TRANSFER_JOBLEVEL = "transferjoblevelpanel";
    private static final String PAGE_TRANSFERLAYOUT_HEAD_M = "hdm_transferlayout_head_m";
    private static final String PAGE_TRANSFERT_JOBINFO_M = "hdm_transfer_jobinfo_m";
    private static final String PAGE_TRANSFERT_JOBLEVEL_M = "hdm_transfer_joblevel_m";

    public void beforeBindData(EventObject e) {
        this.setWfBillHead();
    }

    public void afterBindData(EventObject e) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.showBillHeadPage(dataEntity);
    }

    private void showBillHeadPage(DynamicObject transferBill) {
        HashMap<String, Object> customMap = new HashMap<String, Object>(16);
        customMap.put("id", transferBill.getPkValue());
        customMap.put("status", OperationStatus.VIEW);
        TransferPageUtil.showPageNoAuthByPkId((IFormView)this.getView(), (String)PAGE_TRANSFERLAYOUT_HEAD_M, (String)PANEL_HEAD, (ShowType)ShowType.InContainer, customMap);
        TransferPageUtil.showPageNoAuthByPkId((IFormView)this.getView(), (String)PAGE_TRANSFERT_JOBINFO_M, (String)PANEL_TRANSFER_JOBINFO, (ShowType)ShowType.InContainer, customMap);
        Map propMap = DyTransferUtil.getPropMap((DynamicObject)transferBill.getDynamicObject("bevaluationjob"));
        customMap.put("bevaluationjob", propMap);
        TransferPageUtil.showPageNoAuthByPkId((IFormView)this.getView(), (String)PAGE_TRANSFERT_JOBLEVEL_M, (String)PANEL_TRANSFER_JOBLEVEL, (ShowType)ShowType.InContainer, customMap);
    }

    private void setWfBillHead() {
        Label billNameLab;
        IFormView wfMobView = this.getView().getParentView();
        if (wfMobView != null && (billNameLab = (Label)wfMobView.getControl("billname")) != null) {
            DynamicObject transferDy = this.getModel().getDataEntity();
            String originator = transferDy.getString("originator");
            List transferOriginatorEnums = Arrays.stream(TransferOriginatorEnum.values()).filter(temp -> temp.getOriginator().equals(originator)).collect(Collectors.toList());
            if (HRCollUtil.isEmpty(transferOriginatorEnums)) {
                return;
            }
            TransferOriginatorEnum originatorEnum = (TransferOriginatorEnum)transferOriginatorEnums.get(0);
            String billName = null;
            String workFlowFlag = transferDy.getString("workflowflag");
            switch (originatorEnum) {
                case OUT: {
                    billName = ResManager.loadKDString((String)"%s\u7684\u8c03\u51fa\u7533\u8bf7\u5355", (String)"TransferBaseAuditMobPlugin_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
                    if (!WorkFlowFlagEnum.SECONDSUBMIT.getFlag().equals(workFlowFlag)) break;
                    billName = ResManager.loadKDString((String)"%s\u7684\u8c03\u5165\u7533\u8bf7\u5355", (String)"TransferBaseAuditMobPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case IN: {
                    billName = ResManager.loadKDString((String)"%s\u7684\u8c03\u5165\u7533\u8bf7\u5355", (String)"TransferBaseAuditMobPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
                    if (!WorkFlowFlagEnum.SECONDSUBMIT.getFlag().equals(workFlowFlag)) break;
                    billName = ResManager.loadKDString((String)"%s\u7684\u8c03\u51fa\u7533\u8bf7\u5355", (String)"TransferBaseAuditMobPlugin_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
                    break;
                }
                case APPLY: {
                    billName = ResManager.loadKDString((String)"%s\u7684\u8c03\u52a8\u7533\u8bf7\u5355", (String)"TransferBaseAuditMobPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
                    break;
                }
            }
            if (HRStringUtils.isNotEmpty(billName)) {
                billNameLab.setText(String.format(billName, transferDy.getString("person.name")));
                this.getView().sendFormAction(wfMobView);
            }
        }
    }
}

