/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.apply;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.hr.hdm.business.common.PermissionValidateUtil;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.common.transfer.enums.TransferOriginatorEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.common.transfer.util.TransferPageHelperUtil;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;

public class TransferApplyBillList
extends HRCoreBaseBillList {
    public void setFilter(SetFilterEvent arg) {
        super.setFilter(arg);
        QFilter originatorFilter = new QFilter("originator", "=", (Object)TransferOriginatorEnum.APPLY.getOriginator());
        QFilter originatorMyFilter = new QFilter("originator", "=", (Object)TransferOriginatorEnum.MY.getOriginator()).and(new QFilter("billstatus", "not in", (Object)new String[]{"A", "G"}));
        arg.getQFilters().add(originatorFilter.or(originatorMyFilter));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        if (HRStringUtils.equals((String)operateKey, (String)"donothing_termination")) {
            if (selectedRows.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u64cd\u4f5c\u4e00\u6761\u6570\u636e\u3002", (String)"TransferApplyBillList_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            QFilter qFilter = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
            DynamicObject[] query = ITransferBillService.getInstance().query("originator,transferstatus,transfereffectstatus", qFilter.toArray());
            if (query.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"TransferApplyBillList_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject dataEntity = query[0];
            String transferStatus = dataEntity.getString("transferstatus");
            String transferEffectStatus = dataEntity.getString("transfereffectstatus");
            if (!(HRStringUtils.equals((String)transferStatus, (String)"1") || HRStringUtils.equals((String)transferStatus, (String)"4") && !HRStringUtils.equals((String)transferEffectStatus, (String)"1"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u7ec8\u6b62\u8c03\u52a8\u72b6\u6001\u4e3a\u201c\u8c03\u52a8\u4e2d\u201d\u201c\u5f85\u751f\u6548\u201d\u4e14\u540c\u6b65\u7ed3\u679c\u4e0d\u4e3a\u201c\u540c\u6b65\u4e2d\u201d\u7684\u5355\u636e\u3002", (String)"TransferApplyBillList_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (HRStringUtils.equals((String)operateKey, (String)"donothing_submiteffect")) {
            this.executeSubmitEffect(operate, selectedRows);
            args.setCancel(true);
            return;
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "closeCallBackSubmitEffect": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                String opType = (String)returnData.get("opType");
                if (!"op_confirm".equals(opType)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("isValidateTips", "false");
                operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
                this.getView().invokeOperation("donothing_submiteffect", operateOption);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        switch (args.getOperateKey()) {
            case "donothing_add": {
                TransferPageUtil.showNewAddPage((IFormView)this.getView(), (String)"hdm_transferapply", (String)ResManager.loadKDString((String)"\u65b0\u589e\u8c03\u52a8\u7533\u8bf7", (String)"TransferApplyBillList_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        IListView listView = (IListView)this.getView();
        long transferBillId = (Long)listView.getFocusRowPkId();
        String name = this.getPersonNameByBillId(transferBillId);
        String caption = ResManager.loadKDString((String)"\u8c03\u52a8\u7533\u8bf7-%s", (String)"TransferApplyBillList_5", (String)"hr-hdm-formplugin", (Object[])new Object[]{name});
        ListShowParameter param = (ListShowParameter)listView.getFormShowParameter();
        HashMap<String, String> customParams = new HashMap<String, String>();
        String type = (String)param.getCustomParam("menuflag");
        customParams.put("menuflag", type);
        TransferPageUtil.showPage((IFormView)this.getView(), (String)"hdm_transferapply", (Object)transferBillId, (String)caption, customParams);
    }

    private String getPersonNameByBillId(long billId) {
        String name = "";
        DynamicObject query = ITransferBillService.getInstance().queryOne("person", billId);
        if (!ObjectUtils.isEmpty((Object)query) && !ObjectUtils.isEmpty((Object)query.getString("person.name"))) {
            name = query.getString("person.name");
        }
        return name;
    }

    private boolean executeSubmitEffect(FormOperate operate, ListSelectedRowCollection selectedRows) {
        boolean isValidateTips;
        if (selectedRows.size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u64cd\u4f5c\u4e00\u6761\u6570\u636e\u3002", (String)"TransferApplyBillList_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject[] transferBills = this.initData();
        PermissionValidateUtil.setAppId((String)this.getView().getFormShowParameter().getAppId());
        List dataDivs = (List)ITransferValidatorService.getInstance().batchSubmitEffectValidate(Arrays.asList(transferBills)).apply(this.getMenuFlag());
        if (null == dataDivs || dataDivs.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"TransferApplyBillList_6", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        ValidateContext validateContext = ((DataDiv)dataDivs.get(0)).getValidatorContext();
        String level = validateContext.getResultLevel();
        if (HRStringUtils.equals((String)"1", (String)level)) {
            this.getView().showErrorNotification(validateContext.map2String());
            return false;
        }
        boolean bl = isValidateTips = !operate.getOption().containsVariable("isValidateTips") || !"false".equals(operate.getOption().getVariableValue("isValidateTips"));
        if (isValidateTips && HRStringUtils.equals((String)"2", (String)level)) {
            HashMap<String, LinkedHashMap> params = new HashMap<String, LinkedHashMap>(2);
            params.put("message", validateContext.getValidateTips());
            TransferPageUtil.showModalWithCloseCallback((AbstractFormPlugin)this, (String)"hdm_tipsconfirm", params, (String)"closeCallBackSubmitEffect");
            return false;
        }
        this.executeSubmitEffect();
        return true;
    }

    private void executeSubmitEffect() {
        OperationServiceImpl operationService = new OperationServiceImpl();
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String pageId = param.getBillFormId();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
        OperationResult operationResult = operationService.localInvokeOperation("submiteffect_list", pageId, this.getSelectedRows().getPrimaryKeyValues(), operateOption);
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"TransferApplyBillList_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        } else if (!operationResult.isSuccess()) {
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            String errorMsg = allErrorOrValidateInfo.isEmpty() || allErrorOrValidateInfo.size() == 0 ? operationResult.getMessage() : ((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage();
            this.getView().showErrorNotification(errorMsg);
        }
    }

    private String getMenuFlag() {
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customParams = param.getCustomParams();
        String menuflag = (String)customParams.get("menuflag");
        if (ObjectUtils.isEmpty((Object)menuflag)) {
            menuflag = TransferCommonUtil.getMenuflagStr((IFormView)this.getView());
        }
        return menuflag;
    }

    private DynamicObject[] initData() {
        ListSelectedRowCollection listSelectedData = this.getSelectedRows();
        Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
        return TransferBillRepository.getInstance().query(TransferPageHelperUtil.QUERYFIELD, new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
    }
}

