/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.batch;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferJudgementUtil;

public class BatchTransferButtonEdit
extends HRCoreBaseBillEdit {
    private static final String BAR_MODIFY = "bar_modify";
    private static final String BAR_SUBMITEFFECT = "bar_submiteffect";
    private static final String BAR_IMPORTENTRY = "importentry";
    private static final String BAR_NEWENTRY = "newentry";
    private static final String BAR_DELETEENTRY = "deleteentry";
    private static final List<String> BUTTON_LIST_ALL = Arrays.asList("importentry", "newentry", "deleteentry", "bar_modify", "bar_submiteffect", "bar_save", "bar_submit", "bar_unsubmit", "donothing_close", "bar_termination", "bar_viewflowchart");
    private static final List<String> BUTTON_LIST_ADD_ADDNEW = Arrays.asList("importentry", "newentry", "deleteentry", "bar_save", "donothing_close");
    private static final List<String> BUTTON_LIST_ADD_VIEW = Arrays.asList("bar_modify", "bar_submit", "bar_submiteffect", "donothing_close");
    private static final List<String> BUTTON_LIST_ADD_EDIT = Arrays.asList("importentry", "newentry", "deleteentry", "bar_save", "bar_submit", "bar_submiteffect", "donothing_close");
    private static final List<String> BUTTON_LIST_SUBMIT = Arrays.asList("bar_unsubmit", "donothing_close", "bar_termination", "bar_viewflowchart");
    private static final List<String> BUTTON_LIST_TO_RESUBMIT = Arrays.asList("bar_modify", "bar_submit", "donothing_close", "bar_viewflowchart");
    private static final List<String> BUTTON_LIST_TO_RESUBMIT_EDIT = Arrays.asList("importentry", "bar_save", "donothing_close", "bar_viewflowchart");
    private static final List<String> BUTTON_LIST_AUDITING = Arrays.asList("bar_unsubmit", "bar_termination", "bar_viewflowchart", "donothing_close");
    private static final List<String> BUTTON_LIST_AUDITED_TERMINATE = Arrays.asList("donothing_close", "bar_termination", "bar_viewflowchart");
    private static final List<String> BUTTON_LIST_AUDITED = Arrays.asList("donothing_close", "bar_viewflowchart");
    private static final List<String> BUTTON_LIST_REJECTED = Arrays.asList("donothing_close", "bar_viewflowchart");
    private static final List<String> BUTTON_LIST_ABANDON = Arrays.asList("donothing_close", "bar_viewflowchart");

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.setButtonVisible();
    }

    private void setButtonVisible() {
        this.setAllButtonInvisible(BUTTON_LIST_ALL);
        this.BillStatusHandle();
    }

    private void BillStatusHandle() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        switch (billStatus) {
            case "A": {
                if (TransferJudgementUtil.ADDNEW.test(operationStatus)) {
                    this.setAllButtonVisible(BUTTON_LIST_ADD_ADDNEW);
                    break;
                }
                if (TransferJudgementUtil.VIEW.test(operationStatus)) {
                    this.setAllButtonVisible(BUTTON_LIST_ADD_VIEW);
                    break;
                }
                this.setAllButtonVisible(BUTTON_LIST_ADD_EDIT);
                break;
            }
            case "B": {
                this.setAllButtonVisible(BUTTON_LIST_SUBMIT);
                break;
            }
            case "G": {
                if (TransferJudgementUtil.EDIT.test(operationStatus)) {
                    this.setAllButtonVisible(BUTTON_LIST_TO_RESUBMIT_EDIT);
                    break;
                }
                this.setAllButtonVisible(BUTTON_LIST_TO_RESUBMIT);
                break;
            }
            case "D": {
                this.setAllButtonVisible(BUTTON_LIST_AUDITING);
                break;
            }
            case "C": {
                if (this.isAllSynched()) {
                    this.setAllButtonVisible(BUTTON_LIST_AUDITED_TERMINATE);
                    break;
                }
                this.setAllButtonVisible(BUTTON_LIST_AUDITED);
                break;
            }
            case "E": {
                this.setAllButtonVisible(BUTTON_LIST_REJECTED);
                break;
            }
            case "F": {
                this.setAllButtonVisible(BUTTON_LIST_ABANDON);
                break;
            }
        }
    }

    private void setAllButtonInvisible(List<String> buttonList) {
        buttonList.forEach(button -> this.getView().setVisible(Boolean.FALSE, new String[]{button}));
    }

    private void setAllButtonVisible(List<String> buttonList) {
        buttonList.forEach(button -> this.getView().setVisible(Boolean.TRUE, new String[]{button}));
    }

    private boolean isAllSynched() {
        DynamicObjectCollection entryinfo = this.getModel().getEntryEntity("entryentity");
        if (ObjectUtils.isEmpty((Collection)entryinfo)) {
            return true;
        }
        List list = entryinfo.stream().filter(o -> "4".equals(o.getString("transferstatus")) && ("0".equals(o.getString("transfereffectstatus")) || "3".equals(o.getString("transfereffectstatus")))).collect(Collectors.toList());
        return list.size() > 0;
    }
}

