/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.batch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.business.common.PermissionValidateUtil;
import kd.hr.hdm.business.domain.transfer.repository.TransferBatchRepository;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.IBatchTransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.common.transfer.enums.TransferOperateTypeEnum;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;
import kd.hr.hdm.common.util.HdmFormViewUtil;

public class BatchTransferEdit
extends HRCoreBaseBillEdit {
    private static final Log LOGGER = LogFactory.getLog(BatchTransferEdit.class);
    private static final String DELETEENTRY = "deleteentry";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setAuditPanelVisible(this.getModel(), this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "submiteffect": {
                this.submitEffect(args);
                break;
            }
            case "save": {
                this.save(args);
                break;
            }
            case "submit": {
                this.submit(args);
                break;
            }
        }
        if (operateKey.equals(DELETEENTRY)) {
            return;
        }
        this.getView().updateView("entryentity");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        long billId = (Long)this.getModel().getValue("id");
        if (HRStringUtils.equals((String)operateKey, (String)"donothing_termination")) {
            TransferPageUtil.showFormViewOfModal((IFormView)this.getView(), (String)"hdm_transferterminate", (Object)billId, (String)"batch");
        } else if (HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"submit") || HRStringUtils.equals((String)operateKey, (String)"submiteffect")) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        } else if (HRStringUtils.equals((String)operateKey, (String)"donothing_unsubmitlist")) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u64a4\u9500\u540e\u6d41\u7a0b\u5c06\u56de\u5230\u201c\u6682\u5b58\u201d\u72b6\u6001\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TransferBatchList_10", (String)"hr-hdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("callback_unsubmit", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("callback_unsubmit".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.excuteBatchTransferOperation("unsubmit", ResManager.loadKDString((String)"\u64a4\u9500\u5931\u8d25", (String)"TransferBatchList_12", (String)"hr-hdm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f", (String)"TransferBatchList_11", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void submitEffect(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject batchTransferBill = TransferBatchRepository.getInstance().queryOne("billstatus", (Object)dataEntity.getLong("id"));
        if (!"A".equals(batchTransferBill.getString("billstatus"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u53ef\u63d0\u4ea4\u5e76\u751f\u6548\u201c\u6682\u5b58\u201d\u7684\u6570\u636e\u3002", (String)"TransferBatchList_8", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObjectCollection batchTransferBillCollection = this.getModel().getEntryEntity("entryentity");
        List<DynamicObject> transferBillEntryList = Arrays.asList(TransferBillRepository.getInstance().query(TransferStaffService.getInstance().getSelectProperties(), batchTransferBillCollection.stream().map(transferBill -> transferBill.getLong("id")).collect(Collectors.toList())));
        List dataDivs = IBatchTransferValidatorService.getInstance().submitEffectValidate(PermissionValidateUtil.getPermissionAppId((IFormView)this.getView()), transferBillEntryList, HdmFormViewUtil.getMenuFlag((IFormView)this.getView()));
        Map valResultInfo = IBatchTransferValidatorService.getInstance().buildOperateInfoByValResult(dataDivs, TransferOperateTypeEnum.SUBMITEFFECT);
        if ((Integer)valResultInfo.get("failperson") != 0) {
            TransferPageUtil.showFormViewOfModal((IFormView)this.getView(), (String)"hdm_operateresult", (Map)valResultInfo);
            args.setCancel(true);
        }
    }

    private void save(BeforeDoOperationEventArgs args) {
        DynamicObject batchTransferBill = this.getModel().getDataEntity();
        ArrayList entryData = Lists.newArrayList((Iterable)this.getModel().getEntryEntity("entryentity"));
        if (HRCollUtil.isEmpty((Collection)entryData)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u8bf7\u5728\u5206\u5f55\u81f3\u5c11\u65b0\u589e\u4e00\u4e2a\u4eba\u5458\u8fdb\u884c\u8c03\u52a8\u3002", (String)"TransferBatchList_9", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        List dataDivs = IBatchTransferValidatorService.getInstance().saveValidate(batchTransferBill, (List)entryData, HdmFormViewUtil.getMenuFlag((IFormView)this.getView()));
        Map valResultInfo = IBatchTransferValidatorService.getInstance().buildOperateInfoByValResult(dataDivs, TransferOperateTypeEnum.SAVE);
        if ((Integer)valResultInfo.get("failperson") != 0) {
            TransferPageUtil.showFormViewOfModal((IFormView)this.getView(), (String)"hdm_operateresult", (Map)valResultInfo);
            args.setCancel(true);
        }
    }

    private void submit(BeforeDoOperationEventArgs args) {
        DynamicObject batchTransferBill = this.getModel().getDataEntity();
        ArrayList entryData = Lists.newArrayList((Iterable)this.getModel().getEntryEntity("entryentity"));
        List<DynamicObject> transferBillEntryList = Arrays.asList(TransferBillRepository.getInstance().query(TransferStaffService.getInstance().getSelectProperties(), entryData.stream().map(transferBill -> transferBill.getLong("id")).collect(Collectors.toList())));
        PermissionValidateUtil.setAppId((String)this.getView().getFormShowParameter().getAppId());
        List dataDivs = IBatchTransferValidatorService.getInstance().submitValidate(batchTransferBill, transferBillEntryList, HdmFormViewUtil.getMenuFlag((IFormView)this.getView()));
        Map valResultInfo = IBatchTransferValidatorService.getInstance().buildOperateInfoByValResult(dataDivs, TransferOperateTypeEnum.SUBMIT);
        if ((Integer)valResultInfo.get("failperson") != 0) {
            TransferPageUtil.showFormViewOfModal((IFormView)this.getView(), (String)"hdm_operateresult", (Map)valResultInfo);
            args.setCancel(true);
        }
    }

    private void excuteBatchTransferOperation(String operation, String failMsg, String successMsg) {
        OperationServiceImpl operationService = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
        OperationResult operationResult = operationService.localInvokeOperation(operation, "hdm_transferbatch", new Object[]{this.getModel().getValue("id")}, operateOption);
        if (!operationResult.isSuccess()) {
            String message = failMsg;
            try {
                message = ((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage();
            }
            catch (Exception exception) {
                LOGGER.error((Throwable)exception);
            }
            this.getView().showErrorNotification(message);
            return;
        }
        this.getView().showSuccessNotification(successMsg);
        this.getView().invokeOperation("refresh");
    }

    private void setAuditPanelVisible(IDataModel model, IFormView view) {
        if (((Boolean)model.getValue("issubmit")).booleanValue() && !TransferCommonUtil.isAuditView((IFormView)this.getView())) {
            view.setVisible(Boolean.TRUE, new String[]{"rightmainpanel"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"rightmainpanel"});
        }
    }
}

