/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.batch;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillViewForWebApi;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.business.common.PermissionValidateUtil;
import kd.hr.hdm.business.domain.transfer.repository.PermissionRepository;
import kd.hr.hdm.formplugin.transfer.web.common.TransferBillPropChangedEdit;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.EntryPropertyChangedHandler;

public class EntryCommonEdit
extends HRCoreBaseBillEdit {
    private static final Log LOGGER = LogFactory.getLog(TransferBillPropChangedEdit.class);

    public void propertyChanged(PropertyChangedArgs e) {
        IFormView view = this.getView();
        if (view instanceof BillViewForWebApi && ((Boolean)Optional.ofNullable(view.getModel().getContextVariable("IGNORE_RELOADDATAMODEL")).orElse(Boolean.FALSE)).booleanValue()) {
            return;
        }
        IDataModel model = this.getModel();
        try {
            EntryPropertyChangedHandler.getInstance().propertyChange(e).accept(view, model);
        }
        catch (Exception exception) {
            LOGGER.error(exception.getMessage());
            LOGGER.error(Arrays.toString(exception.getStackTrace()));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object org;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ((HRStringUtils.equals((String)operateKey, (String)"importentry") || HRStringUtils.equals((String)operateKey, (String)"newentry")) && HRObjectUtils.isEmpty((Object)(org = this.getModel().getValue("org")))) {
            String errorNotification = HRStringUtils.equals((String)operateKey, (String)"importentry") ? ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u201d\uff0c\u518d\u5bfc\u5165\u4eba\u5458\u3002", (String)"EntryCommonEdit_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u201d\uff0c\u518d\u6dfb\u52a0\u4eba\u5458\u3002", (String)"EntryCommonEdit_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorNotification);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        boolean hasPerm;
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObjectCollection entryEntity = (DynamicObjectCollection)this.getModel().getValue("entryentity");
        int size = entryEntity.size();
        boolean keyEquals = HRStringUtils.equals((String)"newentry", (String)operateKey);
        if (keyEquals && !(hasPerm = PermissionRepository.getInstance().checkOperatePermission("hdm_transferbatchentry", "QXX0002", PermissionValidateUtil.getPermissionAppId((IFormView)this.getView())))) {
            this.getModel().deleteEntryRow("entryentity", entryEntity.size() - 1);
        }
        if (keyEquals && size > 1) {
            this.afterCreateNewDataForEntry(size - 1);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.afterCreateNewDataForEntry(0);
    }

    private void afterCreateNewDataForEntry(int rowIndex) {
        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"acompany", "aposition", "aorg", "astposition", "abaselocation", "transferreason", "plandate", "transferoutlastdate", "description", "persongrouppanelap", "arealitysuperior", "amanagescope", "postpattern", "workingplan", "affaction"});
    }
}

