/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.common;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.business.domain.transfer.repository.EmpGroupRepository;
import kd.hr.hdm.common.transfer.enums.TransferOriginatorEnum;
import kd.hr.hdm.common.transfer.enums.TransferStageEnum;
import kd.hr.hdm.common.transfer.enums.WorkFlowFlagEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.common.transfer.util.TransferJudgementUtil;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;

public class TransferBillHeadEdit
extends HRCoreBaseBillEdit {
    public static final String LABEL_LBLBILLNOVIEW = "lblbillnoview";
    public static final String LABEL_LBLCREATETIMEVIEW = "lblcreatetimeview";
    public static final String HDM_TRANSFERINBILL = "hdm_transferinbill";
    public static final String LABEL_LBLCREATORVIEW = "lblcreatorview";
    public static final String LABEL_LBLORGVIEW = "lblorgview";
    public static final String LABEL_LBLTRANSFERTYPEDIT = "lbltransfertypedit";
    public static final String LABEL_LBLBILLNOEDIT = "lblbillnoedit";
    public static final String LABEL_LBLCREATETIMEEDIT = "lblcreatetimeedit";
    public static final String LABEL_LBLCREATOREDIT = "lblcreatoredit";
    public static final String CLOSE = "close";
    public static final String LABEL_HEADPANELEDIT = "headpaneledit";
    public static final String LABEL_LBLPERSONNAME = "lblpersonname";

    public void afterBindData(EventObject arg) {
        super.afterBindData(arg);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        this.showPersonalInfoPanel();
        this.setBillHead();
        if (TransferJudgementUtil.ADDNEW.test(status)) {
            this.initTransferBillData();
        }
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (CLOSE.equals(operateKey)) {
            return;
        }
        this.setBillHead();
    }

    private void setBillHead() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject billDy = model.getDataEntity();
        String billno = (String)model.getValue("billno");
        Object fillinDate = model.getValue("createtime");
        String fillinTime = fillinDate == null ? null : HRInteDateTimeUtil.formatDate((String)HDM_TRANSFERINBILL, (String)"createtime", (Date)((Date)fillinDate));
        DynamicObject filliner = (DynamicObject)model.getValue("creator");
        String fillinName = "";
        if (null != filliner) {
            fillinName = filliner.getString("name");
        }
        TransferCommonUtil.setLblText((IFormView)view, (String)LABEL_LBLBILLNOVIEW, (String)billno);
        TransferCommonUtil.setLblText((IFormView)view, (String)LABEL_LBLCREATETIMEVIEW, (String)fillinTime);
        TransferCommonUtil.setLblText((IFormView)view, (String)LABEL_LBLCREATORVIEW, (String)fillinName);
        TransferCommonUtil.setTransferStatusShow((IFormView)view, (IDataModel)model, (String)"transstatus");
        this.setBillHeadName();
        if (null != this.getView().getControl(LABEL_HEADPANELEDIT)) {
            this.setEditPanel(billno, fillinTime, fillinName);
        }
    }

    private void setBillHeadName() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (!TransferCommonUtil.isAuditView((IFormView)view)) {
            return;
        }
        Object orginator = model.getValue("originator");
        Object transferStage = model.getValue("transferstage");
        if (null == orginator || null == transferStage) {
            return;
        }
        String billHeadName = "";
        if (TransferOriginatorEnum.IN.getOriginator().equals(orginator.toString())) {
            if (TransferStageEnum.ONE.getName().equals(transferStage.toString())) {
                billHeadName = ResManager.loadKDString((String)"\u8c03\u5165\u5ba1\u6279\u5355", (String)"TransferBillHeadEdit_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            }
        } else if (TransferOriginatorEnum.OUT.getOriginator().equals(orginator.toString()) && TransferStageEnum.ONE.getName().equals(transferStage.toString())) {
            billHeadName = ResManager.loadKDString((String)"\u8c03\u51fa\u5ba1\u6279\u5355", (String)"TransferBillHeadEdit_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        }
        if (!ObjectUtils.isEmpty((Object)billHeadName)) {
            TransferCommonUtil.setLblText((IFormView)view, (String)LABEL_LBLPERSONNAME, (String)billHeadName);
        }
    }

    private void showPersonalInfoPanel() {
        Map personalInfoMap = TransferCommonUtil.buildPersonalInfo((DynamicObject)this.getModel().getDataEntity());
        if (ObjectUtils.isEmpty((Object)personalInfoMap)) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"personalinfoprepanel"});
        TransferPageUtil.showPageInContainer((IFormView)this.getView(), (String)"hdm_personalcard", (String)"personcard", (Map)personalInfoMap);
    }

    private void setEditPanel(String billno, String fillinDate, String creatorName) {
        Label lblbillnoedit = (Label)this.getView().getControl(LABEL_LBLBILLNOEDIT);
        lblbillnoedit.setText(billno);
        Label lblcreatetimeedit = (Label)this.getView().getControl(LABEL_LBLCREATETIMEEDIT);
        lblcreatetimeedit.setText(fillinDate);
        Label lblcreatoredit = (Label)this.getView().getControl(LABEL_LBLCREATOREDIT);
        lblcreatoredit.setText(creatorName);
        String isCompanyIn = (String)this.getView().getFormShowParameter().getCustomParam("isCompanyIn");
    }

    private void initTransferBillData() {
        this.getModel().setValue("transferstage", (Object)"0");
        this.getModel().setValue("aempgroup", (Object)1010L);
        this.getModel().setValue("workflowflag", (Object)WorkFlowFlagEnum.INIT.getFlag());
    }

    private long queryDefaultEmpGroup() {
        DynamicObject dynamicObject = Optional.ofNullable(EmpGroupRepository.getInstance().queryDefaultEmpGroup()).orElseThrow(() -> new RuntimeException("can't find default empgroup when bill init"));
        return dynamicObject.getLong("id");
    }
}

