/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.hr.hdm.business.common.HPFSTemplatePropertyHandler;
import kd.hr.hdm.business.common.PermissionValidateUtil;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.domain.transfer.executor.MixOperationExecutor;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillListService;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.common.transfer.constants.TransferCharacterConstrats;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.common.transfer.util.TransferPageHelperUtil;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;
import kd.hr.hdm.common.util.HdmFormViewUtil;

public class TransferBillList
extends HRCoreBaseBillList {
    private static final Log LOGGER = LogFactory.getLog(TransferBillList.class);
    private static final String LOCKSIMBLE = "TransferInfoChangeAndConfirm";

    public void setFilter(SetFilterEvent arg) {
        String orderBy = "modifytime desc";
        arg.setOrderBy(orderBy);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("affaction")) {
            this.setActionCustomParam(args);
        }
    }

    private void setActionCustomParam(BeforeFilterF7SelectEvent args) {
        String isNewChgAction = this.getPageCache().get("hdm_transfer_hpfs_new");
        if (HRStringUtils.isEmpty((String)isNewChgAction)) {
            boolean newChgAction = HPFSTemplatePropertyHandler.isNewChgAction((String)"hdm_transfer_hpfs_new");
            isNewChgAction = newChgAction ? "1" : "0";
            this.getPageCache().put("hdm_transfer_hpfs_new", isNewChgAction);
        }
        args.getCustomParams().put("businessvalue", isNewChgAction);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        switch (operateKey) {
            case "donothing_confirm": {
                if (selectedRows.size() < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u786e\u8ba4\u8c03\u52a8\u7684\u5355\u636e\u3002", (String)"TransferBillList_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                if (selectedRows.size() <= 1) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u64cd\u4f5c\u4e00\u6761\u6570\u636e\u3002", (String)"TransferBillList_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "donothing_infochange": {
                if (selectedRows.size() <= 1) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u64cd\u4f5c\u4e00\u6761\u6570\u636e\u3002", (String)"TransferBillList_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "donothing_unsubmitlist": {
                if (selectedRows.size() < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64a4\u9500\u7684\u5355\u636e\u3002", (String)"TransferBillList_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                this.unsubmitTransferConfirm();
                args.setCancel(true);
                break;
            }
            case "donoting_submitlist": {
                if (selectedRows.size() < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u63d0\u4ea4\u7684\u5355\u636e\u3002", (String)"TransferBillList_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                this.submitTransferBills(operate);
                args.setCancel(true);
                break;
            }
            case "donothing_deletelist": {
                if (selectedRows.size() < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u5355\u636e\u3002", (String)"TransferBillList_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                this.deleteTransferBills();
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        switch (args.getOperateKey()) {
            case "donothing_termination": {
                this.terminateTransferBill();
                break;
            }
            case "donothing_confirm": {
                this.confirmTransferBills();
                break;
            }
            case "donothing_infochange": {
                this.changeinfoTransferBills();
                break;
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedColumnList = this.initDefaultFixedColumnList();
        for (String column : fixedColumnList) {
            IListColumn listColumn = args.getListColumn(column);
            if (!ObjectUtils.isNotEmpty((Object)listColumn)) continue;
            listColumn.setFixed(true);
        }
    }

    protected List<String> initDefaultFixedColumnList() {
        ArrayList<String> fixedColumnList = new ArrayList<String>();
        fixedColumnList.add("person.headsculpture");
        fixedColumnList.add("person.name");
        return fixedColumnList;
    }

    public void packageData(PackageDataEvent arg) {
        super.packageData(arg);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)arg.getSource();
        if (HRStringUtils.equals((String)columnDesc.getFieldKey(), (String)"person.headsculpture")) {
            DynamicObject headsculptureDy = arg.getRowData();
            String photo = headsculptureDy.getString("person.headsculpture");
            if (HRStringUtils.isEmpty((String)photo) || "null".equals(photo)) {
                photo = "/images/pc/emotion/default_person_82_82.png";
            }
            arg.setFormatValue((Object)photo);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("callback_unsubmit".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.unsubmitSingleTransferBill();
        } else if ("callback_delete".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.delete();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "closeCallBackSubmit": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                String opType = (String)returnData.get("opType");
                if (!"op_confirm".equals(opType)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("isValidateTips", "false");
                operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
                this.getView().invokeOperation("donoting_submitlist", operateOption);
                break;
            }
            case "infochange": 
            case "firstConfirm": {
                try {
                    IHRAppCache ihrAppCache = HRAppCache.get((String)LOCKSIMBLE);
                    ListSelectedRowCollection selectedRows = this.getSelectedRows();
                    Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                    Object primaryKeyValue = primaryKeyValues[0];
                    String lockKey = primaryKeyValue.toString();
                    DLock.forceUnlock((String[])new String[]{lockKey});
                    ihrAppCache.remove(lockKey);
                    ihrAppCache.remove(lockKey + "type");
                }
                catch (Exception e) {
                    LOGGER.error("TransferBillList infochange or firstConfirm  closedCallBack error Exception is", (Throwable)e);
                }
                break;
            }
        }
    }

    private void confirmTransferBills() {
        DynamicObject[] transferBills = this.initData();
        List dataDivs = ITransferValidatorService.getInstance().batchConfirmValidate(Arrays.asList(transferBills));
        if (dataDivs.size() > 1) {
            this.executeTransferBillOp(dataDivs, "hdm_listmulconfirm", ResManager.loadKDString((String)"\u786e\u8ba4\u8c03\u52a8", (String)"TransferBillList_5", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        } else {
            List errors = dataDivs.stream().filter(temp -> temp.getValidatorContext().getValidateResult().size() > 0).collect(Collectors.toList());
            if (!errors.isEmpty()) {
                this.getView().showErrorNotification(((DataDiv)errors.get(0)).getValidatorContext().map2String());
                return;
            }
            Object id = transferBills[0].get("id");
            String entityNum = (String)this.getView().getFormShowParameter().getCustomParam("billFormId");
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("hdm_transferconfirm");
            formShowParameter.setCustomParam("id", id);
            formShowParameter.setCustomParam("entityNum", (Object)entityNum);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "firstConfirm"));
            this.getView().showForm(formShowParameter);
        }
    }

    private void changeinfoTransferBills() {
        DynamicObject[] transferBills = this.initData();
        List dataDivs = ITransferValidatorService.getInstance().batchInfoChangealidate(Arrays.asList(transferBills));
        if (dataDivs.size() <= 1) {
            List errors = dataDivs.stream().filter(temp -> temp.getValidatorContext().getValidateResult().size() > 0).collect(Collectors.toList());
            if (!errors.isEmpty()) {
                this.getView().showErrorNotification(((DataDiv)errors.get(0)).getValidatorContext().map2String());
                return;
            }
            Object id = transferBills[0].get("id");
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("hdm_infochange");
            ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
            formShowParameter.setCustomParam("page", (Object)param.getBillFormId());
            formShowParameter.setCustomParam("id", id);
            formShowParameter.setCustomParam("menuflag", (Object)HdmFormViewUtil.getMenuFlag((IFormView)this.getView()));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "infochange"));
            String billFormId = "hdm_transferinbill";
            try {
                billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
            }
            catch (Exception exception) {
                LOGGER.error("exception error", (Throwable)exception);
            }
            LOGGER.info("infochange custom_entity_number : {}", (Object)billFormId);
            formShowParameter.setCustomParam("customHREntityNumber", (Object)billFormId);
            formShowParameter.setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
            formShowParameter.setCustomParam("custom_parent_f7_prop", (Object)"aorg");
            this.getView().showForm(formShowParameter);
        }
    }

    private void submitTransferBills(FormOperate operate) {
        DynamicObject[] transferBills = this.initData();
        String menuFlag = this.getMenuFlag();
        PermissionValidateUtil.setAppId((String)this.getView().getFormShowParameter().getAppId());
        MixOperationExecutor validate = new MixOperationExecutor("workflowflag", "validate");
        List dataDivs = (List)validate.execute(Arrays.asList(transferBills)).apply(menuFlag);
        if (null == dataDivs || dataDivs.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"TransferBillList_25", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (dataDivs.size() > 1) {
            this.executeTransferBillOp(dataDivs, "hdm_mulcommitconfirm", ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"TransferBillList_6", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        } else {
            boolean isValidateTips;
            ValidateContext validateContext = ((DataDiv)dataDivs.get(0)).getValidatorContext();
            String level = validateContext.getResultLevel();
            if (HRStringUtils.equals((String)"1", (String)level)) {
                this.getView().showErrorNotification(validateContext.map2String());
                return;
            }
            boolean bl = isValidateTips = !operate.getOption().containsVariable("isValidateTips") || !"false".equals(operate.getOption().getVariableValue("isValidateTips"));
            if (isValidateTips && HRStringUtils.equals((String)"2", (String)level)) {
                HashMap<String, LinkedHashMap> params = new HashMap<String, LinkedHashMap>(2);
                params.put("message", validateContext.getValidateTips());
                TransferPageUtil.showModalWithCloseCallback((AbstractFormPlugin)this, (String)"hdm_tipsconfirm", params, (String)"closeCallBackSubmit");
                return;
            }
            OperationServiceImpl operationService = new OperationServiceImpl();
            ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
            String pageId = param.getBillFormId();
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
            OperationResult operationResult = this.getView().invokeOperation("submit_list", operateOption);
            LOGGER.info("TransferBillList submit result :{} ", (Object)operationResult.toString());
            if (operationResult.isSuccess()) {
                this.getView().invokeOperation("refresh");
            } else if (!operationResult.isSuccess()) {
                boolean needWfAssignPersons = operationResult.isNeedWfAssignPersons();
                List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                String errorMsg = allErrorOrValidateInfo.isEmpty() || allErrorOrValidateInfo.size() == 0 ? operationResult.getMessage() : ((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage();
                if ((errorMsg == null || errorMsg.isEmpty()) && needWfAssignPersons) {
                    return;
                }
                this.getView().showErrorNotification(errorMsg);
            }
        }
    }

    private void executeTransferBillOp(List<DataDiv> dataDivs, String confirmPageId, String keywords) {
        ArrayList<DataDiv> errors = new ArrayList<DataDiv>(dataDivs.size());
        Object[] primaryKeyValues = new Object[dataDivs.size()];
        int index = 0;
        for (DataDiv dataDiv : dataDivs) {
            if (dataDiv.getValidatorContext().getValidateResult().size() > 0) {
                errors.add(dataDiv);
                continue;
            }
            primaryKeyValues[index] = dataDiv.getDynamicObject().get("id");
            ++index;
        }
        this.showMulCommitConfirmPage(dataDivs, errors, primaryKeyValues, confirmPageId, keywords);
    }

    private void showMulCommitConfirmPage(List<DataDiv> transferBills, List<DataDiv> errorlog, Object[] ids, String confirmPageId, String keyWords) {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        String menuFlag = this.getMenuFlag();
        String typeName = "in".equals(menuFlag) ? TransferCharacterConstrats.getTransferIn() : ("out".equals(menuFlag) ? TransferCharacterConstrats.getTransferOut() : TransferCharacterConstrats.getTransferApply());
        params.put("sumlabel", transferBills.size());
        params.put("incongruentlabel", errorlog.size());
        params.put("coincidentlabel", transferBills.size() - errorlog.size());
        params.put("filename", String.format(ResManager.loadKDString((String)"%1$s-\u6279\u91cf%2$s\u786e\u8ba4", (String)"TransferBillList_7", (String)"hr-hdm-formplugin", (Object[])new Object[0]), typeName, keyWords));
        params.put("headDataList", ITransferBillListService.getInstance().initCommitConfirmExcelHead(keyWords, menuFlag, confirmPageId));
        params.put("exportDataList", ITransferBillListService.getInstance().initCommitConfirmExportData(transferBills, menuFlag, confirmPageId));
        params.put("ids", ids);
        params.put("menuflag", String.format(ResManager.loadKDString((String)"%1$s-\u6279\u91cf%2$s", (String)"TransferBillList_8", (String)"hr-hdm-formplugin", (Object[])new Object[0]), typeName, keyWords));
        String temp = String.format(ResManager.loadKDString((String)"%1$s-\u6279\u91cf%2$s", (String)"TransferBillList_8", (String)"hr-hdm-formplugin", (Object[])new Object[0]), typeName, keyWords);
        LOGGER.info("TransferBillList excel name log first param : {} , second parram : {} , total name :{}", new Object[]{typeName, keyWords, temp});
        TransferPageUtil.showFormViewOfModal((IFormView)this.getView(), (String)confirmPageId, params);
    }

    private void terminateTransferBill() {
        Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
        String menuFlag = this.getMenuFlag();
        TransferPageUtil.showFormViewOfModal((IFormView)this.getView(), (String)"hdm_transferterminate", (Object)primaryKeyValues[0], (String)menuFlag);
    }

    private DynamicObject[] initData() {
        ListSelectedRowCollection listSelectedData = this.getSelectedRows();
        Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
        return TransferBillRepository.getInstance().query(TransferPageHelperUtil.QUERYFIELD, new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
    }

    private void unsubmitTransferConfirm() {
        List dataDivs;
        DynamicObject[] transferBills = this.initData();
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customParams = param.getCustomParams();
        String menuflag = (String)customParams.get("menuflag");
        if (ObjectUtils.isEmpty((Object)menuflag)) {
            menuflag = TransferCommonUtil.getMenuflagStr((IFormView)this.getView());
        }
        if ((dataDivs = ITransferValidatorService.getInstance().batchUnsubmitValidate(Arrays.asList(transferBills), menuflag, PermissionValidateUtil.getPermissionAppId((IFormView)this.getView()))).size() > 1) {
            this.executeTransferBillOp(dataDivs, "hdm_muluncommitconfirm", ResManager.loadKDString((String)"\u64a4\u9500", (String)"TransferBillList_13", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        } else if (dataDivs.size() == 1) {
            List errors = dataDivs.stream().filter(temp -> temp.getValidatorContext().getValidateResult().size() > 0).collect(Collectors.toList());
            if (!errors.isEmpty()) {
                this.getView().showErrorNotification(((DataDiv)errors.get(0)).getValidatorContext().map2String());
                return;
            }
            this.getView().showConfirm(this.getTipsMessage(menuflag), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("callback_unsubmit", (IFormPlugin)this));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"TransferBillList_19", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
    }

    private String getTipsMessage(String origin) {
        String msg = HRStringUtils.equals((String)"out", (String)origin) ? ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u64a4\u9500\u540e\u6d41\u7a0b\u5c06\u56de\u5230\u201c\u5f85\u8c03\u51fa\u90e8\u95e8\u63d0\u4ea4\u201d\u72b6\u6001\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TransferBillList_9", (String)"hr-hdm-formplugin", (Object[])new Object[0]) : (HRStringUtils.equals((String)"in", (String)origin) ? ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u64a4\u9500\u540e\u6d41\u7a0b\u5c06\u56de\u5230\u201c\u5f85\u8c03\u5165\u90e8\u95e8\u63d0\u4ea4\u201d\u72b6\u6001\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TransferBillList_10", (String)"hr-hdm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u64a4\u9500\u540e\uff0c\u9009\u4e2d\u7684\u6570\u636e\u5c06\u56de\u5230\u201c\u6682\u5b58\u201d\u72b6\u6001\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TransferBillList_24", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        return msg;
    }

    private void unsubmitSingleTransferBill() {
        OperationServiceImpl operationService = new OperationServiceImpl();
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String pageId = param.getBillFormId();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
        OperationResult operationResult = operationService.localInvokeOperation("unsubmit", pageId, this.getSelectedRows().getPrimaryKeyValues(), operateOption);
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f\u3002", (String)"TransferBillList_11", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        } else {
            String message;
            try {
                LOGGER.error("transfer unsubmit fail1 \uff1a {}", (Object)operationResult.getAllErrorOrValidateInfo());
                LOGGER.error("transfer unsubmit fail2 \uff1a {}", (Object)operationResult.getAllErrorInfo());
                message = ((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage();
            }
            catch (Exception exception) {
                message = ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u64a4\u9500\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TransferBillList_20", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
                LOGGER.error("transfer unsubmit fail3 \uff1a {}", (Object)exception.getMessage());
            }
            this.getView().showErrorNotification(message);
        }
        this.getView().invokeOperation("refresh");
        this.getView().sendFormAction(this.getView());
    }

    private String getMenuFlag() {
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customParams = param.getCustomParams();
        String menuflag = (String)customParams.get("menuflag");
        if (ObjectUtils.isEmpty((Object)menuflag)) {
            menuflag = TransferCommonUtil.getMenuflagStr((IFormView)this.getView());
        }
        return menuflag;
    }

    private void deleteTransferBills() {
        DynamicObject[] transferBills = this.initData();
        String menuFlag = this.getMenuFlag();
        List dataDivs = ITransferValidatorService.getInstance().batchDeleteValidate(Arrays.asList(transferBills), menuFlag, PermissionValidateUtil.getPermissionAppId((IFormView)this.getView()));
        if (dataDivs.size() > 1) {
            this.executeTransferBillOp(dataDivs, "hdm_deletecomfirm", ResManager.loadKDString((String)"\u5220\u9664", (String)"TransferBillList_18", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        } else {
            List errors = dataDivs.stream().filter(temp -> temp.getValidatorContext().getValidateResult().size() > 0).collect(Collectors.toList());
            if (!errors.isEmpty()) {
                this.getView().showErrorNotification(((DataDiv)errors.get(0)).getValidatorContext().map2String());
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u8bb0\u5f55\u5220\u9664\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TransferBillList_14", (String)"hr-hdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("callback_delete", (IFormPlugin)this));
        }
    }

    private void delete() {
        OperationServiceImpl operationService = new OperationServiceImpl();
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String pageId = param.getBillFormId();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
        OperationResult operationResult = operationService.localInvokeOperation("delete", pageId, this.getSelectedRows().getPrimaryKeyValues(), operateOption);
        if (!operationResult.isSuccess()) {
            List info = operationResult.getAllErrorOrValidateInfo();
            String message = CollectionUtils.isEmpty((Collection)info) ? operationResult.getMessage() : ((IOperateInfo)info.get(0)).getMessage();
            this.getView().showErrorNotification(message);
            return;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TransferBillList_15", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }
}

