/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Map;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.formplugin.transfer.web.common.TransferBeforeF7SelectService;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.EntryPropertyChangedHandler;

public class TransferBillPropChangedEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(TransferBillPropChangedEdit.class);

    public void registerListener(EventObject arg) {
        super.registerListener(arg);
        String menuFlag = this.getMenuFlag();
        if ("out".equals(menuFlag) || "batch".equals(menuFlag)) {
            BasedataEdit personF7 = (BasedataEdit)this.getView().getControl("ermanfile");
            personF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        IFormView formView = this.getView();
        ArrayList baseDataFields = Lists.newArrayList((Object[])new String[]{"aposition", "aorg", "abaselocation", "ajoblevel", "ajobgrade", "ajob", "acompany", "astposition", "affaction"});
        baseDataFields.forEach(baseDataField -> {
            BasedataEdit baseData = (BasedataEdit)formView.getControl(baseDataField);
            baseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        });
    }

    public void propertyChanged(PropertyChangedArgs args) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        try {
            EntryPropertyChangedHandler.getInstance().propertyChange(args).accept(view, model);
        }
        catch (Exception exception) {
            LOGGER.error(exception.getMessage());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        if ("callback_crossdate".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel) {
            Arrays.asList("plandate", "realitydate", "transferoutlastdate").forEach(temp -> this.getModel().setValue(temp, null));
        }
        if ("appdispatchnum".equals(callBackId = messageBoxClosedEvent.getCallBackId())) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes == result) {
                String appRemRelIdStr = this.getPageCache().get("appremoverel");
                long appRemRelId = Long.parseLong(appRemRelIdStr);
                this.getModel().setValue("appremoverel", (Object)appRemRelId);
            }
            this.getPageCache().remove("prop_change_save");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        TransferBeforeF7SelectService.getInstance().beforeF7SelectEventHandler(this.getModel(), this.getView(), beforeF7SelectEvent);
    }

    private String getMenuFlag() {
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customParams = param.getCustomParams();
        String menuflag = (String)customParams.get("menuflag");
        if (ObjectUtils.isEmpty((Object)menuflag)) {
            menuflag = TransferCommonUtil.getMenuflagStr((IFormView)this.getView());
        }
        return menuflag;
    }
}

