/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.common;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.common.transfer.enums.TransferOriginatorEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;

public class TransferButtonEdit
extends HRCoreBaseBillEdit {
    private static final List<String> BUTTON_LIST_ADDNEW = Arrays.asList("bar_save", "donothing_close");
    private static final List<String> BUTTON_LIST_SAVE = Arrays.asList("bar_modify", "bar_submit", "bar_submiteffect", "donothing_close");
    private static final List<String> BUTTON_LIST_TOBE_SUBMIT_EDIT = Arrays.asList("bar_save", "bar_submit", "donothing_close");
    private static final List<String> BUTTON_LIST_TOBE_SUBMIT = Arrays.asList("bar_modify", "bar_submit", "donothing_close");
    private static final List<String> BUTTON_LIST_SUBMIT_INITIATIVE = Arrays.asList("bar_unsubmit", "bar_termination", "bar_viewflowchart", "donothing_close");
    private static final List<String> BUTTON_LIST_IN_SUBMIT_PASSIVE = Arrays.asList("bar_termination", "bar_viewflowchart", "donothing_close");
    private static final List<String> BUTTON_LIST_AUDIED_TO_EFFECT = Arrays.asList("bar_termination", "bar_viewflowchart", "donothing_close", "bar_confirm");
    private static final List<String> BUTTON_LIST_AUDIED = Arrays.asList("bar_termination", "bar_viewflowchart", "donothing_close");
    private static final List<String> BUTTON_LIST_AUDITING_INITIATIVE = Arrays.asList("bar_termination", "bar_viewflowchart", "donothing_close", "bar_unsubmit");
    private static final List<String> BUTTON_LIST_AUDITING_PASSIVE = Arrays.asList("bar_termination", "bar_viewflowchart", "donothing_close");
    private static final List<String> BUTTON_LIST_FINISH = Arrays.asList("bar_viewflowchart", "donothing_close");
    private static final List<String> BUTTON_LIST_ALL = Arrays.asList("bar_modify", "bar_save", "bar_submit", "bar_submiteffect", "bar_unsubmit", "donothing_close", "bar_termination", "bar_viewflowchart", "bar_confirm");
    private static final List<String> BUTTON_LIST_MY = Arrays.asList("bar_viewflowchart", "donothing_close");

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.setButtonVisible();
    }

    private void setButtonVisible() {
        this.setAllButtonInvisible(BUTTON_LIST_ALL);
        if (HRStringUtils.equals((String)TransferOriginatorEnum.MY.getOriginator(), (String)((String)this.getModel().getValue("originator")))) {
            this.setAllButtonVisible(BUTTON_LIST_MY);
        } else {
            this.transferAuditStatusHandle();
        }
    }

    private void transferAuditStatusHandle() {
        String transferAuditStatus;
        switch (transferAuditStatus = this.getTransferAuditStatus()) {
            case "A": {
                this.setTransferAuditSaveButtonVisibility();
                break;
            }
            case "B": {
                this.setTransferAuditSubmitButtonVisibility();
                break;
            }
            case "D": {
                this.setTransferAuditAuditingButtonVisibility();
                break;
            }
            case "E": {
                this.setTransferAuditRejectButtonVisibility();
                break;
            }
            case "F": {
                this.setTransferAuditAbandonVisibility();
                this.setViewFlowChart();
                break;
            }
            case "C": {
                this.setTransferAuditAuditedButtonVisibility();
                break;
            }
            case "G": {
                this.setTransferAuditToResubmitButtonVisibility();
                break;
            }
        }
    }

    private void setTransferAuditAuditedButtonVisibility() {
        String transferStatus = (String)this.getModel().getValue("transferstatus");
        if ("4".equals(transferStatus)) {
            this.setAllButtonVisible(BUTTON_LIST_AUDIED_TO_EFFECT);
        } else if ("1".equals(transferStatus)) {
            this.setAllButtonVisible(BUTTON_LIST_AUDIED);
        } else {
            this.setAllButtonVisible(BUTTON_LIST_FINISH);
        }
        this.setViewFlowChart();
    }

    private void setViewFlowChart() {
        boolean isExistWorkFlow = (Boolean)this.getModel().getValue("isexistsworkflow");
        if (!isExistWorkFlow) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_viewflowchart"});
        }
    }

    private void setTransferAuditAbandonVisibility() {
        this.setAllButtonVisible(BUTTON_LIST_FINISH);
    }

    private void setTransferAuditRejectButtonVisibility() {
        this.setAllButtonVisible(BUTTON_LIST_FINISH);
    }

    private void setTransferAuditAuditingButtonVisibility() {
        if (this.isOriginator()) {
            this.setAllButtonVisible(BUTTON_LIST_AUDITING_INITIATIVE);
        } else {
            this.setAllButtonVisible(BUTTON_LIST_AUDITING_PASSIVE);
        }
    }

    private void setTransferAuditToResubmitButtonVisibility() {
        OperationStatus formStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW == formStatus) {
            this.setAllButtonVisible(BUTTON_LIST_TOBE_SUBMIT);
        } else {
            this.setAllButtonVisible(BUTTON_LIST_TOBE_SUBMIT_EDIT);
        }
    }

    private void setTransferAuditSubmitButtonVisibility() {
        if (this.isOriginator()) {
            this.setAllButtonVisible(BUTTON_LIST_SUBMIT_INITIATIVE);
        } else {
            this.setAllButtonVisible(BUTTON_LIST_IN_SUBMIT_PASSIVE);
        }
    }

    private void setTransferAuditSaveButtonVisibility() {
        OperationStatus formStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW == formStatus) {
            this.setAllButtonVisible(BUTTON_LIST_SAVE);
        } else {
            this.setAllButtonVisible(BUTTON_LIST_ADDNEW);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String operateKey = event.getOperateKey();
        if ("close".equals(operateKey)) {
            return;
        }
        OperationResult operationResult = event.getOperationResult();
        if (null != operationResult && operationResult.isSuccess() && TransferCommonUtil.isModifyToView((String)operateKey)) {
            this.setButtonVisible();
        }
    }

    private boolean isOriginator() {
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customParams = param.getCustomParams();
        String menuflag = (String)customParams.get("menuflag");
        if (ObjectUtils.isEmpty((Object)menuflag)) {
            menuflag = TransferCommonUtil.getMenuflagStr((IFormView)this.getView());
        }
        String originator = (String)this.getModel().getValue("originator");
        return TransferCommonUtil.isOrginator((String)menuflag, (String)originator);
    }

    protected String getTransferAuditStatus() {
        String formId = this.getView().getFormShowParameter().getFormId();
        String transferAuditStatus = "LD";
        if ("hdm_transferinbill".equals(formId)) {
            transferAuditStatus = (String)this.getModel().getValue("transferinstatus");
        } else if ("hdm_transferoutbill".equals(formId)) {
            transferAuditStatus = (String)this.getModel().getValue("transferoutstatus");
        } else if ("hdm_transferapply".equals(formId)) {
            transferAuditStatus = (String)this.getModel().getValue("billstatus");
        }
        return transferAuditStatus;
    }

    private void setAllButtonInvisible(List<String> buttonList) {
        buttonList.stream().forEach(button -> this.getView().setVisible(Boolean.FALSE, new String[]{button}));
    }

    private void setAllButtonVisible(List<String> buttonList) {
        buttonList.stream().forEach(button -> this.getView().setVisible(Boolean.TRUE, new String[]{button}));
    }
}

