/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.business.common.PermissionValidateUtil;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.domain.transfer.executor.MixOperationExecutor;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferConfirmValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPostPatternService;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.common.transfer.util.TransferJudgementUtil;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;

public class TransferOperationEdit
extends HRCoreBaseBillEdit {
    private static final String LOCKSIMBLE = "TransferInfoChangeAndConfirm";
    private static final Log LOGGER = LogFactory.getLog(TransferOperationEdit.class);
    private static final String IDENTIFYING_CLOSE = "close";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("viewflowchart".equals(opKey)) {
            BillShowParameter formShowParameter = (BillShowParameter)view.getFormShowParameter();
            WorkflowServiceHelper.viewFlowchart((String)formShowParameter.getPageId(), (Object)formShowParameter.getPkId());
            args.setCancel(true);
            return;
        }
        if ("save".equals(opKey) || "submit".equals(opKey) || "submiteffect".equals(opKey)) {
            ITransferPostPatternService transferPostPatternService = ITransferPostPatternService.getInstance();
            transferPostPatternService.setPositionMustInputByPostPattern(this.getModel().getDataEntity(), model, this.getView());
        }
        if (HRStringUtils.equals((String)"donothing_close", (String)opKey)) {
            if (this.getModel().getDataChanged()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u9000\u51fa\u5417\uff1f", (String)"TransferOperationEdit_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(IDENTIFYING_CLOSE, (IFormPlugin)this));
            } else {
                this.close();
            }
        }
        if ("donothing_confirm".equals(opKey)) {
            this.confirmTransferBills();
        }
        if (!this.validateSubmit(operate)) {
            args.setCancel(true);
        }
        if (!this.validateSubmitEffect(operate)) {
            args.setCancel(true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "closeCallBackSubmit": 
            case "closeCallBackSubmitEffect": {
                String opType;
                Set returnSet;
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                Set set = returnSet = returnData == null ? null : (Set)returnData.get("data");
                if (returnData == null || "op_cancel".equals(opType = (String)returnData.get("opType"))) break;
                if (returnSet != null && returnSet.contains("submitcallback_jobvalidate")) {
                    this.handleJobValidate();
                }
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("isValidateTips", "false");
                operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
                String op = "submit";
                if ("closeCallBackSubmitEffect".equals(actionId)) {
                    op = "submiteffect";
                }
                this.getView().invokeOperation(op, operateOption);
                break;
            }
            case "firstConfirm": {
                try {
                    IHRAppCache ihrAppCache = HRAppCache.get((String)LOCKSIMBLE);
                    String lockKey = String.valueOf(this.getModel().getValue("id"));
                    DLock.forceUnlock((String[])new String[]{lockKey});
                    ihrAppCache.remove(lockKey);
                    ihrAppCache.remove(lockKey + "type");
                }
                catch (Exception e) {
                    LOGGER.error("TransferApply firstConfirm  closedCallBack error Exception is :{} ", (Object)e.getMessage());
                }
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        if (HRStringUtils.equals((String)actionId, (String)IDENTIFYING_CLOSE) && MessageBoxResult.Yes == resultValue) {
            this.close();
        }
    }

    private void close() {
        this.getModel().setDataChanged(false);
        this.getView().close();
    }

    private DynamicObject[] initData() {
        Object id = this.getModel().getValue("id");
        return TransferBillRepository.getInstance().query(TransferStaffService.getInstance().getSelectProperties(), new QFilter[]{new QFilter("id", "=", id)});
    }

    private boolean validateSubmit(AbstractOperate operate) {
        DynamicObject[] transferBills;
        String opKey = operate.getOperateKey();
        if (!HRStringUtils.equals((String)"submit", (String)opKey)) {
            return true;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String menuflag = (String)customParams.get("menuflag");
        if (menuflag == null) {
            String formId = this.getView().getFormShowParameter().getFormId();
            if (formId.contains("hdm_transferoutbill")) {
                menuflag = "out";
            } else if (formId.contains("hdm_transferinbill")) {
                menuflag = "in";
            } else if (formId.contains("hdm_transferapply")) {
                menuflag = "apply";
            }
        }
        DynamicObject dynamicObject = (transferBills = this.initData()).length == 0 ? this.getModel().getDataEntity() : (TransferJudgementUtil.EDIT.test(this.getView().getFormShowParameter().getStatus()) ? this.getModel().getDataEntity() : transferBills[0]);
        PermissionValidateUtil.setAppId((String)this.getView().getFormShowParameter().getAppId());
        MixOperationExecutor validator = new MixOperationExecutor("workflowflag", "validate");
        List dataDivs = (List)validator.execute(Collections.singletonList(dynamicObject)).apply(menuflag);
        String value = (String)this.getModel().getValue("workflowflag");
        if (!"0".equals(value)) {
            this.getModel().setValue("auditstatus", (Object)"A");
        }
        return this.handleValidate(operate, dataDivs, "closeCallBackSubmit");
    }

    private boolean validateSubmitEffect(AbstractOperate operate) {
        String opKey = operate.getOperateKey();
        if (!HRStringUtils.equals((String)"submiteffect", (String)opKey)) {
            return true;
        }
        IDataModel model = this.getModel();
        String menuFlag = TransferCommonUtil.getMenuflagStr((IFormView)this.getView());
        DynamicObject[] transferBills = this.initData();
        DynamicObject dynamicObject = transferBills.length == 0 ? this.getModel().getDataEntity() : transferBills[0];
        PermissionValidateUtil.setAppId((String)this.getView().getFormShowParameter().getAppId());
        ArrayList<DataDiv> dataDivs = (ArrayList<DataDiv>)ITransferValidatorService.getInstance().batchSubmitEffectValidate(Collections.singletonList(dynamicObject)).apply(menuFlag);
        if (null == dataDivs) {
            dataDivs = new ArrayList<DataDiv>();
        }
        return this.handleValidate(operate, dataDivs, "closeCallBackSubmitEffect");
    }

    private boolean handleValidate(AbstractOperate operate, List<DataDiv> dataDivs, String callbackId) {
        ValidateContext validateContext = dataDivs.get(0).getValidatorContext();
        if (validateContext.getValidateResult().size() > 0) {
            this.getView().showErrorNotification(dataDivs.get(0).getValidatorContext().map2String());
            return false;
        }
        if (operate.getOption().containsVariable("isValidateTips") && "false".equals(operate.getOption().getVariableValue("isValidateTips"))) {
            return true;
        }
        IDataModel model = this.getModel();
        DynamicObject aEvealuationJob = (DynamicObject)model.getValue("aevaluationjob");
        DynamicObject aJobGrade = (DynamicObject)model.getValue("ajobgrade");
        DynamicObject aJobLevel = (DynamicObject)model.getValue("ajoblevel");
        Map devConfigFields = ITransferConfirmValidatorService.getInstance().getDevConfigFields("out");
        if (aEvealuationJob == null && aJobGrade == null && aJobLevel == null && devConfigFields.get("ajobgrade") != null && ((Boolean)devConfigFields.get("ajobgrade")).booleanValue()) {
            validateContext.setTips("submitcallback_jobvalidate", ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c\u8bc4\u5b9a\u804c\u4f4d\u201d\u3001\u201c\u804c\u7ea7\u201d\u3001\u201c\u804c\u7b49\u201d \u5b57\u6bb5\u503c\u5747\u4e3a\u7a7a\uff0c\u7cfb\u7edf\u5c06\u9ed8\u8ba4\u8c03\u52a8\u540e\u4e0d\u8fdb\u884c\u804c\u4f4d\u3001\u804c\u7ea7\u3001\u804c\u7b49\u8c03\u6574\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TransferOperationEdit_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
        if (validateContext.getValidateTips().size() > 0) {
            HashMap<String, LinkedHashMap> params = new HashMap<String, LinkedHashMap>(2);
            params.put("message", validateContext.getValidateTips());
            TransferPageUtil.showModalWithCloseCallback((AbstractFormPlugin)this, (String)"hdm_tipsconfirm", params, (String)callbackId);
            return false;
        }
        return true;
    }

    private void handleJobValidate() {
        IDataModel model = this.getModel();
        model.setValue("ajoborg", model.getValue("bjoborg"));
        model.setValue("aevaluationjob", model.getValue("bevaluationjob"));
        model.setValue("ajobgradescm", model.getValue("bjobgradescm"));
        model.setValue("ajobgrade", model.getValue("bjobgrade"));
        model.setValue("ajoblevelscm", model.getValue("bjoblevelscm"));
        model.setValue("ajoblevel", model.getValue("bjoblevel"));
        DynamicObject bevaluationjob = (DynamicObject)model.getValue("bevaluationjob");
        if (null != bevaluationjob) {
            model.setValue("ajobscm", bevaluationjob.get("jobscm"));
            model.setValue("ajobfamily", bevaluationjob.get("jobfamily"));
            model.setValue("ajobclass", bevaluationjob.get("jobclass"));
            model.setValue("ajobseq", bevaluationjob.get("jobseq"));
        }
    }

    private void confirmTransferBills() {
        DynamicObject[] transferBills = this.initData();
        List dataDivs = ITransferValidatorService.getInstance().batchConfirmValidate(Arrays.asList(transferBills));
        ValidateContext validatorContext = ((DataDiv)dataDivs.get(0)).getValidatorContext();
        if (validatorContext.getValidateResult().size() > 0) {
            this.getView().showErrorNotification(validatorContext.map2String());
            return;
        }
        Object id = transferBills[0].get("id");
        String lockKey = id.toString();
        DLock dLock = DLock.create((String)lockKey);
        IHRAppCache ihrAppCache = HRAppCache.get((String)LOCKSIMBLE);
        if (!dLock.tryLock(300L)) {
            String name = (String)ihrAppCache.get(lockKey, String.class);
            String operationType = (String)ihrAppCache.get(lockKey + "type", String.class);
            String errMsg = String.format(ResManager.loadKDString((String)"\u7528\u6237\u201c%1$s\u201d\u6b63\u5728\u64cd\u4f5c\u201c%2$s\u201d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TransferBillList_21", (String)"hr-hdm-formplugin", (Object[])new Object[0]), name, operationType);
            this.getView().showErrorNotification(errMsg);
        } else {
            try {
                ihrAppCache.put(lockKey, (Object)RequestContext.get().getUserName());
                ihrAppCache.put(lockKey + "type", (Object)ResManager.loadKDString((String)"\u786e\u8ba4\u5230\u5c97", (String)"TransferBillList_22", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                String entityNum = this.getView().getFormShowParameter().getFormId();
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setFormId("hdm_transferconfirm");
                formShowParameter.setCustomParam("id", id);
                formShowParameter.setCustomParam("entityNum", (Object)entityNum);
                formShowParameter.setCustomParam("billFormId", (Object)"hdm_transferapply");
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "firstConfirm"));
                this.getView().showForm(formShowParameter);
            }
            catch (Exception exception) {
                LOGGER.error("confirmTransferBills error exception is {}", (Object)exception.getMessage());
                DLock.forceUnlock((String[])new String[]{lockKey});
            }
        }
    }
}

