/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.common;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Map;
import java.util.Optional;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TipsListener;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;

public class TransferPersonalCardPlugin
extends HRDynamicFormBasePlugin
implements TipsListener {
    private static final String SUFFIX_TITLE = "title";
    private static final String SUFFIX_VECTOR = "vector";
    private static final String[] BUSINESS_CARD_ARR = new String[]{"supervisor", "orgleader"};

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Arrays.stream(BUSINESS_CARD_ARR).forEach(item -> this.addTipsListener((String)item));
    }

    public void beforeBindData(EventObject eventObject) {
        String postpattern;
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        IFormView formView = this.getView();
        this.setPersonBaseInfo(formView, customParams);
        this.setLeaderInfo(formView, customParams, "supervisor");
        this.setLeaderInfo(formView, customParams, "orgleader");
        this.setWithTitle(formView, customParams, "department");
        this.setWithTitle(formView, customParams, "company");
        TransferPageUtil.setLabelValue((IFormView)formView, (String)"laborrelstatus", customParams.get("laborrelstatus"));
        TransferPageUtil.setLabelValue((IFormView)formView, (String)"laborreltype", customParams.get("laborreltype"));
        TransferPageUtil.setLabelValue((IFormView)formView, (String)"employmenttype", customParams.get("employmenttype"));
        switch (postpattern = this.getStringParam(customParams, "postpattern")) {
            case "0": {
                TransferPersonalCardPlugin.setLablelVisible(formView, "position", Boolean.FALSE);
                TransferPersonalCardPlugin.setLablelVisible(formView, "job", Boolean.FALSE);
                this.setWithTitle(formView, customParams, "stposition");
                break;
            }
            case "1": {
                TransferPersonalCardPlugin.setLablelVisible(formView, "stposition", Boolean.FALSE);
                TransferPersonalCardPlugin.setLablelVisible(formView, "job", Boolean.FALSE);
                this.setWithTitle(formView, customParams, "position");
                break;
            }
            case "2": {
                TransferPersonalCardPlugin.setLablelVisible(formView, "stposition", Boolean.FALSE);
                TransferPersonalCardPlugin.setLablelVisible(formView, "position", Boolean.FALSE);
                this.setWithTitle(formView, customParams, "job");
                break;
            }
            default: {
                TransferPersonalCardPlugin.setLablelVisible(formView, "stposition", Boolean.FALSE);
                TransferPersonalCardPlugin.setLablelVisible(formView, "position", Boolean.FALSE);
                TransferPersonalCardPlugin.setLablelVisible(formView, "job", Boolean.FALSE);
            }
        }
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        Control source = (Control)evt.getSource();
        FormShowParameter formshowParameter = evt.getFormshowParameter();
        if (formshowParameter == null) {
            formshowParameter = new FormShowParameter();
        }
        String controlKey = source.getKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        for (String businessKey : BUSINESS_CARD_ARR) {
            if (!controlKey.endsWith(businessKey)) continue;
            String key = businessKey;
            Map leaderMap = (Map)customParams.get(key);
            formshowParameter.setCustomParam("id", (Object)String.valueOf(leaderMap.get("id")));
            formshowParameter.setCustomParam("name", (Object)String.valueOf(leaderMap.get("name")));
            formshowParameter.setCustomParam("number", (Object)String.valueOf(leaderMap.get("number")));
            evt.setFormshowParameter(formshowParameter);
        }
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
    }

    private void addTipsListener(String key) {
        String avatarKey;
        Image image;
        IFormView formView = this.getView();
        Label label = (Label)formView.getControl(key);
        if (label != null) {
            label.addTipsListener((TipsListener)this);
        }
        if ((image = (Image)formView.getControl(avatarKey = String.format("%s%s", "avatar", key))) != null) {
            image.addTipsListener((TipsListener)this);
        }
    }

    private void setPersonBaseInfo(IFormView formView, Map<String, Object> customParams) {
        Map personMap = (Map)customParams.get("person");
        TransferPageUtil.setLabelValue((IFormView)formView, (String)"name", personMap.get("name"));
        TransferPageUtil.setLabelValue((IFormView)formView, (String)"worknumber", personMap.get("number"));
        customParams.put("gender", this.getGender(personMap.get("id")));
        this.setWithTitle(formView, customParams, "gender");
        String personAvatar = null == personMap.get("headsculpture") ? "" : (String)personMap.get("headsculpture");
        TransferPersonalCardPlugin.setAvatar(formView, "avatar", HRImageUrlUtil.getImageFullUrl((String)personAvatar));
    }

    private String getGender(Object personId) {
        String gender = "";
        if (!ObjectUtils.isEmpty((Object)personId)) {
            Map personBaseInfo = PersonExternalService.getInstance().invokeGetPersonBaseInfo(((Long)personId).longValue());
            gender = null == personBaseInfo ? gender : (String)personBaseInfo.get("gender");
        }
        return gender;
    }

    private void setLeaderInfo(IFormView formView, Map<String, Object> customParams, String leaderKey) {
        Map leaderMap = (Map)customParams.get(leaderKey);
        if (ObjectUtils.isEmpty((Object)leaderMap)) {
            String leaderPanel = String.format("%s%s", leaderKey, "panel");
            formView.setVisible(Boolean.FALSE, new String[]{leaderPanel});
            return;
        }
        if (!ObjectUtils.isEmpty(leaderMap.get("headsculpture"))) {
            String avatarKey = String.format("%s%s", "avatar", leaderKey);
            TransferPersonalCardPlugin.setAvatar(formView, avatarKey, HRImageUrlUtil.getImageFullUrl((String)((String)leaderMap.get("headsculpture"))));
        }
    }

    private void setWithTitle(IFormView formView, Map<String, Object> customParam, String key) {
        String context = this.getStringParam(customParam, key);
        String title = key + SUFFIX_TITLE;
        String vector = key + SUFFIX_VECTOR;
        if (HRStringUtils.isEmpty((String)context)) {
            formView.setVisible(Boolean.FALSE, new String[]{key, title, vector});
            return;
        }
        formView.setVisible(Boolean.TRUE, new String[]{key, title});
        Label label = (Label)formView.getControl(key);
        label.setText(context);
    }

    private String getStringParam(Map<String, Object> params, String key) {
        return Optional.ofNullable(params.get(key)).map(Object::toString).orElse("");
    }

    public static void setAvatar(IFormView formView, String avatarKey, String avatarUrl) {
        Image image = (Image)formView.getControl(avatarKey);
        if (!ObjectUtils.isEmpty((Object)avatarUrl)) {
            image.setUrl(avatarUrl);
        } else {
            image.setUrl(HRImageUrlUtil.getImageFullUrl((String)"/images/pc/emotion/default_person_82_82.png"));
        }
    }

    public static void setLablelVisible(IFormView formView, String key, Boolean flag) {
        String vector = key + SUFFIX_VECTOR;
        formView.setVisible(flag, new String[]{key, vector});
    }
}

