/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.hr.hdm.business.domain.transfer.service.HdmConsumer;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferAffactionServiceImpl;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.EntryPropertyChangedHandler;
import kd.sdk.hr.hdm.business.transfer.ITransferAffactionService;

public class AffactionHandler
extends EntryPropertyChangedHandler {
    private static final AffactionHandler affactionHandler = new AffactionHandler();
    private static final String[] ENABLE_FIELDS = new String[]{"acompany", "aposition", "aorg", "astposition", "abaselocation", "amanagescope", "postpattern", "ajob", "arealityorgleader", "arealitysuperior"};
    private static final List<String> MY_TRANSFER_SPECIFIC_FIELDS = Arrays.asList("acompany", "aorg", "aposition", "abaselocation");

    public static EntryPropertyChangedHandler getInstance() {
        return affactionHandler;
    }

    @Override
    protected HdmConsumer<IFormView, IDataModel, Integer> propertyChange(Object newValue, String propertyName) {
        return (view, model, rowIndex) -> {
            if (TransferCommonUtil.isAuditView((IFormView)view)) {
                return;
            }
            boolean isMyTransferPage = "hdm_mytransferbill".equals(view.getFormShowParameter().getFormId());
            DynamicObject affAction = (DynamicObject)model.getValue("affaction", rowIndex.intValue());
            if (null == affAction) {
                for (String field : ENABLE_FIELDS) {
                    if (isMyTransferPage && MY_TRANSFER_SPECIFIC_FIELDS.contains(field)) continue;
                    view.setEnable(Boolean.FALSE, new String[]{field});
                    model.setValue(field, null);
                }
                model.setValue("postpattern", (Object)"1");
                return;
            }
            PluginProxy pluginProxy = PluginProxy.create((Object)new TransferAffactionServiceImpl(), ITransferAffactionService.class, (String)ITransferAffactionService.class.getName(), null);
            pluginProxy.callReplaceIfPresent(service -> {
                service.setAffactionRelativeField(model);
                return "";
            });
            String menuFlag = (String)this.getMenuFlag().apply(view, model, rowIndex);
            Object person = model.getValue("out".equals(menuFlag) ? "ermanfile" : "personfield", rowIndex.intValue());
            if (null != person) {
                this.setEnable().accept(view, model, rowIndex);
                if (1050L == affAction.getLong("id") || 201050L == affAction.getLong("id")) {
                    view.setEnable(Boolean.FALSE, new String[]{"acompany"});
                }
            }
        };
    }
}

