/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.common.propertychange.handler;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.transfer.service.HdmConsumer;
import kd.hr.hdm.business.domain.transfer.service.HdmFunction;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPostPatternService;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.external.JobExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferPostPatternServiceImpl;
import kd.hr.hdm.common.transfer.enums.TransferOriginatorEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;
import kd.hr.hdm.formplugin.transfer.web.common.propertychange.EntryPropertyChangedHandler;
import kd.hr.hpfs.business.service.cert.HRCertValidateServiceHelper;
import org.apache.commons.lang.StringUtils;

public class ErmanFileHandler
extends EntryPropertyChangedHandler {
    private static final Log LOGGER = LogFactory.getLog(ErmanFileHandler.class);
    private static final ErmanFileHandler armanFileHandler = new ErmanFileHandler();

    public static ErmanFileHandler getInstance() {
        return armanFileHandler;
    }

    @Override
    protected HdmConsumer<IFormView, IDataModel, Integer> propertyChange(Object newValue, String propertyName) {
        return (view, model, rowIndex) -> this.setDataAfterErmanfile(newValue, propertyName).accept(view, model, rowIndex);
    }

    private HdmConsumer<IFormView, IDataModel, Integer> setDataAfterErmanfile(Object newValue, String propertyName) {
        return (view, model, rowIndex) -> {
            if (null == newValue) {
                view.invokeOperation("refresh");
                return;
            }
            DynamicObject dynamicObject = (DynamicObject)newValue;
            long ermanfileID = dynamicObject.getLong("id");
            this.setDataAfterErmanfile(ermanfileID).accept(view, model, rowIndex);
            this.setPositionMustInputByPostPattern((IFormView)view, (IDataModel)model);
        };
    }

    public HdmConsumer<IFormView, IDataModel, Integer> setDataAfterErmanfile(long ermanfileId) {
        return (view, model, rowIndex) -> {
            String validateResult;
            Map erManFile;
            String licenseValidateMsg;
            List erManFileList = PersonExternalService.getInstance().invokeGetCardFields(Collections.singletonList(ermanfileId));
            if (erManFileList.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5230\u4eba\u5458\u5361\u7247\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ErmanFileHandler_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            }
            if (!TransferOriginatorEnum.MY.getOriginator().equals(model.getValue("originator"))) {
                this.clearPersonInfo().accept(view, model, rowIndex);
            }
            if (StringUtils.isNotEmpty((String)(licenseValidateMsg = (String)this.licenseValidate((Long)(erManFile = (Map)erManFileList.get(0)).get("person_id")).apply(view, model, rowIndex)))) {
                this.showErrorMsgAndClearnPersonInfo(licenseValidateMsg).accept(view, model, rowIndex);
                return;
            }
            if (!HRStringUtils.equals((String)TransferOriginatorEnum.MY.getOriginator(), (String)((String)model.getValue("originator"))) && !HRStringUtils.isEmpty((String)(validateResult = ITransferValidatorService.getInstance().checkRepeatByErmanfile(erManFile)))) {
                this.showErrorMsgAndClearnPersonInfo(validateResult).accept(view, model, rowIndex);
                return;
            }
            model.setValue("person", erManFile.get("person_id"), rowIndex.intValue());
            model.setValue("bemployee", erManFile.get("employee_id"), rowIndex.intValue());
            model.setValue("bmanagescope", erManFile.get("managingscope_id"), rowIndex.intValue());
            model.setValue("bcmp", erManFile.get("cmpemp_id"));
            model.setValue("bdepemp", erManFile.get("depemp_id"), rowIndex.intValue());
            model.beginInit();
            model.setValue("personfield", erManFile.get("depemp_id"), rowIndex.intValue());
            model.setValue("ermanfile", (Object)ermanfileId, rowIndex.intValue());
            model.endInit();
            model.setValue("b_ermanfile", (Object)ermanfileId);
            model.setValue("bhrbu", erManFile.get("org_id"), rowIndex.intValue());
            model.setValue("bempgroup", erManFile.get("empgroup_id"), rowIndex.intValue());
            model.setValue("baffiliateorg", erManFile.get("affiliateadminorg_id"), rowIndex.intValue());
            model.setValue("bcountry", erManFile.get("location_country_id"), rowIndex.intValue());
            model.setValue("postype", erManFile.get("postype_id"), rowIndex.intValue());
            model.setValue("posstatus", erManFile.get("posstatus_id"), rowIndex.intValue());
            model.setValue("bcompany", erManFile.get("company_id"), rowIndex.intValue());
            model.setValue("borg", erManFile.get("adminorg_id"), rowIndex.intValue());
            model.setValue("bposition", erManFile.get("position_id"), rowIndex.intValue());
            model.setValue("bpostpattern", erManFile.get("apositiontype"), rowIndex.intValue());
            model.setValue("bstposition", erManFile.get("stdposition_id"), rowIndex.intValue());
            model.setValue("bbaselocation", erManFile.get("location_id"), rowIndex.intValue());
            model.setValue("laborreltype", erManFile.get("laborreltype_id"), rowIndex.intValue());
            model.setValue("laborrelstatus", erManFile.get("laborrelstatus_id"), rowIndex.intValue());
            Object job_id = erManFile.get("job_id");
            model.setValue("bjob", erManFile.get("job_id"), rowIndex.intValue());
            String postPattern = (String)erManFile.get("apositiontype");
            if (!HRStringUtils.equals((String)postPattern, (String)"") && null == job_id) {
                view.setVisible(Boolean.FALSE, new String[]{"bjob"});
            } else if (job_id != null) {
                view.setVisible(Boolean.TRUE, new String[]{"bjob"});
            }
            DynamicObject affaction = (DynamicObject)model.getValue("affaction");
            if (affaction != null) {
                this.setEnable().accept(view, model, rowIndex);
                if (1050L == affaction.getLong("id") || 201050L == affaction.getLong("id")) {
                    model.setValue("acompany", model.getValue("bcompany"));
                    model.setValue("aorg", null);
                }
            }
            this.getChargeinfo(erManFile).accept(view, model, rowIndex);
            this.getSuperior(erManFile).accept(view, model, rowIndex);
            this.showPersonalInfoPanel().accept(view, model, rowIndex);
            LOGGER.info("getJobGrade before employee_id: {}", erManFile.get("employee_id"));
            this.getJobGrade(Collections.singletonList((Long)erManFile.get("employee_id")), "hrpi_empjobrel").accept(view, model, rowIndex);
            ITransferBillService.getInstance().setTransferBillDateRange().accept(view, model, rowIndex);
        };
    }

    private HdmConsumer<IFormView, IDataModel, Integer> getSuperior(Map<String, Object> ermanfile) {
        return (view, model, rowIndex) -> {
            List superiorinfo = (List)ermanfile.get("superiorinfo");
            if (null != superiorinfo) {
                List id = superiorinfo.stream().map(temp -> temp.get("id")).collect(Collectors.toList());
                model.setValue("bsuperior", (Object)id.toArray(), rowIndex.intValue());
            }
        };
    }

    private HdmConsumer<IFormView, IDataModel, Integer> getChargeinfo(Map<String, Object> ermanfile) {
        return (view, model, rowIndex) -> {
            List chargeinfo = (List)ermanfile.get("chargeinfo");
            if (null != chargeinfo) {
                List id = chargeinfo.stream().map(temp -> temp.get("id")).collect(Collectors.toList());
                model.setValue("borgleader", (Object)id.toArray(), rowIndex.intValue());
            }
        };
    }

    private HdmConsumer<IFormView, IDataModel, Integer> clearPersonInfo() {
        return (view, model, rowIndex) -> {
            model.setValue("postpattern", (Object)"1", rowIndex.intValue());
            model.setValue("person", null, rowIndex.intValue());
            model.setValue("bemployee", null, rowIndex.intValue());
            model.setValue("bmanagescope", null, rowIndex.intValue());
            model.setValue("bdepemp", null, rowIndex.intValue());
            model.setValue("bhrbu", null, rowIndex.intValue());
            model.setValue("bempgroup", null, rowIndex.intValue());
            model.setValue("baffiliateorg", null, rowIndex.intValue());
            model.setValue("bcountry", null, rowIndex.intValue());
            model.setValue("bpostpattern", null, rowIndex.intValue());
            model.setValue("postype", null, rowIndex.intValue());
            model.setValue("posstatus", null, rowIndex.intValue());
            model.setValue("bcompany", null, rowIndex.intValue());
            model.setValue("borg", null, rowIndex.intValue());
            model.setValue("bposition", null, rowIndex.intValue());
            model.setValue("bstposition", null, rowIndex.intValue());
            model.setValue("bjob", null, rowIndex.intValue());
            model.setValue("bbaselocation", null, rowIndex.intValue());
            model.setValue("laborreltype", null, rowIndex.intValue());
            model.setValue("laborrelstatus", null, rowIndex.intValue());
            model.setValue("acompany", null, rowIndex.intValue());
            model.setValue("aorg", null, rowIndex.intValue());
            model.setValue("aposition", null, rowIndex.intValue());
            model.setValue("astposition", null, rowIndex.intValue());
            model.setValue("ajob", null, rowIndex.intValue());
            model.setValue("amanagescope", null, rowIndex.intValue());
            model.setValue("superiorchannel", (Object)"0", rowIndex.intValue());
            model.setValue("arealitysuperior", null, rowIndex.intValue());
            model.setValue("abaselocation", null, rowIndex.intValue());
            model.setValue("arealityorgleader", null, rowIndex.intValue());
            model.setValue("borgleader", null, rowIndex.intValue());
            model.setValue("bsuperior", null, rowIndex.intValue());
            model.setValue("affaction", null, rowIndex.intValue());
            model.setValue("workingplan", null, rowIndex.intValue());
            model.setValue("transclassify", null, rowIndex.intValue());
            model.setValue("transferreason", null, rowIndex.intValue());
            model.setValue("plandate", null, rowIndex.intValue());
            model.setValue("realitydate", null, rowIndex.intValue());
            model.setValue("transferoutlastdate", null, rowIndex.intValue());
            model.setValue("appdispatchnum", null, rowIndex.intValue());
            model.setValue("appremoverel", null, rowIndex.intValue());
            model.setValue("description", null, rowIndex.intValue());
            model.setValue("ajoborg", null, rowIndex.intValue());
            model.setValue("aevaluationjob", null, rowIndex.intValue());
            model.setValue("ajobgradescm", null, rowIndex.intValue());
            model.setValue("ajobgrade", null, rowIndex.intValue());
            model.setValue("ajoblevelscm", null, rowIndex.intValue());
            model.setValue("ajoblevel", null, rowIndex.intValue());
            model.setValue("ajobscm", null, rowIndex.intValue());
            model.setValue("ajobfamily", null, rowIndex.intValue());
            model.setValue("ajobclass", null, rowIndex.intValue());
            model.setValue("ajobseq", null, rowIndex.intValue());
            model.setValue("bjoborg", null, rowIndex.intValue());
            model.setValue("bevaluationjob", null, rowIndex.intValue());
            model.setValue("bjobgradescm", null, rowIndex.intValue());
            model.setValue("bjobgrade", null, rowIndex.intValue());
            model.setValue("bjoblevelscm", null, rowIndex.intValue());
            model.setValue("bjoblevel", null, rowIndex.intValue());
            model.setValue("ajobclasstext", null, rowIndex.intValue());
            model.setValue("bjobclasstext", null, rowIndex.intValue());
        };
    }

    private HdmConsumer<IFormView, IDataModel, Integer> showErrorMsgAndClearnPersonInfo(String errorMsg) {
        return (view, model, rowIndex) -> {
            view.showErrorNotification(errorMsg);
            model.beginInit();
            model.setValue("personfield", null, rowIndex.intValue());
            model.setValue("ermanfile", null, rowIndex.intValue());
            model.endInit();
        };
    }

    private HdmFunction<IFormView, IDataModel, Integer, String> licenseValidate(long personId) {
        return (view, model, rowIndex) -> {
            String businessMsg = ResManager.loadKDString((String)"\u8c03\u52a8", (String)"ErmanFileHandler_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            String validataMsg = HRCertValidateServiceHelper.getValidataMsg((Long)personId, (String)businessMsg);
            return validataMsg;
        };
    }

    private HdmConsumer<IFormView, IDataModel, Integer> getJobGrade(List<Long> employeeIds, String attachEntityName) {
        return (view, model, rowIndex) -> {
            LOGGER.info("getJobGrade after employee_ids: {}", (Object)employeeIds);
            String selectProps = "hrbu,joblevel,jobgrade,job,jobscm,jobclass,jobfamily,jobseq,joblevel.joblevelscm,jobgrade.jobgradescm,employee";
            List jobGradeList = PersonExternalService.getInstance().listBatchPropEmployeeAttachs(employeeIds, selectProps, attachEntityName);
            if (jobGradeList == null) {
                model.beginInit();
                model.setValue("ermanfile", null, rowIndex.intValue());
                model.setValue("personfield", null, rowIndex.intValue());
                model.endInit();
                view.showErrorNotification(ResManager.loadKDString((String)"\u804c\u7ea7\u804c\u7b49\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5f85\u8c03\u52a8\u4eba\u5458\u3002", (String)"ErmanFileHandler_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (jobGradeList.isEmpty() || jobGradeList.size() == 0) {
                return;
            }
            Map jobInfo = (Map)jobGradeList.get(0);
            Long bjoborg = (Long)jobInfo.get("hrbu");
            LOGGER.info("Transferbill jobhrbu is {}.", (Object)bjoborg);
            if (bjoborg == 0L) {
                model.beginInit();
                model.setValue("ermanfile", null, rowIndex.intValue());
                model.setValue("personfield", null, rowIndex.intValue());
                model.endInit();
                view.showErrorNotification(ResManager.loadKDString((String)"\u804c\u7ea7\u804c\u7b49\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5f85\u8c03\u52a8\u4eba\u5458\u3002", (String)"ErmanFileHandler_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setJobInfo((IDataModel)model, jobInfo);
        };
    }

    private void setJobAllClass(IDataModel model, Long jobId) {
        Map jobClassInfoMap = JobExternalService.getInstance().invokeGetJobClassLongNameByJobAndBsed(Collections.singletonList(jobId), new Date());
        String jobAllClass = jobClassInfoMap.getOrDefault(jobId, "");
        model.setValue("bjobclasstext", (Object)jobAllClass);
        model.setValue("ajobclasstext", (Object)jobAllClass);
    }

    private void setJobInfo(IDataModel model, Map<String, Object> jobInfo) {
        model.setValue("bjoborg", jobInfo.get("hrbu"));
        model.setValue("bevaluationjob", jobInfo.get("job"));
        model.setValue("bjobgradescm", jobInfo.get("jobgrade.jobgradescm"));
        model.setValue("bjobgrade", jobInfo.get("jobgrade"));
        model.setValue("bjoblevelscm", jobInfo.get("joblevel.joblevelscm"));
        model.setValue("bjoblevel", jobInfo.get("joblevel"));
        model.setValue("ajoborg", jobInfo.get("hrbu"));
        model.setValue("aevaluationjob", jobInfo.get("job"));
        model.setValue("ajobgradescm", jobInfo.get("jobgrade.jobgradescm"));
        model.setValue("ajobgrade", jobInfo.get("jobgrade"));
        model.setValue("ajoblevelscm", jobInfo.get("joblevel.joblevelscm"));
        model.setValue("ajoblevel", jobInfo.get("joblevel"));
        model.setValue("ajobscm", jobInfo.get("jobscm"));
        model.setValue("ajobfamily", jobInfo.get("jobfamily"));
        model.setValue("ajobclass", jobInfo.get("jobclass"));
        model.setValue("ajobseq", jobInfo.get("jobseq"));
        this.setJobAllClass(model, (Long)jobInfo.getOrDefault("job", 0));
    }

    private HdmConsumer<IFormView, IDataModel, Integer> showPersonalInfoPanel() {
        return (view, model, rowIndex) -> {
            if (view.getFormShowParameter().getFormId().equals("hdm_transferbatch")) {
                return;
            }
            if (-1 == rowIndex || 0 == rowIndex) {
                Map personalInfoMap = TransferCommonUtil.buildPersonalInfo((DynamicObject)model.getDataEntity());
                if (ObjectUtils.isEmpty((Object)personalInfoMap)) {
                    return;
                }
                view.setVisible(Boolean.TRUE, new String[]{"personalinfoprepanel"});
                TransferPageUtil.showPageInContainer((IFormView)view, (String)"hdm_personalcard", (String)"personalinfoprepanel", (Map)personalInfoMap);
                TransferPageUtil.showPageInContainer((IFormView)view, (String)"hdm_personalcard", (String)"personcard", (Map)personalInfoMap);
            }
        };
    }

    private void setPositionMustInputByPostPattern(IFormView formView, IDataModel dataModel) {
        TransferPostPatternServiceImpl transferPostPatternService = (TransferPostPatternServiceImpl)ITransferPostPatternService.getInstance();
        transferPostPatternService.setPositionMustInputByPostPattern(dataModel.getDataEntity(), dataModel, formView);
    }
}

