/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.transfer.web.mytransfer;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;

public class MyTransferButtonEdit
extends HRCoreBaseBillEdit {
    private static final String SHOWHISTORYBILL = "showhistorybill";
    private static final String BAR_CLOSE = "bar_close";
    private static final String BAR_DEL = "bar_del";
    private static final String BAR_MODIFY = "bar_modify";
    private static final String BAR_VIEWFLOWCHART = "bar_viewflowchart";
    public static final String BAR_TERMINATION = "bar_termination";
    private static final List<String> BUTTON_LIST_ADDNEW = Arrays.asList("bar_save", "bar_submit", "showhistorybill", "bar_close");
    private static final List<String> BUTTON_LIST_SAVE = Arrays.asList("bar_modify", "bar_submit", "bar_del", "showhistorybill", "bar_close");
    private static final List<String> BUTTON_LIST_TOBE_RESUBMITTED = Arrays.asList("bar_modify", "bar_submit", "bar_viewflowchart", "showhistorybill", "bar_close");
    private static final List<String> BUTTON_LIST_TOBE_RESUBMITTED_TO_MODIFY = Arrays.asList("bar_save", "bar_submit", "bar_close");
    private static final List<String> BUTTON_LIST_TOBE_SUBMITTED = Arrays.asList("bar_unsubmit", "bar_viewflowchart", "showhistorybill", "bar_close");
    private static final List<String> BUTTON_LIST_AUDIT_COMMON = Arrays.asList("bar_viewflowchart", "showhistorybill", "bar_close");
    private static final List<String> BUTTON_LIST_ALL = Arrays.asList("bar_modify", "bar_save", "bar_submit", "bar_unsubmit", "bar_del", "bar_close", "bar_termination", "bar_viewflowchart", "showhistorybill");

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.setButtonVisible();
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String operateKey = event.getOperateKey();
        if ("close".equals(operateKey)) {
            return;
        }
        OperationResult operationResult = event.getOperationResult();
        if (null != operationResult && operationResult.isSuccess() && TransferCommonUtil.isModifyToView((String)operateKey)) {
            this.setButtonVisible();
        }
    }

    private void setButtonVisible() {
        this.setAllButtonInvisible(BUTTON_LIST_ALL);
        this.transferAuditStatusHandle();
    }

    private void transferAuditStatusHandle() {
        String transferAuditStatus;
        switch (transferAuditStatus = this.getTransferAuditStatus()) {
            case "A": {
                this.setTransferAuditSaveButtonVisibility();
                break;
            }
            case "B": {
                this.setTransferAuditSubmitButtonVisibility();
                break;
            }
            case "D": {
                this.setTransferAuditAuditingButtonVisibility();
                break;
            }
            case "E": {
                this.setTransferAuditRejectButtonVisibility();
                break;
            }
            case "F": {
                this.setTransferAuditAbandonVisibility();
                this.setViewFlowChart();
                break;
            }
            case "C": {
                this.setTransferAuditAuditedButtonVisibility();
                break;
            }
            case "G": {
                this.setTransferAuditToResubmitButtonVisibility();
                break;
            }
        }
    }

    private void setTransferAuditAuditedButtonVisibility() {
        this.setAllButtonVisible(BUTTON_LIST_AUDIT_COMMON);
        this.setViewFlowChart();
    }

    private void setViewFlowChart() {
        boolean isExistWorkFlow = (Boolean)this.getModel().getValue("isexistsworkflow");
        if (!isExistWorkFlow) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_VIEWFLOWCHART});
        }
    }

    private void setTransferAuditAbandonVisibility() {
        this.setAllButtonVisible(BUTTON_LIST_AUDIT_COMMON);
    }

    private void setTransferAuditRejectButtonVisibility() {
        this.setAllButtonVisible(BUTTON_LIST_AUDIT_COMMON);
    }

    private void setTransferAuditAuditingButtonVisibility() {
        this.setAllButtonVisible(BUTTON_LIST_AUDIT_COMMON);
    }

    private void setTransferAuditToResubmitButtonVisibility() {
        OperationStatus formStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW == formStatus) {
            this.setAllButtonVisible(BUTTON_LIST_TOBE_RESUBMITTED);
        } else {
            this.setAllButtonVisible(BUTTON_LIST_TOBE_RESUBMITTED_TO_MODIFY);
        }
    }

    private void setTransferAuditSubmitButtonVisibility() {
        this.setAllButtonVisible(BUTTON_LIST_TOBE_SUBMITTED);
    }

    private void setTransferAuditSaveButtonVisibility() {
        OperationStatus formStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW == formStatus) {
            this.setAllButtonVisible(BUTTON_LIST_SAVE);
        } else {
            this.setAllButtonVisible(BUTTON_LIST_ADDNEW);
        }
    }

    private boolean isOriginator() {
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customParams = param.getCustomParams();
        String menuflag = (String)customParams.get("menuflag");
        String originator = (String)this.getModel().getValue("originator");
        return TransferCommonUtil.isOrginator((String)menuflag, (String)originator);
    }

    protected String getTransferAuditStatus() {
        String formId = this.getView().getFormShowParameter().getFormId();
        String transferAuditStatus = "LD";
        if ("hdm_mytransferbill".equals(formId)) {
            transferAuditStatus = (String)this.getModel().getValue("billstatus");
        }
        return transferAuditStatus;
    }

    private void setAllButtonInvisible(List<String> buttonList) {
        buttonList.forEach(button -> this.getView().setVisible(Boolean.FALSE, new String[]{button}));
    }

    private void setAllButtonVisible(List<String> buttonList) {
        buttonList.forEach(button -> this.getView().setVisible(Boolean.TRUE, new String[]{button}));
    }
}

