/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.parttime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hdm.business.domain.parttime.PerChgBizUtils;
import kd.hr.hdm.business.domain.parttime.external.IJobExternalService;
import kd.hr.hdm.business.domain.parttime.service.IParttimeBillService;
import kd.hr.hdm.business.domain.transfer.service.external.PositionExternalService;
import kd.hr.hdm.business.repository.ParttimeApplyRepository;
import kd.hr.hdm.opplugin.parttime.BatchPartBaseOp;
import kd.hr.hpfs.common.perchg.PerChgBizOperateType;

public class BatchParttimeSubmitEffectOp
extends BatchPartBaseOp {
    private DynamicObject[] effectBillArray;

    public void onAddValidators(AddValidatorsEventArgs args) {
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        DynamicObject batchParttimeBill = dataEntities[0];
        if (batchParttimeBill == null) {
            return;
        }
        this.doSubmitEffect(batchParttimeBill);
    }

    private void doSubmitEffect(DynamicObject batchParttimeBill) {
        DynamicObjectCollection batchParttimeBillCollection = batchParttimeBill.getDynamicObjectCollection("entryentity");
        batchParttimeBill.set("auditstatus", (Object)"C");
        batchParttimeBill.set("billstatus", (Object)"C");
        batchParttimeBill.set("isexistsworkflow", (Object)Boolean.FALSE);
        batchParttimeBillCollection.forEach(parttimeBill -> {
            parttimeBill.set("entrybillstatus", (Object)"C");
            parttimeBill.set("entryauditstatus", (Object)"C");
        });
        DynamicObject[] effectBills = (DynamicObject[])batchParttimeBillCollection.stream().filter(bill -> {
            Date effectDate = bill.getDate("effectdate");
            if (effectDate == null) {
                return false;
            }
            effectDate = HRDateTimeUtils.truncateDate((Date)effectDate);
            Date now = HRDateTimeUtils.truncateDate((Date)new Date());
            if (HRDateTimeUtils.dayAfter((Date)now, (Date)effectDate) || HRDateTimeUtils.dayEquals((Date)now, (Date)effectDate)) {
                bill.set("parttimestatus", (Object)"1");
                return true;
            }
            bill.set("parttimestatus", (Object)"0");
            return false;
        }).toArray(DynamicObject[]::new);
        List reqList = IParttimeBillService.getInstance().createReqList(effectBills);
        if (null != reqList && reqList.size() > 0) {
            ArrayList<Map> bJobReqList = new ArrayList<Map>(reqList.size());
            ArrayList<Map> stdPositionReqList = new ArrayList<Map>(reqList.size());
            for (Map map : reqList) {
                if (map.get("job") != null) {
                    bJobReqList.add(map);
                }
                if (map.get("standardposition") == null) continue;
                stdPositionReqList.add(map);
            }
            if (bJobReqList.size() > 0) {
                Map darkPositionByJob = IJobExternalService.getInstance().getDarkPositionByJob(bJobReqList);
                IParttimeBillService.getInstance().fillTheDarkPosition(effectBills, darkPositionByJob);
            }
            if (stdPositionReqList.size() > 0) {
                Map darkPositionByStdPosition = PositionExternalService.getInstance().invokerAddDarkPosition(stdPositionReqList);
                IParttimeBillService.getInstance().fillTheDarkPosition(effectBills, darkPositionByStdPosition);
            }
        }
        IParttimeBillService.getInstance().changeToBoId(effectBills);
        ParttimeApplyRepository.getInstance().update(batchParttimeBill);
        Set effectSet = Arrays.stream(effectBills).map(effectBill -> effectBill.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] notEffectDys = (DynamicObject[])batchParttimeBillCollection.stream().filter(bill -> !effectSet.contains(bill.getLong("id"))).toArray(DynamicObject[]::new);
        this.effectBillArray = effectBills;
        PerChgBizUtils.personChangeRecord((DynamicObject[])notEffectDys, (PerChgBizOperateType)PerChgBizOperateType.CHGOPERATION_ADDNEW);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if ("submiteffect".equals(e.getOperationKey())) {
            Set effectBillIds = Arrays.stream(this.effectBillArray).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            DynamicObject[] effectBills = ParttimeApplyRepository.getInstance().load(new QFilter("id", "in", effectBillIds).toArray());
            PerChgBizUtils.personChangeOfPart((DynamicObject[])effectBills);
        }
    }
}

