/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.parttime;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hdm.business.domain.parttime.PerChgBizUtils;
import kd.hr.hdm.opplugin.parttime.PartBaseOp;
import kd.hr.hdm.opplugin.parttime.validator.PartBillPChValidator;
import kd.hr.hpfs.common.perchg.PerChgBizOperateType;
import org.apache.commons.lang3.time.StopWatch;

public class PartBillSubmitOp
extends PartBaseOp {
    private static final Log LOGGER = LogFactory.getLog(PartBillSubmitOp.class);
    private static final int CORE_THREAD = Runtime.getRuntime().availableProcessors();
    private static final int MAX_THREAD = CORE_THREAD * 5;
    private static final String APP_ID = "hr";
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"partBillSubmitExecutor-Thread", (int)CORE_THREAD, (int)MAX_THREAD, (String)"hr");

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new PartBillPChValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs event) {
        this.doSubmitAndEffect(event);
    }

    private void doSubmitAndEffect(BeginOperationTransactionArgs event) {
        StopWatch stopWatch = new StopWatch("doSubmitAndEffect start");
        stopWatch.start();
        DynamicObject[] bills = event.getDataEntities();
        THREAD_POOL.execute(() -> PerChgBizUtils.personChangeRecord((DynamicObject[])bills, (PerChgBizOperateType)PerChgBizOperateType.CHGOPERATION_ADDNEW));
        stopWatch.stop();
        LOGGER.info("doSubmitAndEffect finish ,cost time :{}", (Object)stopWatch.getNanoTime());
    }
}

