/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.parttime;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.ReflectionUtils;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.personnelchange.servicehelper.PersonnelChangeServiceHelper;

public class PartPersonInfoImportOp
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(PartPersonInfoImportOp.class);
    public static final String APP_KEY = "hdm_parttimeapplybill_import";
    public static final String REPEAT_KEY = "KEY_PartPersonInfoImportOp_NUMBER_";

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        try {
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            try {
                FormView formView = (FormView)view.get(ctx);
                formView.setVisible(Boolean.FALSE, new String[]{"radiofield1", "radiofield2"});
            }
            catch (IllegalAccessException e) {
                LOGGER.error(e.getMessage());
            }
        }
        catch (NoSuchFieldException e) {
            LOGGER.error(e.getMessage());
        }
        return super.setContext(rc, ctx, startArgs);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        String type = ((JSONObject)rowdatas.get(0).getData().get((Object)"affaction")).containsKey((Object)"number") ? "number" : "name";
        Set affactions = rowdatas.stream().map(importBillData -> importBillData.getData().getJSONObject("affaction").getString(type)).collect(Collectors.toSet());
        Map newAffactionMap = PersonnelChangeServiceHelper.getNewAffactionMap((String)type, affactions, (String)"hdm_parttime_hpfs_new");
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData importBillData2 = iterator.next();
            boolean needRemoved = this.validateImportBillData(importBillData2, logger, newAffactionMap);
            if (!needRemoved) continue;
            iterator.remove();
        }
        return super.save(rowdatas, logger);
    }

    private boolean validateImportBillData(ImportBillData importBillData, ImportLogger logger, Map<String, DynamicObject> newAffactionMap) {
        String errorMsg = null;
        JSONObject data = importBillData.getData();
        StringBuilder repeatBuilder = new StringBuilder();
        String positionType = data.getString("apositiontype");
        repeatBuilder.append(data.getJSONObject("partperson").getString("number")).append(data.getJSONObject("aadminorg").getString("number")).append(positionType);
        switch (positionType) {
            case "0": {
                Object aStdPosition = data.get((Object)"astdposition");
                if (aStdPosition == null) {
                    errorMsg = ResManager.loadKDString((String)"\u517c\u804c\u4efb\u5c97\u6a21\u5f0f\u4e3a\u201c\u6807\u51c6\u5c97\u4f4d\u201d\u65f6\uff0c\u5fc5\u987b\u586b\u5199\u201c\u6807\u51c6\u5c97\u4f4d\u201d\u3002", (String)"PartPersonInfoImportOp_0", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
                    break;
                }
                repeatBuilder.append(data.getJSONObject("astdposition").getString("number"));
                break;
            }
            case "1": {
                Object aPosition = data.get((Object)"aposition");
                if (aPosition == null) {
                    errorMsg = ResManager.loadKDString((String)"\u517c\u804c\u4efb\u5c97\u6a21\u5f0f\u4e3a\u201c\u5c97\u4f4d\u201d\u65f6\uff0c\u5fc5\u987b\u586b\u5199\u201c\u5c97\u4f4d\u201d\u3002", (String)"PartPersonInfoImportOp_1", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
                    break;
                }
                repeatBuilder.append(data.getJSONObject("aposition").getString("number"));
                break;
            }
            case "2": {
                Object job = data.get((Object)"bjob");
                if (job == null) {
                    errorMsg = ResManager.loadKDString((String)"\u517c\u804c\u4efb\u5c97\u6a21\u5f0f\u4e3a\u201c\u804c\u4f4d\u201d\uff0c\u5fc5\u987b\u586b\u5199\u201c\u517c\u804c\u804c\u4f4d\u201d\u3002", (String)"PartPersonInfoImportOp_2", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
                    break;
                }
                repeatBuilder.append(data.getJSONObject("bjob").getString("number"));
                break;
            }
        }
        boolean isCorrectAffaction = this.isCorrectAffaction(importBillData, logger, newAffactionMap);
        if (!isCorrectAffaction) {
            return true;
        }
        if (errorMsg != null) {
            this.addErrorMsg(importBillData, logger, errorMsg);
            return true;
        }
        return this.validateRepeat(importBillData, repeatBuilder.toString(), logger);
    }

    private boolean isCorrectAffaction(ImportBillData importBillData, ImportLogger logger, Map<String, DynamicObject> newAffactionMap) {
        JSONObject data = importBillData.getData();
        JSONObject affaction = data.getJSONObject("affaction");
        String type = affaction.containsKey((Object)"number") ? "number" : "name";
        String affactionValue = data.getJSONObject("affaction").getString(type);
        if (!newAffactionMap.isEmpty() && newAffactionMap.containsKey(affactionValue)) {
            data.put("affaction", JsonObjectUtil.genJSONObject.apply(newAffactionMap.get(affactionValue).getLong("id")));
            return true;
        }
        this.addErrorMsg(importBillData, logger, ResManager.loadKDString((String)"\u53d8\u52a8\u64cd\u4f5c\u586b\u5199\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EntryImportDataBuilder_9", (String)"hr-hdm-business", (Object[])new Object[0]));
        return false;
    }

    private boolean validateRepeat(ImportBillData importBillData, String repeatKey, ImportLogger logger) {
        String key = REPEAT_KEY + RequestContext.get().getTraceId();
        IHRAppCache cache = HRAppCache.get((String)APP_KEY);
        ArrayList<String> dataList = (ArrayList<String>)cache.get(key, List.class);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            dataList = new ArrayList<String>();
        }
        if (dataList.contains(repeatKey)) {
            this.addErrorMsg(importBillData, logger, ResManager.loadKDString((String)"\u5728\u5f53\u524d\u5bfc\u5165\u6a21\u677f\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u517c\u804c\u7533\u8bf7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PartPersonInfoImportOp_3", (String)"hr-hdm-opplugin", (Object[])new Object[0]));
            return true;
        }
        dataList.add(repeatKey);
        cache.put(key, dataList);
        return false;
    }

    private void addErrorMsg(ImportBillData importBillData, ImportLogger logger, String errorMsg) {
        int dataIndex = importBillData.getStartIndex();
        logger.log(Integer.valueOf(dataIndex), errorMsg);
        logger.fail();
    }
}

