/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.parttime;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.application.transfer.service.ITransferBillApplicationService;
import kd.hr.hdm.business.common.SihcConfigUtil;
import kd.hr.hdm.business.domain.parttime.external.IParttimeAdminOrgExternalService;
import kd.hr.hdm.business.domain.parttime.service.IParttimeBillService;
import kd.hr.hdm.business.domain.parttime.service.impl.helper.DirectLeaderHelper;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;
import kd.hr.hdm.common.util.HRServiceUtil;
import kd.hr.hdm.opplugin.parttime.PartBaseOp;
import kd.hr.hdm.opplugin.parttime.validator.PartBillPChHrImportValidator;
import kd.hr.hdm.opplugin.parttime.validator.PartBillPChImportValidator;
import kd.hr.hdm.opplugin.parttime.validator.PartBillPChValidator;
import org.apache.commons.lang3.time.StopWatch;

public class PartSaveOp
extends PartBaseOp {
    private static final Log LOGGER = LogFactory.getLog(PartSaveOp.class);

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new PartBillPChValidator());
        args.addValidator((AbstractValidator)new PartBillPChHrImportValidator());
        args.addValidator((AbstractValidator)new PartBillPChImportValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Map variableMap = this.getOption().getVariables();
        String applySource = "form";
        if (variableMap != null) {
            String batchImport = (String)variableMap.get("batchimport");
            String source = (String)variableMap.get("source");
            if (!HRStringUtils.isEmpty((String)batchImport) && "true".equals(batchImport)) {
                applySource = "import";
            } else if ("hr_import".equals(source)) {
                applySource = "hr_import";
            }
        }
        DynamicObject[] dataEntities = e.getDataEntities();
        if ("import".equals(applySource) || "hr_import".equals(applySource)) {
            Boolean enableSihc = SihcConfigUtil.enableSihc();
            this.setCompany(dataEntities);
            this.setWorkRoleId(dataEntities);
            this.setSuperiorByInvokeInf(dataEntities);
            this.setHisJobByPosition(dataEntities);
            Arrays.stream(dataEntities).forEach(dynamicObject -> {
                this.setJobByStdPosition((DynamicObject)dynamicObject);
                this.setAffiliateAdminOrg((DynamicObject)dynamicObject);
                if (Boolean.TRUE.equals(enableSihc)) {
                    this.setAppRemoveRel((DynamicObject)dynamicObject);
                }
            });
            this.changeVidToBoId(dataEntities);
        }
    }

    private void setWorkRoleId(DynamicObject[] dataEntities) {
        for (DynamicObject dynamicObject : dataEntities) {
            String positionType = dynamicObject.getString("apositiontype");
            if (!"1".equals(positionType)) continue;
            long roleId = dynamicObject.getLong("aposition.workrole.id");
            dynamicObject.set("aworkrole_id", (Object)roleId);
        }
    }

    private void changeVidToBoId(DynamicObject[] dataEntities) {
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            Date effectDate = dataEntity.getDate("effectdate");
            if (effectDate.after(new Date()) || DateUtils.isSameDay((Date)effectDate, (Date)new Date())) {
                IParttimeBillService.getInstance().changeToBoId(dataEntity);
            }
        });
    }

    private void setAffiliateAdminOrg(DynamicObject dataEntity) {
        DynamicObject adminOrg = dataEntity.getDynamicObject("aadminorg");
        Long adminOrgId = HRDyObjectPropUtil.getId((DynamicObject)adminOrg);
        dataEntity.set("affiliateadminorg_id", (Object)(adminOrgId != 0L ? adminOrgId : null));
    }

    private Map<Long, Map<String, Long>> getHrBu(List<Long> adminOrgIdList) {
        List list = HRServiceUtil.getHrBuByBusinessType(adminOrgIdList);
        HashMap<Long, Map<String, Long>> hrBuMap = new HashMap<Long, Map<String, Long>>(list.size());
        if (!ObjectUtils.isEmpty((Object)list)) {
            for (Map map : list) {
                Long adminOrgId = (Long)map.get("adminOrgId");
                hrBuMap.put(adminOrgId, map);
            }
        }
        return hrBuMap;
    }

    private void setCompany(DynamicObject[] dataEntities) {
        List<Long> adminOrgIdList = Arrays.stream(dataEntities).map(dynamicObject -> {
            DynamicObject adminOrg = dynamicObject.getDynamicObject("aadminorg");
            return HRDyObjectPropUtil.getId((DynamicObject)adminOrg);
        }).collect(Collectors.toList());
        Map<Long, Map<String, Long>> hrBuMap = this.getHrBu(adminOrgIdList);
        Map orgInfoMap = HRServiceUtil.adminOrgInfoQuery(adminOrgIdList);
        if (!ObjectUtils.isEmpty((Object)orgInfoMap)) {
            Arrays.stream(dataEntities).forEach(dynamicObject -> {
                Map map;
                Object companyId;
                DynamicObject adminOrg = dynamicObject.getDynamicObject("aadminorg");
                long adminOrgId = HRDyObjectPropUtil.getId((DynamicObject)adminOrg);
                Map hrBu = (Map)hrBuMap.get(adminOrgId);
                if (hrBu != null) {
                    dynamicObject.set("hrbu_id", hrBu.get("hrBuId"));
                }
                dynamicObject.set("acompany_id", !ObjectUtils.isEmpty(companyId = (map = (Map)orgInfoMap.get(String.valueOf(adminOrgId))).get("belongcompany")) ? companyId : null);
            });
        }
    }

    private void setJobByStdPosition(DynamicObject dataEntity) {
        String positionType;
        switch (positionType = dataEntity.getString("apositiontype")) {
            case "0": {
                DynamicObject stdPositionObject = dataEntity.getDynamicObject("astdposition");
                long jobId = stdPositionObject.getLong("job.id");
                dataEntity.set("bjob_id", (Object)jobId);
                break;
            }
        }
    }

    private void setHisJobByPosition(DynamicObject[] dataEntities) {
        Map jobIdMap;
        Date effectDate;
        ArrayList<DynamicObject> aPositionDynamicObjectList = new ArrayList<DynamicObject>();
        HashMap<Long, List> queryHisJobParams = new HashMap<Long, List>();
        for (DynamicObject dataEntity : dataEntities) {
            String positionType = dataEntity.getString("apositiontype");
            if (!"1".equals(positionType)) continue;
            aPositionDynamicObjectList.add(dataEntity);
            effectDate = dataEntity.getDate("effectdate");
            LOGGER.info("dataEntity:{}, aposition= {}", (Object)dataEntity.getString("partperson.number"), (Object)dataEntity.getDynamicObject("aposition"));
            DynamicObject dynamicObject = dataEntity.getDynamicObject("aposition");
            long jobId = dynamicObject.getLong("job.id");
            if (jobId == 0L) continue;
            List dateList = queryHisJobParams.computeIfAbsent(jobId, list -> new ArrayList());
            dateList.add(effectDate);
        }
        if (queryHisJobParams.size() < 1) {
            return;
        }
        Map hisJobMap = IParttimeAdminOrgExternalService.getInstance().selectJobHisVersionInfo(queryHisJobParams);
        if (hisJobMap == null || hisJobMap.get("data") == null) {
            LOGGER.error("IHBJMHisVerService selectJobHisVersionInfo result exception");
            return;
        }
        List dataList = (List)hisJobMap.get("data");
        HashMap<Long, Map> jobBoIdMap = new HashMap<Long, Map>();
        for (Map map : dataList) {
            Long boid = (Long)map.get("boId");
            Date searchTime = (Date)map.get("searchTime");
            Long jobId = (Long)map.get("id");
            jobIdMap = jobBoIdMap.computeIfAbsent(boid, list -> new HashMap());
            jobIdMap.put(searchTime, jobId);
        }
        for (DynamicObject dynamicObject : aPositionDynamicObjectList) {
            effectDate = dynamicObject.getDate("effectdate");
            long jobBoId = dynamicObject.getLong("aposition.job.id");
            jobIdMap = (Map)jobBoIdMap.get(jobBoId);
            if (jobIdMap == null) continue;
            Long jobId = (Long)jobIdMap.get(effectDate);
            dynamicObject.set("bjob_id", (Object)jobId);
        }
    }

    private void setSuperiorByPosition(DynamicObject[] dataEntities) {
        StopWatch stopWatch = new StopWatch("setSuperiorByPosition");
        stopWatch.start();
        ArrayList<Long> roleIdList = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dynamicObject : dataEntities) {
            String positionType = dynamicObject.getString("apositiontype");
            if (!"1".equals(positionType)) continue;
            long roleId = dynamicObject.getLong("aposition.workrole.id");
            dynamicObject.set("aworkrole_id", (Object)roleId);
            roleIdList.add(roleId);
        }
        Map map = IParttimeBillService.getInstance().invokeGetSuperiorByRole(roleIdList);
        if (map.size() > 0) {
            for (DynamicObject dynamicObject : dataEntities) {
                long roleId;
                List personIdList;
                String positionType = dynamicObject.getString("apositiontype");
                if (!"1".equals(positionType) || (personIdList = (List)map.get(roleId = dynamicObject.getLong("aposition.workrole.id"))) == null || personIdList.size() <= 0) continue;
                this.setSuperior(dynamicObject, personIdList);
            }
        }
        stopWatch.stop();
        LOGGER.info("setSuperiorByPosition finish ,cost time :{}", (Object)stopWatch.getNanoTime());
    }

    private void setSuperiorByInvokeInf(DynamicObject[] dataEntities) {
        try {
            StopWatch stopWatch = new StopWatch("setSuperiorByInvokeInf");
            stopWatch.start();
            long[] personIdArr = ORM.create().genLongIds("hrpi_person", dataEntities.length);
            AtomicInteger i = new AtomicInteger();
            HashMap dynVsIdMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
            Arrays.stream(dataEntities).forEach(dataEntity -> dynVsIdMap.put(dataEntity, personIdArr[i.getAndIncrement()]));
            List infInParamList = DirectLeaderHelper.buildParamMap((DynamicObject[])dataEntities, (Map)dynVsIdMap);
            Map idVsLeaderListMap = IParttimeBillService.getInstance().getLeaderByRuleFromHRPI(infInParamList);
            if (!CollectionUtils.isEmpty((Map)idVsLeaderListMap)) {
                for (DynamicObject dataEntity2 : dataEntities) {
                    Long dummyId = (Long)dynVsIdMap.get(dataEntity2);
                    List leaderList = idVsLeaderListMap.getOrDefault(dummyId, Lists.newArrayListWithExpectedSize((int)0));
                    List<Long> personIdList = leaderList.stream().filter(map -> Objects.nonNull(map.get("person.id"))).map(map -> (Long)map.get("person.id")).collect(Collectors.toList());
                    this.setSuperior(dataEntity2, personIdList);
                }
            }
            stopWatch.stop();
            LOGGER.info("setSuperiorByInvokeInf finish ,cost time :{}", (Object)stopWatch.getNanoTime());
        }
        catch (Exception exception) {
            LOGGER.error("\u83b7\u53d6\u76f4\u63a5\u4e0a\u7ea7\u5931\u8d25\uff1a", (Throwable)exception);
        }
    }

    private void setSuperiorStdPosition(DynamicObject[] dataEntities) {
        String positionType;
        StopWatch stopWatch = new StopWatch("setSuperiorStdPosition");
        stopWatch.start();
        ArrayList<Long> orgIdList = new ArrayList<Long>(dataEntities.length);
        ArrayList<DynamicObject> positionDynamicObjectList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dynamicObject : dataEntities) {
            positionType = dynamicObject.getString("apositiontype");
            if (!"0".equals(positionType)) continue;
            long adminOrgId = dynamicObject.getLong("aadminorg.id");
            orgIdList.add(adminOrgId);
            positionDynamicObjectList.add(dynamicObject);
        }
        if (orgIdList.size() > 0) {
            List list = PersonExternalService.getInstance().invokeGetMainChargeInfoByOrg(orgIdList);
            if (list == null || list.size() < 1) {
                return;
            }
            HashMap<Long, List> superiorMap = new HashMap<Long, List>(list.size());
            for (Map map : list) {
                Long adminorg = (Long)map.get("adminorg");
                Long personId = (Long)map.get("person");
                List superiorList = superiorMap.computeIfAbsent(adminorg, value -> new ArrayList());
                superiorList.add(personId);
            }
            for (DynamicObject dynamicObject : positionDynamicObjectList) {
                positionType = dynamicObject.getString("apositiontype");
                if (!"0".equals(positionType)) continue;
                long adminOrgId = dynamicObject.getLong("aadminorg.id");
                List superiorList = (List)superiorMap.get(adminOrgId);
                this.setSuperior(dynamicObject, superiorList);
            }
        }
        stopWatch.stop();
        LOGGER.info("setSuperiorStdPosition finish ,cost time :{}", (Object)stopWatch.getNanoTime());
    }

    private void setSuperior(DynamicObject dyn, List<Long> superiorList) {
        if (HRCollUtil.isEmpty(superiorList)) {
            return;
        }
        DynamicObjectCollection collection = new DynamicObjectCollection();
        DynamicObjectType dynamicObjectType = dyn.getDynamicObjectCollection("asuperior").getDynamicObjectType();
        for (Long superiorId : superiorList) {
            DynamicObject superiorObject = new DynamicObject(dynamicObjectType);
            superiorObject.set("fbasedataid", (Object)superiorId);
            collection.add((Object)superiorObject);
        }
        if (collection.size() > 0) {
            dyn.set("asuperior", (Object)collection);
        }
    }

    private void setAppRemoveRel(DynamicObject dy) {
        String appDispatchNum = dy.getString("appdispatchnum");
        if (HRStringUtils.isBlank((CharSequence)appDispatchNum)) {
            return;
        }
        long employeeId = dy.getLong("partperson.employee_id");
        DynamicObject appointRemoveRelObj = ITransferBillApplicationService.getInstance().getAppointRemoveRelObj(appDispatchNum, employeeId);
        if (!HRObjectUtils.isEmpty((Object)appointRemoveRelObj)) {
            long appRemRelId = appointRemoveRelObj.getLong("id");
            dy.set("appremoverel_id", (Object)appRemRelId);
        }
    }
}

