/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.parttime;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.domain.parttime.PerChgBizUtils;
import kd.hr.hdm.business.domain.parttime.service.IParttimeBillService;
import kd.hr.hdm.business.repository.ParttimeApplyRepository;
import kd.hr.hdm.opplugin.parttime.PartBaseOp;

public class WFAuditPassOp
extends PartBaseOp {
    private DynamicObject[] effectBillArray;

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        super.onPreparePropertys(evt);
        List fieldKeys = evt.getFieldKeys();
        PartBaseOp.addCommonFields(fieldKeys);
        fieldKeys.add("apositiontype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        this.effectBillArray = IParttimeBillService.getInstance().auditPassEvent(bills);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (this.effectBillArray.length == 0) {
            return;
        }
        Set effectBillIds = Arrays.stream(this.effectBillArray).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] effectBills = ParttimeApplyRepository.getInstance().load(new QFilter("id", "in", effectBillIds).toArray());
        PerChgBizUtils.personChangeOfPart((DynamicObject[])effectBills);
    }
}

