/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.parttime.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hdm.business.domain.parttime.external.IParttimeAdminOrgExternalService;
import kd.hr.hdm.business.domain.parttime.validate.ParttimeValidateHelper;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.entity.DataValidateBuilder;
import kd.hr.hdm.common.parttime.enums.ValidateRangeEnum;
import kd.hr.hdm.common.util.HRServiceUtil;
import kd.hr.hdm.opplugin.parttime.validator.PartBillPChValidator;
import org.apache.commons.lang3.time.StopWatch;

public class PartBillPChImportValidator
extends PartBillPChValidator {
    @Override
    public void validate() {
        this.setApplySource();
        if (!"import".equals(applySource)) {
            return;
        }
        StopWatch stopWatch = new StopWatch("PartBillPChImportValidator validate start");
        stopWatch.start();
        ArrayList<DynamicObject> partBills = new ArrayList<DynamicObject>(this.dataEntities.length);
        HashMap<Long, ExtendedDataEntity> dataEntityMap = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject partBill = dataEntity.getDataEntity();
            partBills.add(partBill);
            dataEntityMap.put(partBill.getLong("id"), dataEntity);
        }
        List dataValidates = DataValidateBuilder.builderCollection(partBills);
        this.importValidate(dataValidates);
        ParttimeValidateHelper.listQuitValidate.accept(this.filterError(dataValidates));
        ParttimeValidateHelper.listCrossValidate.accept(this.filterError(dataValidates));
        this.showErrorMsg(dataValidates, dataEntityMap);
        stopWatch.stop();
        LOGGER.info("PartBillPChImportValidator validate finish ,cost time :{}", (Object)stopWatch.getNanoTime());
    }

    private void importValidate(List<DataValidate<DynamicObject>> dataValidates) {
        Map depempMap;
        List personIdList;
        Map ermanFileMap;
        Map<String, Map<String, Object>> ermanFileCardMap;
        List personNumbers = Arrays.stream(this.dataEntities).map(extendedDataEntity -> extendedDataEntity.getDataEntity().getDynamicObject("partperson").getString("person.number")).collect(Collectors.toList());
        Map dataMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIDepempService", (String)"queryDepEmpIdByEmpNumbers", (Object[])new Object[]{personNumbers});
        if (!((Boolean)dataMap.get("success")).booleanValue()) {
            dataValidates.forEach(dataValidate -> {
                String errorMsg = ResManager.loadKDString((String)"\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff1a%s\u3002", (String)"PartBillPChValidator_19", (String)"hr-hdm-opplugin", (Object[])new Object[]{dataMap.get("msg")});
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
            });
        }
        if ((ermanFileCardMap = this.getErmanFileCard(dataValidates, ermanFileMap = HRServiceUtil.listPrimaryErmanFile(personIdList = (depempMap = (Map)dataMap.get("data")).values().stream().map(depemp -> depemp.getLong("person.id")).collect(Collectors.toList())))).size() < 1) {
            return;
        }
        Map<String, DynamicObject> empEntrelMap = this.empEntrelMap(ermanFileMap);
        this.filterError(dataValidates).forEach(dataValidate -> {
            DynamicObject partPerson = ((DynamicObject)dataValidate.getData()).getDynamicObject("partperson");
            String personNumber = partPerson.getString("person.number");
            Map erManMap = (Map)ermanFileCardMap.get(personNumber);
            this.validateAffaction((DataValidate<DynamicObject>)dataValidate);
            this.validateEffectDate((DataValidate<DynamicObject>)dataValidate, ((DynamicObject)empEntrelMap.get(personNumber)).getDate("startdate"));
            this.validatePrimaryPosition((DataValidate<DynamicObject>)dataValidate, erManMap);
            this.validatePartpersonOrg((DataValidate<DynamicObject>)dataValidate);
        });
        this.validateAdminOrg(this.filterError(dataValidates), applySource);
        this.validateAadminorgPermssion(dataValidates);
        this.validatePositonJobStsPositionFirstbsed(this.filterError(dataValidates));
        ParttimeValidateHelper.listPartPersonCheckRepeat.accept(this.filterError(dataValidates));
        ParttimeValidateHelper.listLicenseCheck.accept(this.filterError(dataValidates));
        this.setPersonFieldsValue(this.filterError(dataValidates), ermanFileCardMap);
    }

    private Map<String, Map<String, Object>> getErmanFileCard(List<DataValidate<DynamicObject>> dataValidates, Map<Long, DynamicObject> primaryErmanFileMap) {
        if (primaryErmanFileMap == null || primaryErmanFileMap.size() < 1) {
            dataValidates.forEach(dataValidate -> {
                String errorMsg = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u4e0d\u7b26\u5408\u53d1\u8d77\u517c\u804c\u4e1a\u52a1\u7684\u6761\u4ef6\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"PartBillPChValidator_5", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
            });
            return new HashMap<String, Map<String, Object>>();
        }
        Map<String, DynamicObject> ermanFileMap = primaryErmanFileMap.values().stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (n, o) -> n));
        ArrayList ermanFileIdList = new ArrayList(primaryErmanFileMap.size());
        dataValidates.forEach(dataValidate -> {
            DynamicObject data = (DynamicObject)dataValidate.getData();
            String personNumber = data.getString("partperson.person.number");
            if (ermanFileMap.get(personNumber) == null) {
                String errorMsg = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u4e0d\u7b26\u5408\u53d1\u8d77\u517c\u804c\u4e1a\u52a1\u7684\u6761\u4ef6\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"PartBillPChValidator_5", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
            } else {
                data.set("partperson", ermanFileMap.get(personNumber));
                Object pkValue = ((DynamicObject)ermanFileMap.get(personNumber)).getPkValue();
                ermanFileIdList.add((Long)pkValue);
            }
        });
        List ermanFileList = HRServiceUtil.getErManFileByIds(ermanFileIdList);
        return ermanFileList.stream().collect(Collectors.toMap(erMan -> (String)erMan.get("number"), erMan -> erMan, (o, n) -> o));
    }

    private Map<String, DynamicObject> empEntrelMap(Map<Long, DynamicObject> ermanFileMap) {
        return ermanFileMap.values().stream().collect(Collectors.toMap(ermanFile -> ermanFile.getString("number"), ermanFile -> ermanFile.getDynamicObject("empentrel"), (n, o) -> n));
    }

    private void validateAffaction(DataValidate<DynamicObject> dataValidate) {
        String chgCategoryId = ((DynamicObject)dataValidate.getData()).getString("affaction.chgcategory_id");
        if (!"1070".equals(chgCategoryId)) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u517c\u804c\u64cd\u4f5c\u4e0d\u5c5e\u4e8e\u201c\u517c\u804c\u201d\u4eba\u4e8b\u4e1a\u52a1\u7c7b\u578b\u6216\u4f7f\u7528\u72b6\u6001\u4e0d\u4e3a\u201c\u53ef\u7528\u201d\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"PartBillPChValidator_14", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
            dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
        }
    }

    private void setPersonFieldsValue(List<DataValidate<DynamicObject>> dataValidates, Map<String, Map<String, Object>> erManFileMap) {
        dataValidates.forEach(dataValidate -> {
            DynamicObject data = (DynamicObject)dataValidate.getData();
            DynamicObject partPersonDy = data.getDynamicObject("partperson");
            String personNumber = partPersonDy.getString("person.number");
            Map erManFile = (Map)erManFileMap.get(personNumber);
            this.setFieldValue(data, erManFile);
        });
    }

    private void validateAadminorgPermssion(List<DataValidate<DynamicObject>> dataValidates) {
        List adminOrgList = IParttimeAdminOrgExternalService.getInstance().invokeGetAuthorizedAdminOrgSet("hdm_parttimeapplybill", "47150e89000000ac", "aadminorg");
        for (DataValidate<DynamicObject> dataValidate : dataValidates) {
            DynamicObject data = (DynamicObject)dataValidate.getData();
            DynamicObject adminOrgObject = data.getDynamicObject("aadminorg");
            long adminOrgId = HRDyObjectPropUtil.getId((DynamicObject)adminOrgObject);
            if (adminOrgList.size() <= 0 || adminOrgList.contains(adminOrgId)) continue;
            String errorMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8be5\u517c\u804c\u90e8\u95e8\u4e0d\u5728\u60a8\u7684\u6570\u636e\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"PartBillPChValidator_9", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
            dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
        }
    }
}

