/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.parttime.validator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.odc.service.CommonPermissionValidateService;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.VirtualOrgValidateUtil;
import kd.hr.hdm.business.domain.parttime.validate.ParttimeValidateHelper;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.entity.DataValidateBuilder;
import kd.hr.hdm.common.parttime.enums.ValidateRangeEnum;
import org.apache.commons.lang3.time.StopWatch;

public class PartBillPChValidator
extends AbstractValidator {
    protected static final Log LOGGER = LogFactory.getLog(PartBillPChValidator.class);
    protected static final String YYYY_MM_DD = "yyyy-MM-dd";
    protected static String applySource;

    protected void setApplySource() {
        Map variableMap = this.getOption().getVariables();
        if (variableMap != null) {
            String batchImport = (String)variableMap.get("batchimport");
            String source = (String)variableMap.get("source");
            applySource = !HRStringUtils.isEmpty((String)batchImport) && "true".equals(batchImport) ? "import" : ("hr_import".equals(source) ? "hr_import" : "form");
        }
    }

    public void validate() {
        this.setApplySource();
        if (this.dataEntities.length < 2 && "form".equals(applySource)) {
            return;
        }
        if ("hr_import".equals(applySource) || "import".equals(applySource)) {
            return;
        }
        StopWatch stopWatch = new StopWatch("PartBillPChValidator validate start");
        stopWatch.start();
        ArrayList<DynamicObject> partBills = new ArrayList<DynamicObject>(this.dataEntities.length);
        HashMap<Long, ExtendedDataEntity> dataEntityMap = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        String operateKey = this.getOperateKey();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject partBill = dataEntity.getDataEntity();
            String billStatus = partBill.getString("billstatus");
            if ("submit".equals(operateKey) && !HRStringUtils.equals((String)billStatus, (String)"A") && !HRStringUtils.equals((String)billStatus, (String)"G")) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"PartBillPChValidator_15", (String)"hr-hdm-opplugin", (Object[])new Object[0]));
                continue;
            }
            if ("submiteffect".equals(operateKey) && !HRStringUtils.equals((String)billStatus, (String)"A")) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5e76\u751f\u6548\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"PartBillPChValidator_16", (String)"hr-hdm-opplugin", (Object[])new Object[0]));
                continue;
            }
            partBills.add(partBill);
            dataEntityMap.put(partBill.getLong("id"), dataEntity);
        }
        List dataValidates = DataValidateBuilder.builderCollection(partBills);
        ParttimeValidateHelper.listErmanFileChangeValidate.accept(this.filterError(dataValidates));
        ParttimeValidateHelper.listQuitValidate.accept(this.filterError(dataValidates));
        ParttimeValidateHelper.listCrossValidate.accept(this.filterError(dataValidates));
        this.showErrorMsg(dataValidates, dataEntityMap);
        stopWatch.stop();
        LOGGER.info("PartBillPChValidator validate finish ,cost time :{}", (Object)stopWatch.getNanoTime());
    }

    protected void validatePositonJobStsPositionFirstbsed(List<DataValidate<DynamicObject>> dataValidates) {
        HashSet<Long> positionIds = new HashSet<Long>(dataValidates.size());
        HashSet<Long> jobIds = new HashSet<Long>(dataValidates.size());
        HashSet<Long> stdPositionIds = new HashSet<Long>(dataValidates.size());
        HashMap map = new HashMap();
        List importBills = dataValidates.stream().map(DataValidate::getData).collect(Collectors.toList());
        LOGGER.info("validatePositonJobStsPositionFirstbsed start new CommonPermissionValidateService, data size:{}", (Object)dataValidates.size());
        CommonPermissionValidateService validateService = new CommonPermissionValidateService(importBills, "hdm_parttimeapplybill");
        LOGGER.info("validatePositonJobStsPositionFirstbsed end new CommonPermissionValidateService");
        dataValidates.forEach(dataValidate -> {
            String apositiontype;
            DynamicObject data = (DynamicObject)dataValidate.getData();
            switch (apositiontype = data.getString("apositiontype")) {
                case "0": {
                    stdPositionIds.add(data.getDynamicObject("astdposition").getLong("boid"));
                    data.set("aposition", null);
                    data.set("bjob", null);
                    break;
                }
                case "1": {
                    positionIds.add(data.getDynamicObject("aposition").getLong("boid"));
                    data.set("astdposition", null);
                    data.set("bjob", null);
                    break;
                }
                case "2": {
                    jobIds.add(data.getDynamicObject("bjob").getLong("boid"));
                    data.set("aposition", null);
                    data.set("astdposition", null);
                    break;
                }
            }
            List dataValidateList = map.getOrDefault(apositiontype, new ArrayList());
            dataValidateList.add(dataValidate);
            map.put(apositiontype, dataValidateList);
            String errMsg = validateService.validate(data);
            if (!HRStringUtils.isBlank((CharSequence)errMsg)) {
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "AJOBSCMORGPERMISSION", errMsg);
            }
        });
        LOGGER.info("validatePositonJobStsPositionFirstbsed end CommonPermissionValidateService.validate");
        this.validateEffectiveDate(positionIds, "hbpm_positionhr", "aposition", map.getOrDefault("1", new ArrayList()));
        this.validateEffectiveDate(stdPositionIds, "hbpm_stposition", "astdposition", map.getOrDefault("0", new ArrayList()));
        this.validateEffectiveDate(jobIds, "hbjm_jobhr", "bjob", map.getOrDefault("2", new ArrayList()));
    }

    private void validateEffectiveDate(Set<Long> ids, String entityName, String field, List<DataValidate<DynamicObject>> dataValidates) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        DynamicObjectCollection dys = ORM.create().query(entityName, "id,boid,firstbsed", new QFilter("id", "in", ids).toArray());
        Map hisMap = dys.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("boid"), Function.identity()));
        dataValidates.forEach(dataValidate -> {
            DynamicObject data = (DynamicObject)dataValidate.getData();
            long boid = data.getLong(field + ".boid");
            Date firstbsed = ((DynamicObject)hisMap.get(boid)).getDate("firstbsed");
            Date effectDate = data.getDate("effectdate");
            if (firstbsed != null && firstbsed.after(effectDate)) {
                String errorMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5f53\u524d\u6240\u9009\u7684\u201c%1$s\u201d\u7684\u751f\u6548\u65e5\u671f\u665a\u4e8e\u201c%2$s\u201d\u3002", (String)"PartBillPChValidator_10", (String)"hr-hdm-opplugin", (Object[])new Object[]{data.getDynamicObject(field).getString("number"), HRDateTimeUtils.format((Date)effectDate, (String)YYYY_MM_DD)});
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
            }
        });
    }

    protected void validatePartpersonOrg(DataValidate<DynamicObject> dataValidate) {
        long org = ((DynamicObject)dataValidate.getData()).getLong("org.id");
        long partpersonOrg = ((DynamicObject)dataValidate.getData()).getLong("partperson.org.id");
        if (org != 0L && partpersonOrg != org) {
            dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", ResManager.loadKDString((String)"\u517c\u804c\u4eba\u5458\u4e0d\u5728\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u7684\u7ba1\u7406\u6743\u9650\u8303\u56f4\u5185\uff0c\u65e0\u6cd5\u53d1\u8d77\u517c\u804c\u7533\u8bf7\u3002", (String)"PartBillPChValidator_18", (String)"hr-hdm-opplugin", (Object[])new Object[0]));
        }
    }

    protected void setFieldValue(DynamicObject data, Map<String, Object> erManFile) {
        data.set("partperson_id", erManFile.get("id"));
        data.set("company_id", erManFile.get("company_id"));
        data.set("adminorg_id", erManFile.get("adminorg_id"));
        Object positionId = erManFile.get("position_id");
        Object stdPositionId = erManFile.get("stdposition_id");
        data.set("stdposition_id", stdPositionId);
        data.set("position_id", positionId);
        data.set("job_id", erManFile.get("job_id"));
        data.set("positiontype", erManFile.get("apositiontype"));
        data.set("primarycity_id", erManFile.get("location_id"));
        data.set("blaborreltype_id", erManFile.get("laborreltype_id"));
        data.set("blaborrelstatus_id", erManFile.get("laborrelstatus_id"));
        data.set("primaryhrbu_id", erManFile.get("org_id"));
        data.set("primaryaftadminorg_id", erManFile.get("affiliateadminorg_id"));
        data.set("primaryempgroup_id", erManFile.get("empgroup_id"));
        data.set("person_id", erManFile.get("person_id"));
        data.set("primaryemployee_id", erManFile.get("employee_id"));
        data.set("primarydepemp_id", erManFile.get("depemp_id"));
        data.set("primarycmpemp_id", erManFile.get("cmpemp_id"));
        data.set("pcmpemp_id", erManFile.get("managingscope_id"));
    }

    private Map<Long, Boolean> virtualAdminOrgValidate(List<DataValidate<DynamicObject>> dataValidates) {
        List orgIdList = dataValidates.stream().map(dataValidate -> ((DynamicObject)dataValidate.getData()).getLong("aadminorg.id")).collect(Collectors.toList());
        return VirtualOrgValidateUtil.validate(orgIdList);
    }

    protected void validateAdminOrg(List<DataValidate<DynamicObject>> dataValidates, String source) {
        Map<Long, Boolean> virtualAdminOrgResultMap = null;
        if (!"hr_import".equals(source)) {
            virtualAdminOrgResultMap = this.virtualAdminOrgValidate(dataValidates);
        }
        for (DataValidate<DynamicObject> dataValidate : dataValidates) {
            DynamicObject data = (DynamicObject)dataValidate.getData();
            DynamicObject adminOrgObject = data.getDynamicObject("aadminorg");
            long adminOrgId = HRDyObjectPropUtil.getId((DynamicObject)adminOrgObject);
            if (!"hr_import".equals(source) && virtualAdminOrgResultMap != null && virtualAdminOrgResultMap.containsKey(adminOrgId) && virtualAdminOrgResultMap.get(adminOrgId).booleanValue()) {
                String errorMsg = ResManager.loadKDString((String)"\u517c\u804c\u90e8\u95e8\u4e0d\u80fd\u4e3a\u865a\u62df\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PartBillPChValidator_17", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
                continue;
            }
            Date baseDate = adminOrgObject.getDate("firstbsed");
            Date effectDate = data.getDate("effectdate");
            if (baseDate != null && baseDate.after(effectDate)) {
                String errorMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5f53\u524d\u6240\u9009\u7684\u201c%1$s\u201d\u7684\u751f\u6548\u65e5\u671f\u665a\u4e8e\u201c%2$s\u201d\u3002", (String)"PartBillPChValidator_10", (String)"hr-hdm-opplugin", (Object[])new Object[]{adminOrgObject.getString("number"), HRDateTimeUtils.format((Date)effectDate, (String)YYYY_MM_DD)});
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
                continue;
            }
            String aPositionType = data.getString("apositiontype");
            if (!"1".equals(aPositionType)) continue;
            DynamicObject positionObject = data.getDynamicObject("aposition");
            long positionAdminOrgId = HRDyObjectPropUtil.getId((DynamicObject)positionObject.getDynamicObject("adminorg"));
            LOGGER.info("PartBillPChValidator positionAdminOrgId={}, adminOrgId={}", (Object)positionAdminOrgId, (Object)adminOrgId);
            if (positionAdminOrgId == adminOrgId) continue;
            String errorMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8be5\u517c\u804c\u5c97\u4f4d\u6240\u5c5e\u884c\u653f\u7ec4\u7ec7\u4e0e\u517c\u804c\u90e8\u95e8\u4e0d\u4e00\u81f4\u3002", (String)"PartBillPChValidator_7", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
            dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
        }
    }

    protected void validatePrimaryPosition(DataValidate<DynamicObject> dataValidate, Map<String, Object> erManFileMap) {
        String positionType;
        if (ValidateRangeEnum.VALIDATE_PASS != dataValidate.getValidatorContext().getRange()) {
            return;
        }
        DynamicObject data = (DynamicObject)dataValidate.getData();
        String aPositionType = data.getString("apositiontype");
        if (!aPositionType.equals(positionType = (String)erManFileMap.get("apositiontype"))) {
            return;
        }
        boolean isValid = false;
        long aAdminOrgId = data.getLong("aadminorg.boid");
        Object adminOrgId = erManFileMap.get("adminorg_id");
        String errorMsg = "";
        switch (aPositionType) {
            case "0": {
                long aStdPositionId = data.getLong("astdposition.boid");
                long stdPositionId = (Long)erManFileMap.get("stdposition_id");
                if (adminOrgId == null || (Long)adminOrgId != aAdminOrgId || aStdPositionId != stdPositionId) break;
                isValid = true;
                errorMsg = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5728\u6807\u51c6\u5c97\u4f4d\u201c%1$s\uff0c%2$s\u201d\u4e0a\u5df2\u5b58\u5728\u4efb\u804c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PartBillPChValidator_21", (String)"hr-hdm-opplugin", (Object[])new Object[]{data.getString("astdposition.number"), data.getString("astdposition.name")});
                break;
            }
            case "1": {
                boolean bl = isValid = data.getLong("aposition.boid") == ((Long)erManFileMap.get("position_id")).longValue();
                if (!isValid) break;
                errorMsg = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5728\u5c97\u4f4d\u201c%1$s\uff0c%2$s\u201d\u4e0a\u5df2\u5b58\u5728\u4efb\u804c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PartBillPChValidator_22", (String)"hr-hdm-opplugin", (Object[])new Object[]{data.getString("aposition.number"), data.getString("aposition.name")});
                break;
            }
            case "2": {
                long bJobId = data.getLong("bjob.boid");
                long jobId = (Long)erManFileMap.get("job_id");
                if (adminOrgId == null || (Long)adminOrgId != aAdminOrgId || bJobId != jobId) break;
                isValid = true;
                errorMsg = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5728\u804c\u4f4d\u201c%1$s\uff0c%2$s\u201d\u4e0a\u5df2\u5b58\u5728\u4efb\u804c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PartBillPChValidator_23", (String)"hr-hdm-opplugin", (Object[])new Object[]{data.getString("bjob.number"), data.getString("bjob.name")});
                break;
            }
        }
        if (isValid && StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
        }
    }

    protected void validateEffectDate(DataValidate<DynamicObject> dataValidate, Date startDate) {
        if (ValidateRangeEnum.VALIDATE_PASS != dataValidate.getValidatorContext().getRange()) {
            return;
        }
        DynamicObject data = (DynamicObject)dataValidate.getData();
        Date effectDate = data.getDate("effectdate");
        if (HRDateTimeUtils.dayBefore((Date)effectDate, (Date)startDate)) {
            String errorMsg = ResManager.loadKDString((String)"\u517c\u804c\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5165\u804c\u65e5\u671f\u201c{0}\u201d\u3002", (String)"PartBillPChValidator_11", (String)"hr-hdm-opplugin", (Object[])new Object[]{HRDateTimeUtils.format((Date)startDate, (String)YYYY_MM_DD)});
            dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
        }
    }

    protected void showErrorMsg(List<DataValidate<DynamicObject>> dataValidates, Map<Long, ExtendedDataEntity> dataEntityMap) {
        dataValidates.forEach(dataValidate -> {
            ValidateRangeEnum range = dataValidate.getValidatorContext().getRange();
            String errMsg = dataValidate.getValidatorContext().map2String();
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)dataEntityMap.get(((DynamicObject)dataValidate.getData()).getLong("id"));
            switch (range) {
                case VALIDATE_WARN: 
                case VALIDATE_CONFIRM: {
                    this.addWarningMessage(dataEntity, errMsg);
                    break;
                }
                case VALIDATE_ERROR: {
                    LOGGER.info("errMsg = {}", (Object)errMsg);
                    this.addFatalErrorMessage(dataEntity, errMsg);
                    break;
                }
            }
        });
    }

    protected List<DataValidate<DynamicObject>> filterError(List<DataValidate<DynamicObject>> dataValidates) {
        return dataValidates.stream().filter(dataValidate -> ValidateRangeEnum.VALIDATE_PASS == dataValidate.getValidatorContext().getRange()).collect(Collectors.toList());
    }
}

