/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.reg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.OperateResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hdm.business.reg.domain.service.workflow.IRegWorkFlowService;
import kd.hr.hdm.opplugin.reg.validator.RegRemindConfirmDelayValidator;

public class RegRemindConfirmDelayOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        args.getFieldKeys().add("person");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        Map variables = this.getOption().getVariables();
        String remindReason = (String)variables.get("remindreason");
        if (HRStringUtils.isEmpty((String)remindReason)) {
            return;
        }
        args.addValidator((AbstractValidator)new RegRemindConfirmDelayValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        BatchOperateResult dataEntities = args.getDataEntities();
        ArrayList<BatchOperateResult> successDataEntities = new ArrayList<BatchOperateResult>(((DynamicObject[])dataEntities).length);
        Map variables = this.getOption().getVariables();
        String remindReason = (String)variables.get("remindreason");
        if (HRStringUtils.isEmpty((String)remindReason)) {
            return;
        }
        List businessKeys = Arrays.stream(dataEntities).map(dy -> dy.getString("id")).collect(Collectors.toList());
        Map processInstanceIdMap = IRegWorkFlowService.getInstance().getProcessInstanceIdsByBusinessKeys(businessKeys);
        int size = processInstanceIdMap.size();
        HashMap<String, OperateResult> remindResultMap = new HashMap<String, OperateResult>(size);
        String validateMsg = null;
        if (size != 0) {
            BatchOperateResult batchOperateResult = WorkflowServiceHelper.taskReminders((Long[])processInstanceIdMap.values().toArray(new Long[0]), (ILocaleString)new LocaleString(remindReason));
            validateMsg = batchOperateResult.getValidateMsg();
            List operateResults = batchOperateResult.getOperateResults();
            if (operateResults != null && operateResults.size() > 0) {
                for (OperateResult operateResult : operateResults) {
                    String[] operateMsgSplit;
                    String operateMsg = operateResult.getOperateMsg();
                    if (HRStringUtils.isEmpty((String)operateMsg) || (operateMsgSplit = operateMsg.split("\uff1a")).length <= 1) continue;
                    remindResultMap.put(operateMsgSplit[0], operateResult);
                }
            }
        }
        for (BatchOperateResult dataEntity : dataEntities) {
            String businessKey = dataEntity.getString("id");
            String billNo = dataEntity.getString("billno");
            String personNumber = dataEntity.getString("person.number");
            String message = null;
            if (HRStringUtils.isNotEmpty((String)validateMsg)) {
                message = ((BatchOperateResult)dataEntities).length == 1 ? validateMsg : String.format("%s\uff1a%s", personNumber, validateMsg);
            } else if (!remindResultMap.isEmpty()) {
                OperateResult operateResult = (OperateResult)remindResultMap.get(billNo);
                if (operateResult != null) {
                    String operateStatus = operateResult.getOperateStatus();
                    if (!HRStringUtils.equals((String)operateStatus, (String)"success")) {
                        message = operateResult.getOperateMsg();
                        message = message.replaceAll(billNo, personNumber);
                    }
                } else {
                    message = String.format("%s\uff1a%s", personNumber, ResManager.loadKDString((String)"\u6d41\u7a0b\u5f02\u5e38", (String)"RegRemindConfirmDelayOp_0", (String)"hr-hdm-opplugin", (Object[])new Object[0]));
                }
            } else {
                message = String.format("%s\uff1a%s", personNumber, ResManager.loadKDString((String)"\u6d41\u7a0b\u5f02\u5e38", (String)"RegRemindConfirmDelayOp_0", (String)"hr-hdm-opplugin", (Object[])new Object[0]));
            }
            if (HRStringUtils.isEmpty((String)message)) {
                successDataEntities.add(dataEntity);
                continue;
            }
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo("remindconfirmdelay", ErrorLevel.FatalError, (Object)businessKey);
            operateErrorInfo.setMessage(message);
            this.getOperationResult().addErrorInfo(operateErrorInfo);
        }
        boolean isSuccess = successDataEntities.size() == ((BatchOperateResult)dataEntities).length;
        this.getOperationResult().setSuccess(isSuccess);
        args.setDataEntities(successDataEntities.toArray(new DynamicObject[0]));
        args.setCancelOperation(!isSuccess);
    }
}

