/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.reg.validator;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hdm.business.reg.domain.service.bill.IBatchRegBillService;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;

public class BatchRegTerminateValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ExtendedDataEntity dataEntity = dataEntities[0];
        this.terminationValidate(dataEntity);
    }

    private void terminationValidate(ExtendedDataEntity dataEntity) {
        DynamicObject batchBillDy = IBatchRegBillService.getInstance().queryOne("billstatus,entryentity.id,entryentity.regstatus,entryentity.syncstatus", dataEntity.getDataEntity().getLong("id"));
        if (ObjectUtils.isEmpty((Object)batchBillDy)) {
            return;
        }
        String billStatus = batchBillDy.getString("billstatus");
        String message = "";
        if (RegBillStatusEnum.TEMPSTORAGE.getCode().equals(billStatus)) {
            message = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\uff0c\u65e0\u9700\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"BatchRegTerminateValidator_1", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
        } else if (RegBillStatusEnum.APPROVEREJECTED.getCode().equals(billStatus)) {
            message = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5ba1\u6279\u4e0d\u901a\u8fc7\u201d\uff0c\u4e0d\u53ef\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"BatchRegTerminateValidator_2", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
        } else if (RegBillStatusEnum.ABANDONED.getCode().equals(billStatus)) {
            message = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5e9f\u5f03\u201d\uff0c\u4e0d\u53ef\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"BatchRegTerminateValidator_3", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
        } else if (RegBillStatusEnum.APPROVEPASSED.getCode().equals(billStatus)) {
            DynamicObjectCollection entryDyCollection = batchBillDy.getDynamicObjectCollection("entryentity");
            if (ObjectUtils.isEmpty((Collection)entryDyCollection)) {
                return;
            }
            List listSync = entryDyCollection.stream().filter(o -> RegBusinessStatusEnum.REG_PENDINGTOBEVALID.getCode().equals(o.getString("regstatus")) && "-1".equals(o.getString("syncstatus"))).collect(Collectors.toList());
            List listReg = entryDyCollection.stream().filter(o -> RegBusinessStatusEnum.REG_PENDINGTOBEVALID.getCode().equals(o.getString("regstatus"))).collect(Collectors.toList());
            if (listSync.size() > 0) {
                message = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u5355\u636e\u4e2d\u6709\u4eba\u5458\u7684\u8f6c\u6b63\u72b6\u6001\u4e3a\u201c\u8f6c\u6b63\u5f85\u751f\u6548\u201d\u4e14\u540c\u6b65\u4eba\u5458\u72b6\u6001\u4e3a\u201c\u540c\u6b65\u4e2d\u201d\uff0c\u4e0d\u53ef\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"BatchRegTerminateValidator_4", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
            }
            if (listReg.size() == 0) {
                message = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5ba1\u6279\u901a\u8fc7\u201d\uff0c\u4e14\u5f85\u8f6c\u6b63\u4eba\u5458\u7684\u8f6c\u6b63\u72b6\u6001\u5747\u4e3a\u201c\u5df2\u8f6c\u6b63\u201d\u6216\u201c\u4e0d\u4e88\u8f6c\u6b63\u201d\uff0c\u4e0d\u53ef\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"BatchRegTerminateValidator_5", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
            }
        }
        if (!ObjectUtils.isEmpty((Object)message)) {
            this.addFatalErrorMessage(dataEntity, message);
        }
    }
}

