/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.reg.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.repository.RegProcessRepository;
import kd.hr.hdm.common.reg.util.RegStatusUtil;
import org.apache.commons.lang3.StringUtils;

public class RegAskRemindValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.setAddBillNoForContent(false);
        List employeeIds = Arrays.stream(dataEntities).map(dy -> dy.getDataEntity().getLong("bemployee")).collect(Collectors.toList());
        Map regProcessArray = RegProcessRepository.getRepository().queryByEmployeeIds(employeeIds, new String[]{"person", "regstatus", "bemployee"});
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            DynamicObject regAskDetail = dataEntity.getDataEntity();
            Long employeeId = regAskDetail.getLong("bemployee");
            String personNumber = regAskDetail.getString("person.number");
            String personName = regAskDetail.getString("person.name");
            String askPersonName = regAskDetail.getString("askperson.name");
            String askPersonNumber = regAskDetail.getString("askperson.number");
            DynamicObject regProcess = (DynamicObject)regProcessArray.get(employeeId);
            String regStatus = regProcess.getString("regstatus");
            String opinion = regAskDetail.getString("opinion");
            String message = null;
            if (HRStringUtils.equals((String)regStatus, (String)"1040") || HRStringUtils.equals((String)regStatus, (String)"1050")) {
                String regStatusDesc = RegStatusUtil.getRegStatusDesc((String)regStatus);
                message = ResManager.loadKDString((String)"\u5458\u5de5\u5f53\u524d\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c%s\u201d\uff0c\u95ee\u8be2\u7ec8\u6b62\uff0c\u65e0\u6cd5\u6267\u884c\u50ac\u529e\u3002", (String)"RegAskRemindValidator_0", (String)"hr-hdm-opplugin", (Object[])new Object[]{regStatusDesc});
            } else if (StringUtils.isNotEmpty((CharSequence)opinion)) {
                message = ResManager.loadKDString((String)"\u5f53\u524d\u95ee\u8be2\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u65e0\u6cd5\u6267\u884c\u201c\u50ac\u529e\u201d\u64cd\u4f5c\u3002", (String)"RegAskRemindValidator_1", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
            }
            if (HRStringUtils.isNotEmpty(message)) {
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, dataEntities.length == 1 ? message : String.format(ResManager.loadKDString((String)"\u201c%1$s\uff0c%2$s\u201d\u7684\u201c%3$s\uff0c%4$s\u201d\u95ee\u8be2\uff1a%5$s\u3002", (String)"RegAskRemindValidator_2", (String)"hr-hdm-opplugin", (Object[])new Object[0]), personName, personNumber, askPersonName, askPersonNumber, message));
            }
        });
    }
}

