/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.transfer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hdm.business.domain.parttime.service.IParttimeBillService;
import kd.hr.hdm.common.parttime.enums.PosTypeEnum;
import kd.hr.hdm.common.transfer.enums.TransferStatusEnum;
import org.apache.commons.lang3.time.StopWatch;

public class BatchTransferSaveOp
extends HRDataBaseOp {
    private static String TAG_NOT_MAJOR = "0";
    private static String TAG_MAJOR = "1";
    private static String TAG_COMMON = "2";
    private static final Log LOGGER = LogFactory.getLog(BatchTransferSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("entryentity.bjob");
        fieldKeys.add("entryentity.aposition");
        fieldKeys.add("entryentity.astdposition");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        DynamicObject batchTransferBill = dataEntities[0];
        if (batchTransferBill == null) {
            return;
        }
        DynamicObjectCollection transferBillCollection = batchTransferBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject transferBill : transferBillCollection) {
            transferBill.set("entryauditstatus", (Object)"A");
            transferBill.set("entrybillstatus", (Object)"A");
            transferBill.set("aempgroup", (Object)1010L);
            transferBill.set("transferstatus", (Object)TransferStatusEnum.TO_TRANSFER.getStatus());
            transferBill.set("transfereffectstatus", (Object)"0");
            transferBill.set("amainorg", batchTransferBill.get("org"));
            transferBill.set("originator", (Object)"0");
            transferBill.set("transferstage", (Object)"0");
        }
        Object[] regBills = new DynamicObject[transferBillCollection.size()];
        transferBillCollection.toArray(regBills);
        this.setSuperiorByInvokeInf((DynamicObject[])regBills);
    }

    private void setSuperiorByInvokeInf(DynamicObject[] dataEntities) {
        try {
            StopWatch stopWatch = new StopWatch("setSuperiorByInvokeInf");
            stopWatch.start();
            long[] personIdArr = ORM.create().genLongIds("hrpi_person", dataEntities.length);
            AtomicInteger i = new AtomicInteger();
            HashMap dynVsIdMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
            Arrays.stream(dataEntities).forEach(dataEntity -> dynVsIdMap.put(dataEntity, personIdArr[i.getAndIncrement()]));
            List<Map<String, Object>> infInParamList = BatchTransferSaveOp.buildParamMap(dataEntities, dynVsIdMap);
            Map idVsLeaderListMap = IParttimeBillService.getInstance().getLeaderByRuleFromHRPI(infInParamList);
            if (!CollectionUtils.isEmpty((Map)idVsLeaderListMap)) {
                for (DynamicObject dataEntity2 : dataEntities) {
                    Long dummyId = (Long)dynVsIdMap.get(dataEntity2);
                    List leaderList = idVsLeaderListMap.getOrDefault(dummyId, Lists.newArrayListWithExpectedSize((int)0));
                    List personIdList = leaderList.stream().filter(map -> Objects.nonNull(map.get("person.id"))).map(map -> (Long)map.get("person.id")).collect(Collectors.toList());
                    this.setSuperior(dataEntity2, personIdList);
                }
            }
            stopWatch.stop();
            LOGGER.info("setSuperiorByPosition finish ,cost time :{}", (Object)stopWatch.getNanoTime());
        }
        catch (Exception exception) {
            LOGGER.error("\u83b7\u53d6\u76f4\u63a5\u4e0a\u7ea7\u5931\u8d25\uff1a", (Throwable)exception);
        }
    }

    private void setSuperior(DynamicObject dyn, List superiorList) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        DynamicObjectType dynamicObjectType = dyn.getDynamicObjectCollection("arealitysuperior").getDynamicObjectType();
        for (Object superiorId : superiorList) {
            DynamicObject superiorObject = new DynamicObject(dynamicObjectType);
            superiorObject.set("fbasedataid_id", superiorId);
            collection.add((Object)superiorObject);
        }
        if (collection.size() > 0) {
            dyn.set("arealitysuperior", (Object)collection);
        }
    }

    public static List<Map<String, Object>> buildParamMap(DynamicObject[] dataEntityArr, Map<DynamicObject, Long> dynVsIdMap) {
        ArrayList paramList = Lists.newArrayListWithExpectedSize((int)1);
        for (DynamicObject dataEntity : dataEntityArr) {
            DynamicObject roleDyn;
            DynamicObject positionDy;
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
            paramMap.put("person", dynVsIdMap.get(dataEntity));
            paramMap.put("tag", BatchTransferSaveOp.judgePersonTagForSuperior(dataEntity));
            String aPositionType = dataEntity.getString("postpattern");
            paramMap.put("apositiontype", aPositionType);
            DynamicObject adminOrgDyn = dataEntity.getDynamicObject("aorg");
            if (Objects.nonNull(adminOrgDyn)) {
                paramMap.put("org", adminOrgDyn.getLong("id"));
            } else {
                LOGGER.info("DirectLeaderHelper.buildParamMap orgid is null");
                paramMap.put("org", 0L);
            }
            if (HRStringUtils.equals((String)aPositionType, (String)PosTypeEnum.POS.getCode()) && (positionDy = dataEntity.getDynamicObject("aposition")) != null && Objects.nonNull(roleDyn = positionDy.getDynamicObject("workrole"))) {
                paramMap.put("role", roleDyn.getLong("id"));
            }
            paramMap.put("querydate", new Date());
            paramList.add(paramMap);
        }
        return paramList;
    }

    public static String judgePersonTagForSuperior(DynamicObject dyn) {
        String aPositionType = dyn.getString("postpattern");
        if (HRStringUtils.equals((String)aPositionType, (String)PosTypeEnum.POS.getCode())) {
            DynamicObject positionDyn = dyn.getDynamicObject("aposition");
            if (Objects.nonNull(positionDyn)) {
                String isLeader = positionDyn.getString("isleader");
                if (HRStringUtils.equals((String)isLeader, (String)"1")) {
                    return TAG_MAJOR;
                }
                return TAG_COMMON;
            }
        } else {
            return TAG_COMMON;
        }
        return "";
    }
}

