/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.transfer;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hdm.business.domain.transfer.executor.MixOperationExecutor;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;

public class TransferInSubmitOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(TransferInSubmitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.add("bdepemp");
        fieldKeys.add("bcompany");
        fieldKeys.add("borg");
        fieldKeys.add("originator");
        fieldKeys.add("transferstatus");
        fieldKeys.add("transferstage");
        fieldKeys.add("transferinstatus");
        fieldKeys.add("transferoutstatus");
        fieldKeys.add("workflowflag");
        fieldKeys.add("aplancompany");
        fieldKeys.add("aplanorg");
        fieldKeys.add("acompany");
        fieldKeys.add("aorg");
        fieldKeys.add("arealityorg");
        fieldKeys.add("arealitycompany");
        fieldKeys.add("baffiliateorg");
        fieldKeys.add("aaffiliateorg");
        fieldKeys.add("person");
        fieldKeys.add("arealityposition");
        fieldKeys.add("arealityjob");
        fieldKeys.add("laborreltype");
        fieldKeys.add("bjob");
        fieldKeys.add("bposition");
        fieldKeys.add("borg");
        fieldKeys.add("realitydate");
        fieldKeys.add("bmainorg");
        fieldKeys.add("ermanfile");
        fieldKeys.addAll(TransferStaffService.getInstance().getMapFieldSet());
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        List<DynamicObject> secondSubmit;
        DynamicObject[] dataEntities = e.getDataEntities();
        MixOperationExecutor mixOperationExecutor = new MixOperationExecutor("workflowflag", "submitop");
        mixOperationExecutor.execute(Arrays.asList(dataEntities)).apply("in");
        Arrays.stream(dataEntities).forEach(dataEntity -> ITransferBillService.getInstance().setBMainOrg(dataEntity));
        Map<String, List<DynamicObject>> collect = Stream.of(dataEntities).collect(Collectors.groupingBy(temp -> temp.getString("originator")));
        List<DynamicObject> firstSubmit = collect.get("2");
        if (firstSubmit != null) {
            TransferStaffService.getInstance().occupyStaff(firstSubmit, false);
        }
        if ((secondSubmit = collect.get("1")) != null) {
            TransferStaffService.getInstance().occupyStaff(secondSubmit, true);
        }
    }
}

