/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.transfer.mytransfer;

import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPersonChangeService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.common.transfer.enums.PersonChangeOperateTypeEnum;
import kd.hr.hdm.common.transfer.util.TransferPageHelperUtil;
import kd.hr.hdm.opplugin.transfer.mytransfer.MyTransferWfBaseOp;

public class MyTransferAgreeOp
extends MyTransferWfBaseOp {
    private static final Log LOGGER = LogFactory.getLog(MyTransferAgreeOp.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs arg) {
        DynamicObject[] dataEntities = arg.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        dataEntity.set("auditstatus", (Object)"D");
        dataEntity.set("billstatus", (Object)"D");
        ITransferBillService.getInstance().update(Collections.singletonList(dataEntity));
        long billId = dataEntity.getLong("id");
        DynamicObject data = this.getData(billId);
        try (TXHandle txHandle = TX.requiresNew();){
            LOGGER.info("start mytransfer copystaff and sendPersonChangeNotice");
            if (0L == data.getLong("aorg.id")) {
                TransferStaffService.getInstance().occupyStaff(Collections.singletonList(dataEntity), false);
            } else {
                TransferStaffService.getInstance().occupyStaff(Collections.singletonList(dataEntity), true);
            }
            if (data.getDate("transferdate") == null) {
                ITransferPersonChangeService.getInstance().excuteBatchPersonChangeNotice(Collections.singletonList(dataEntity), PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_CREATE);
            } else {
                ITransferPersonChangeService.getInstance().excuteBatchPersonChangeNotice(Collections.singletonList(dataEntity), PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_MODIFY);
            }
        }
        catch (KDBizException e) {
            LOGGER.error("mytransfer copystaff or sendPersonChangeNotice error", (Throwable)e);
        }
    }

    private DynamicObject getData(long datas) {
        return ITransferBillService.getInstance().queryOne(TransferPageHelperUtil.QUERYFIELD, datas);
    }
}

