/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.transfer.validator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParam;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParamMap;
import kd.hr.hbp.common.model.org.staff.StaffResponse;
import kd.hr.hdm.business.domain.transfer.entity.TransferStaffVO;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.IBatchTransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.common.transfer.enums.TransferStaffEnum;

public class BatchTransferApprovalAgreeValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            this.staffOccupyValidate(dataEntity);
        }
    }

    private void staffOccupyValidate(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection entryentity = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
        DynamicObject[] oldTransferBillList = TransferBillRepository.getInstance().query("arealityorg,realitydate,arealityjob,arealityposition", entryentity.stream().map(transferBill -> transferBill.getLong("id")).collect(Collectors.toList()));
        Map oldTransferBillMap = Arrays.stream(oldTransferBillList).collect(Collectors.toMap(transferBill -> transferBill.getLong("id"), Function.identity()));
        ArrayList createStaffTransferBill = Lists.newArrayListWithExpectedSize((int)entryentity.getRowCount());
        ArrayList updateStaffTransferBill = Lists.newArrayListWithExpectedSize((int)entryentity.getRowCount());
        for (DynamicObject transferBill2 : entryentity) {
            DynamicObject oldTransferBill = (DynamicObject)oldTransferBillMap.get(transferBill2.getLong("id"));
            if (oldTransferBill == null) {
                createStaffTransferBill.add(transferBill2);
                continue;
            }
            if (!IBatchTransferValidatorService.getInstance().isMvpFieldChanged(transferBill2, oldTransferBill)) continue;
            updateStaffTransferBill.add(transferBill2);
        }
        StaffResponse staffUseInfoUpdateDetail = TransferStaffService.getInstance().getStaffUseInfoDetail(TransferStaffEnum.UPDATE.name(), (List)updateStaffTransferBill);
        StaffResponse staffUseInfoNewDetail = TransferStaffService.getInstance().getStaffUseInfoDetail(TransferStaffEnum.NEW.name(), (List)updateStaffTransferBill);
        Tuple<Boolean, String> staffAllowNewValInfo = this.isStaffAllow((StaffResponse<StaffQueryOutParamMap>)staffUseInfoNewDetail, createStaffTransferBill);
        Tuple<Boolean, String> staffAllowUpdateValInfo = this.isStaffAllow((StaffResponse<StaffQueryOutParamMap>)staffUseInfoUpdateDetail, updateStaffTransferBill);
        if (!((Boolean)staffAllowNewValInfo.item1).booleanValue()) {
            this.addFatalErrorMessage(dataEntity, (String)staffAllowNewValInfo.item2);
            return;
        }
        if (!((Boolean)staffAllowUpdateValInfo.item1).booleanValue()) {
            this.addFatalErrorMessage(dataEntity, (String)staffAllowUpdateValInfo.item2);
        }
    }

    private Tuple<Boolean, String> isStaffAllow(StaffResponse<StaffQueryOutParamMap> staffUseInfoDetail, List<DynamicObject> transferBillList) {
        if (staffUseInfoDetail == null) {
            return Tuple.create((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u7f16\u5236\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TransferApprovalAgreeValidator_0", (String)"hr-hdm-opplugin", (Object[])new Object[0]));
        }
        StaffQueryOutParamMap data = (StaffQueryOutParamMap)staffUseInfoDetail.getData();
        for (DynamicObject transferBill : transferBillList) {
            StaffQueryOutParam staffQueryOutParam = (StaffQueryOutParam)data.get((Object)TransferStaffVO.getQueryStaffKey((DynamicObject)transferBill));
            if (staffQueryOutParam == null) {
                return Tuple.create((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u8c03\u7528\u7f16\u5236\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TransferApprovalAgreeValidator_1", (String)"hr-hdm-opplugin", (Object[])new Object[0]));
            }
            boolean allow = staffQueryOutParam.isAllow();
            if (allow) continue;
            return Tuple.create((Object)Boolean.FALSE, (Object)staffQueryOutParam.getReasonList().toString());
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)"");
    }
}

