/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.transfer.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.domain.transfer.service.ITransferSubmitValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.external.DevParamConfigExternalService;

public class MyTransferAgreeValidator
extends AbstractValidator {
    public void validate() {
        boolean validateFalse;
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        DynamicObject transferbil = dataEntities[0].getDataEntity();
        String errorMsg = this.validateMustIntput(transferbil);
        if (errorMsg != null) {
            this.addFatalErrorMessage(this.dataEntities[0], errorMsg);
            return;
        }
        String validateResult = this.validateCrossAndInAffaction(transferbil);
        if (validateResult != null) {
            this.addFatalErrorMessage(this.dataEntities[0], validateResult);
            return;
        }
        List<DynamicObject> dynamicObjects = Collections.singletonList(transferbil);
        List dataDivs = Collections.singleton(transferbil).stream().map(temp -> new DataDiv(temp, new ValidateContext())).collect(Collectors.toList());
        ITransferSubmitValidatorService transferValidatorService = ITransferSubmitValidatorService.getInstance();
        transferValidatorService.checkRepeat().test(dataDivs);
        transferValidatorService.checkRepeatInDb(dynamicObjects).test(dataDivs);
        List bemployeeIds = dataDivs.stream().map(temp -> temp.getDynamicObject().get("bemployee.id")).collect(Collectors.toList());
        ITransferValidatorService.getInstance().validateExteranlProfileAndChgRecord(bemployeeIds).test(dataDivs);
        transferValidatorService.batchCheckRepeatInPerChg().test(dataDivs);
        transferValidatorService.getStaffInfo().test(dataDivs);
        transferValidatorService.validateSubmitPostpatternEffctDate("1", "", "hdm_my_transfer_org_createdate_validate", "hdm_my_transfer_company_createdate_validate").test(dataDivs);
        ITransferValidatorService.getInstance().validateBaseDataEnable(ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"TransferValidatorServiceImpl_4", (String)"hr-hdm-business", (Object[])new Object[0])).test(dataDivs);
        boolean bl = validateFalse = ((DataDiv)dataDivs.get(0)).getValidatorContext().getValidateResult().size() > 0;
        if (validateFalse) {
            this.addFatalErrorMessage(this.dataEntities[0], ((DataDiv)dataDivs.get(0)).getValidatorContext().map2String());
        }
    }

    private String validateCrossAndInAffaction(DynamicObject transferbill) {
        DynamicObject comTarget;
        Long affacionId = transferbill.getLong("affaction_id");
        DynamicObject comSource = transferbill.getDynamicObject("bcompany");
        boolean comRemained = Objects.equals(comSource, comTarget = transferbill.getDynamicObject("acompany"));
        if (comRemained && (affacionId == 1060L || affacionId == 201060L)) {
            return ResManager.loadKDString((String)"\u8de8\u516c\u53f8\u8c03\u52a8\u65f6\uff0c\u8c03\u5165\u516c\u53f8\u5e94\u4e0e\u8c03\u51fa\u516c\u53f8\u4e0d\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8c03\u5165\u90e8\u95e8\u3002", (String)"TransferPropertyChangeValidatorServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]);
        }
        if (!(comRemained || affacionId != 1050L && affacionId != 201050L)) {
            return ResManager.loadKDString((String)"\u516c\u53f8\u5185\u8c03\u52a8\u65f6\uff0c\u8c03\u5165\u516c\u53f8\u5e94\u4e0e\u8c03\u51fa\u516c\u53f8\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8c03\u5165\u90e8\u95e8\u3002", (String)"TransferBillPropChangedEdit_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private String validateMustIntput(DynamicObject transferbil) {
        DynamicObject[] devConfigList;
        ArrayList<String> nullFieldList = new ArrayList<String>(16);
        Object affaction = transferbil.get("affaction");
        Object reason = transferbil.get("transferreason");
        Object company = transferbil.get("acompany");
        Object org = transferbil.get("aorg");
        Object amanagescope = transferbil.get("amanagescope");
        Object abaselocation = transferbil.get("abaselocation");
        Object aposition = transferbil.get("aposition");
        Object astposition = transferbil.get("astposition");
        Object ajob = transferbil.get("ajob");
        Object plandate = transferbil.get("plandate");
        String postpattern = transferbil.getString("postpattern");
        if (affaction == null) {
            nullFieldList.add("affaction");
        }
        if (reason == null) {
            nullFieldList.add("transferreason");
        }
        if (company == null) {
            nullFieldList.add("acompany");
        }
        if (org == null) {
            nullFieldList.add("aorg");
        }
        if (amanagescope == null) {
            nullFieldList.add("amanagescope");
        }
        if (abaselocation == null) {
            nullFieldList.add("abaselocation");
        }
        if (plandate == null) {
            nullFieldList.add("plandate");
        }
        String selectFields = "businesskey,app,businessvalue,description";
        block10: for (DynamicObject dynamicObject : devConfigList = DevParamConfigExternalService.getInstance().listDevParamConfigByAppNumber(selectFields, "hdm")) {
            String businessKey = dynamicObject.getString("businesskey");
            Boolean requireNotNull = Boolean.parseBoolean(dynamicObject.getString("businessvalue"));
            switch (businessKey) {
                case "hdm_my_transfer_require_aposition": {
                    if (!requireNotNull.booleanValue() || aposition != null || !"1".equals(postpattern)) continue block10;
                    nullFieldList.add("aposition");
                    continue block10;
                }
                case "hdm_my_transfer_require_astposition": {
                    if (!requireNotNull.booleanValue() || astposition != null || !"0".equals(postpattern)) continue block10;
                    nullFieldList.add("astposition");
                    continue block10;
                }
                case "hdm_my_transfer_require_ajob": {
                    if (!requireNotNull.booleanValue() || ajob != null || !"2".equals(postpattern)) continue block10;
                    nullFieldList.add("ajob");
                    continue block10;
                }
                default: {
                    continue block10;
                }
            }
        }
        if (nullFieldList.size() > 0) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199", (String)"", (String)"", (Object[])new Object[0]);
            StringBuilder msgBuilder = new StringBuilder(msg);
            for (int i = 0; i < nullFieldList.size(); ++i) {
                boolean hasNext = true;
                if (i + 1 == nullFieldList.size()) {
                    hasNext = false;
                }
                this.msgAppend(msgBuilder, (String)nullFieldList.get(i), hasNext);
            }
            return msgBuilder.toString();
        }
        return null;
    }

    private String msgMapping(String fieldName) {
        switch (fieldName) {
            case "affaction": {
                return ResManager.loadKDString((String)"\u201c\u4e8b\u52a1\u53d8\u52a8\u64cd\u4f5c\u201d", (String)"", (String)"", (Object[])new Object[0]);
            }
            case "transferreason": {
                return ResManager.loadKDString((String)"\u201c\u8c03\u52a8\u539f\u56e0\u201d", (String)"", (String)"", (Object[])new Object[0]);
            }
            case "acompany": {
                return ResManager.loadKDString((String)"\u201c\u516c\u53f8\u201d", (String)"", (String)"", (Object[])new Object[0]);
            }
            case "aorg": {
                return ResManager.loadKDString((String)"\u201c\u90e8\u95e8\u201d", (String)"", (String)"", (Object[])new Object[0]);
            }
            case "amanagescope": {
                return ResManager.loadKDString((String)"\u201c\u6240\u5c5e\u7ba1\u7406\u8303\u56f4\u201d", (String)"", (String)"", (Object[])new Object[0]);
            }
            case "abaselocation": {
                return ResManager.loadKDString((String)"\u201c\u5e38\u9a7b\u5de5\u4f5c\u5730\u201d", (String)"", (String)"", (Object[])new Object[0]);
            }
            case "plandate": {
                return ResManager.loadKDString((String)"\u201c\u62df\u8c03\u52a8\u65e5\u671f\u201d", (String)"", (String)"", (Object[])new Object[0]);
            }
            case "ajob": {
                return ResManager.loadKDString((String)"\u201c\u804c\u4f4d\u201d", (String)"", (String)"", (Object[])new Object[0]);
            }
            case "aposition": {
                return ResManager.loadKDString((String)"\u201c\u5c97\u4f4d\u201d", (String)"", (String)"", (Object[])new Object[0]);
            }
            case "astposition": {
                return ResManager.loadKDString((String)"\u201c\u6807\u51c6\u5c97\u4f4d\u201d", (String)"", (String)"", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private StringBuilder msgAppend(StringBuilder msg, String field, boolean hasNext) {
        if (hasNext) {
            msg.append(this.msgMapping(field));
            msg.append("\u3001");
        } else {
            msg.append(this.msgMapping(field));
            msg.append("\u3002");
        }
        return msg;
    }
}

