/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.transfer.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.common.transfer.util.ObjectUtils;

public class TransferTerminateValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ExtendedDataEntity dataEntity = dataEntities[0];
        this.terminationValidate(dataEntity);
    }

    private void terminationValidate(ExtendedDataEntity dataEntity) {
        DynamicObject query = ITransferBillService.getInstance().queryOne("transferstatus,auditstatus,transfereffectstatus", dataEntity.getDataEntity().getLong("id"));
        if (ObjectUtils.isEmpty((Object)query)) {
            return;
        }
        String transferStatus = query.getString("transferstatus");
        String transferEffectStatus = query.getString("transfereffectstatus");
        DataDiv dataDiv = new DataDiv(query, new ValidateContext());
        boolean validate = ITransferValidatorService.getInstance().terminalValidate(transferStatus, transferEffectStatus).test(dataDiv);
        if (!validate) {
            this.addFatalErrorMessage(dataEntity, dataDiv.getValidatorContext().map2String());
        }
    }
}

