/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.web.reg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegEffectService;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;
import kd.hr.hdm.common.reg.enums.RegNewAuditStatusEnum;

public class BatchRegEventOp
extends AbstractOperationServicePlugIn {
    private static final ThreadPool THREADPOOL = ThreadPools.newFixedThreadPool((String)"BatchRegEventOpThreadPool", (int)4);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(Arrays.asList("id", "billstatus", "entryentity", "issubmit"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] batchRegBills = e.getDataEntities();
        switch (e.getOperationKey()) {
            case "unsubmit": {
                this.unSubmit(batchRegBills);
                break;
            }
            case "wfauditnotpass": {
                this.auditDisagree(batchRegBills);
                break;
            }
            case "wfauditpass": {
                this.auditPass(batchRegBills);
                break;
            }
            case "wfrejecttosubmit": {
                this.auditReject(batchRegBills);
                break;
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] batchBills = e.getDataEntities();
        List<DynamicObjectCollection> dynamicObjectCollectionList = Arrays.stream(batchBills).map(batchBill -> batchBill.getDynamicObjectCollection("entryentity")).collect(Collectors.toList());
        ArrayList pkValueList = new ArrayList();
        dynamicObjectCollectionList.forEach(dynamicObjectCollection -> dynamicObjectCollection.forEach(dynamicObject -> pkValueList.add(dynamicObject.getPkValue())));
        DynamicObject[] regBills = HDMRegBaseBillRepository.getInstance().query("bemployee,person,cmpemp,billno,ermanfile,effectdate,affaction,preactualdate,laborrelstatus,laborreltype,entrydate,regbilltype,regcategory,regcomment,org,postponedate,probation,probationex,probationunit,termreason,termdate,termuser,preactualdate,regstatus,syncstatus,isexistsworkflow,modifytime,billstatus,auditstatus", new QFilter[]{new QFilter("id", "in", pkValueList)});
        switch (e.getOperationKey()) {
            case "wfauditpass": {
                IRegBillService.getInstance().updatePersonCrossDataByAuditPass(Arrays.asList(regBills));
                break;
            }
            case "unsubmit": {
                IRegBillService.getInstance().syncRegProcess(regBills, "1010");
                IRegBillService.getInstance().syncRegTrace(regBills, "1040");
                this.sendCrossMessage(regBills);
                break;
            }
            case "wfauditnotpass": 
            case "wfrejecttosubmit": {
                IRegEffectService.getInstance().updateReg(regBills);
                IPersonAboutService.getInstance().doUpdatePersonCrossData(regBills, "1040");
                break;
            }
        }
    }

    private void unSubmit(DynamicObject[] batchRegBills) {
        Arrays.stream(batchRegBills).forEach(temp -> {
            temp.set("billstatus", (Object)RegBillStatusEnum.TEMPSTORAGE.getCode());
            temp.set("issubmit", (Object)"0");
            DynamicObjectCollection entryEntity = temp.getDynamicObjectCollection("entryentity");
            DynamicObject[] regBills = this.getRegBillById(entryEntity);
            DynamicObject[] updateRegBills = this.removeDepart(regBills);
            if (updateRegBills.length > 0) {
                Arrays.stream(updateRegBills).forEach(regBill -> {
                    regBill.set("regstatus", (Object)RegBusinessStatusEnum.WAIT_REG.getCode());
                    regBill.set("auditstatus", (Object)RegNewAuditStatusEnum.TEMPSTORAGE.getCode());
                });
                HDMRegBaseBillRepository.getInstance().update(regBills);
            }
        });
    }

    private void auditDisagree(DynamicObject[] batchRegBills) {
        Arrays.stream(batchRegBills).forEach(temp -> {
            temp.set("billstatus", (Object)RegBillStatusEnum.APPROVEREJECTED.getCode());
            DynamicObjectCollection entryEntity = temp.getDynamicObjectCollection("entryentity");
            DynamicObject[] regBills = this.getRegBillById(entryEntity);
            regBills = this.removeDepart(regBills);
            this.setAuditStatus(regBills, RegNewAuditStatusEnum.CHECKED.getCode());
            IRegBillService.getInstance().executeAuditNotPassed(regBills);
        });
    }

    private void auditPass(DynamicObject[] batchRegBills) {
        Arrays.stream(batchRegBills).forEach(temp -> {
            temp.set("billstatus", (Object)RegBillStatusEnum.APPROVEPASSED.getCode());
            DynamicObjectCollection entryEntity = temp.getDynamicObjectCollection("entryentity");
            DynamicObject[] regBills = this.getRegBillById(entryEntity);
            regBills = this.removeDepart(regBills);
            this.setAuditStatus(regBills, RegNewAuditStatusEnum.CHECKED.getCode());
            IRegBillService.getInstance().executeAuditPassed(regBills);
            HDMRegBaseBillRepository.getInstance().update(regBills);
        });
    }

    private void auditReject(DynamicObject[] batchRegBills) {
        Arrays.stream(batchRegBills).forEach(temp -> {
            temp.set("billstatus", (Object)RegBillStatusEnum.WAITRESUBMIT.getCode());
            DynamicObjectCollection entryEntity = temp.getDynamicObjectCollection("entryentity");
            DynamicObject[] regBills = this.getRegBillById(entryEntity);
            regBills = this.removeDepart(regBills);
            this.setAuditStatus(regBills, RegNewAuditStatusEnum.TEMPSTORAGE.getCode());
            IRegBillService.getInstance().executeAuditToSubmit(regBills);
        });
    }

    private DynamicObject[] getRegBillById(DynamicObjectCollection dynamicObjectCollection) {
        List pkValueIdList = dynamicObjectCollection.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        HashMap param = new HashMap(16);
        param.put("id", pkValueIdList);
        return IRegBillService.getInstance().queryRegBill(param, "bemployee,person,cmpemp,billno,ermanfile,effectdate,affaction,preactualdate,laborrelstatus,laborreltype,entrydate,regbilltype,regcategory,regcomment,org,postponedate,probation,probationex,probationunit,termreason,termdate,termuser,preactualdate,regstatus,syncstatus,isexistsworkflow,modifytime,billstatus,auditstatus");
    }

    private DynamicObject[] removeDepart(DynamicObject[] regBills) {
        ArrayList<DynamicObject> regBillList = new ArrayList<DynamicObject>(Arrays.asList(regBills));
        regBillList.removeIf(regBill -> RegBusinessStatusEnum.REJECT_REG.getCode().equals(regBill.getString("regstatus")));
        if (regBillList.size() > 0) {
            return regBillList.toArray(new DynamicObject[0]);
        }
        return new DynamicObject[0];
    }

    private void setAuditStatus(DynamicObject[] regBills, String auditStatus) {
        Arrays.stream(regBills).forEach(regBill -> regBill.set("auditstatus", (Object)auditStatus));
    }

    private void sendCrossMessage(DynamicObject[] regBills) {
        THREADPOOL.execute(() -> {
            IPersonAboutService.getInstance().doUpdatePersonCrossData(regBills, "1040");
            IRegEffectService.getInstance().updateReg(regBills);
        }, RequestContext.get());
    }
}

