/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.opplugin.web.reg;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegEffectService;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.opplugin.validator.reg.RegEventValidator;
import kd.hr.hdm.opplugin.web.reg.RegEventBaseOp;

public class RegEventOp
extends RegEventBaseOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new RegEventValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] regBillObjs = e.getDataEntities();
        switch (e.getOperationKey()) {
            case "unsubmit": {
                Arrays.stream(regBillObjs).forEach(temp -> temp.set("regstatus", (Object)RegBusinessStatusEnum.WAIT_REG.getCode()));
                break;
            }
            case "wfauditnotpass": {
                IRegBillService.getInstance().executeAuditNotPassed(regBillObjs);
                break;
            }
            case "wfauditpass": {
                IRegBillService.getInstance().executeAuditPassed(regBillObjs);
                break;
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] originBills = e.getDataEntities();
        List pkS = Arrays.stream(originBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject[] objects = HDMRegBaseBillRepository.getInstance().query("bemployee,person,cmpemp,billno,ermanfile,effectdate,affaction,preactualdate,laborrelstatus,laborreltype,entrydate,regbilltype,regcategory,regcomment,org,postponedate,probation,probationex,probationunit,termreason,termdate,termuser,preactualdate,regstatus,syncstatus,isexistsworkflow,modifytime,billstatus,auditstatus", new QFilter[]{new QFilter("id", "in", pkS)});
        switch (e.getOperationKey()) {
            case "wfauditpass": {
                List rejectObjs;
                List delayRegObjs;
                List alreadyRegObjs;
                List waitEffectObjs = Arrays.stream(objects).filter(temp -> RegBusinessStatusEnum.REG_PENDINGTOBEVALID.getCode().equals(temp.getString("regstatus"))).collect(Collectors.toList());
                if (!ObjectUtils.isEmpty(waitEffectObjs)) {
                    IRegEffectService.getInstance().updateReg(waitEffectObjs);
                    IPersonAboutService.getInstance().doUpdatePersonCrossData(waitEffectObjs, "1020");
                }
                if (!ObjectUtils.isEmpty(alreadyRegObjs = Arrays.stream(objects).filter(temp -> RegBusinessStatusEnum.ALREADY_REGED.getCode().equals(temp.getString("regstatus"))).collect(Collectors.toList()))) {
                    IRegBillService.getInstance().updateSyncStatus(alreadyRegObjs, "-1");
                    IRegEffectService.getInstance().effectReg(alreadyRegObjs);
                }
                if (!ObjectUtils.isEmpty(delayRegObjs = Arrays.stream(objects).filter(temp -> RegBusinessStatusEnum.WAIT_REG.getCode().equals(temp.getString("regstatus"))).collect(Collectors.toList()))) {
                    IRegEffectService.getInstance().delayReg(delayRegObjs);
                    IPersonAboutService.getInstance().doUpdatePersonCrossData(delayRegObjs, "1040");
                }
                if (ObjectUtils.isEmpty(rejectObjs = Arrays.stream(objects).filter(temp -> RegBusinessStatusEnum.REJECT_REG.getCode().equals(temp.getString("regstatus"))).collect(Collectors.toList()))) break;
                IRegEffectService.getInstance().updateReg(rejectObjs);
                IPersonAboutService.getInstance().doUpdatePersonCrossData(rejectObjs, "1040");
                break;
            }
            case "unsubmit": {
                IRegBillService.getInstance().syncRegProcess(objects, "1010");
                IRegBillService.getInstance().syncRegTrace(objects, "1040");
                IPersonAboutService.getInstance().doUpdatePersonCrossData(objects, "1040");
                IRegEffectService.getInstance().updateReg(objects);
                break;
            }
            case "wfauditnotpass": {
                IRegEffectService.getInstance().updateReg(objects);
                IPersonAboutService.getInstance().doUpdatePersonCrossData(objects, "1040");
            }
        }
    }
}

