/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.application.reg.service.impl;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hdm.business.application.reg.service.IBatchRegService;
import kd.hr.hdm.business.domain.service.hrpi.IHRPIService;
import kd.sdk.hr.hspm.common.utils.QFilterUtil;

public class BatchRegServiceImpl
implements IBatchRegService {
    @Override
    public void fillDynamicObjectCollection4Save(DynamicObjectCollection entryEntity) {
        this.fillDynamicObjectCollection(entryEntity, true);
    }

    @Override
    public void fillDynamicObjectCollection4Import(DynamicObjectCollection entryEntity) {
        this.fillDynamicObjectCollection(entryEntity, false);
    }

    public void fillDynamicObjectCollection(DynamicObjectCollection entryEntity, boolean isSave) {
        Set ermanFileIds = entryEntity.stream().map(temp -> temp.getLong("ermanfile.id")).collect(Collectors.toSet());
        String properties = "id,name,org,affiliateadminorg,empgroup,empposrel,person,employee,cmpemp,dependencytype,empentrel";
        QFilter qFilter = new QFilter("id", "in", ermanFileIds);
        qFilter.and(QFilterUtil.getInitStatusFinish());
        DynamicObject[] ermanFileDys = IHRPIService.getInstance().listFieldsFilterInfo(properties, qFilter, "hspm_ermanfile");
        HashMap ermanFileInfoMap = Maps.newHashMapWithExpectedSize((int)ermanFileDys.length);
        for (DynamicObject ermanFileDy : ermanFileDys) {
            ermanFileInfoMap.put(ermanFileDy.getLong("id"), ermanFileDy);
        }
        entryEntity.forEach(dy -> {
            long ermanFileId = dy.getLong("ermanfile.id");
            DynamicObject ermanFileDy = (DynamicObject)ermanFileInfoMap.get(ermanFileId);
            if (HRObjectUtils.isEmpty((Object)ermanFileDy)) {
                return;
            }
            dy.set("bdependencytype", ermanFileDy.get("dependencytype"));
            dy.set("laborreltype", ermanFileDy.get("empentrel.laborreltype"));
            dy.set("bhrbu", ermanFileDy.get("org"));
            dy.set("baffiliateadminorg", ermanFileDy.get("affiliateadminorg"));
            dy.set("bempgroup", ermanFileDy.get("empgroup"));
            dy.set("badminorg", ermanFileDy.get("empposrel.adminorg"));
            dy.set("person", ermanFileDy.get("person"));
            dy.set("cmpemp", ermanFileDy.get("cmpemp.managingscope"));
            if (isSave) {
                dy.set("entrybillstatus", (Object)"A");
                dy.set("entryauditstatus", (Object)"A");
            }
        });
    }
}

