/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.parttime.batchimport;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.batch.EntryImportDataBuilder;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.domain.parttime.batchimport.PartTimeEntryImportNumberToIdBO;
import kd.hr.hdm.business.domain.parttime.batchimport.handler.PartTimeOrgImportHandler;
import kd.hr.hdm.business.domain.parttime.batchimport.handler.PartTimePositionImportHandler;
import kd.hr.hdm.business.domain.parttime.batchimport.handler.PartTimeStpositionImportHandler;
import kd.hr.hdm.business.domain.transfer.repository.BatchTransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.external.AdminOrgExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;

public class PartTimeEntryImportDataBuilder
extends EntryImportDataBuilder {
    private static final Log LOGGER = LogFactory.getLog(PartTimeEntryImportDataBuilder.class);
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private PartTimeEntryImportNumberToIdBO numberToIdBO;
    private static final Map<String, String> ermanfileMap = new HashMap<String, String>(64);
    private static final String IS_VIRTUAL_ORG = "isvirtualorg";

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> baseDataNumber2Id() {
        return importSource -> {
            this.numberToIdBO = new PartTimeEntryImportNumberToIdBO();
            this.numberToIdBO.number2Id().apply((CopyOnWriteArrayList<EntryImportWrapper>)importSource);
            return importSource;
        };
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> getPeopleRecordByNumber() {
        return importSource -> {
            List<String> personNumbers = importSource.stream().map(temp -> temp.getJsonObject().getString("ermanfilenumber")).collect(Collectors.toList());
            DynamicObject[] dynamicObjects = PersonExternalService.getInstance().listPrimaryErmanFilesByEmpnumber(personNumbers);
            if (dynamicObjects == null || dynamicObjects.length == 0) {
                importSource.forEach(entryImportWrapper -> entryImportWrapper.getValidateContext().setCompleteValidResult("getPeopleRecordByNumber", ResManager.loadKDString((String)"\u65e0\u5339\u914d\u7684\u4eba\u5458\uff0c\u8be5\u4eba\u5458\u53ef\u80fd\u5df2\u79bb\u804c\u6216\u8f93\u5165\u7684\u5de5\u53f7\u6709\u8bef\u3002", (String)"EntryImportDataBuilder_2", (String)"hr-hdm-business", (Object[])new Object[0])));
                return importSource;
            }
            Map<String, Long> labrelstatusprdMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLong("empentrel.labrelstatusprd.id")));
            List<Long> permErmanfileIds = this.getPermErmanFileIds(dynamicObjects);
            Set personNumbersNoPerm = Arrays.stream(dynamicObjects).filter(dy -> !permErmanfileIds.contains(dy.getLong("id"))).map(dy -> dy.getString("number")).collect(Collectors.toSet());
            HashMap<String, List> personnumber = new HashMap<String, List>(importSource.size() << 1);
            importSource.forEach(temp -> {
                String ermanfilenumber = temp.getJsonObject().getString("ermanfilenumber");
                if (personNumbersNoPerm != null && personNumbersNoPerm.contains(ermanfilenumber)) {
                    temp.getValidateContext().setCompleteValidResult("getPeopleRecordByNumber", ResManager.loadKDString((String)"\u5f53\u524d\u5458\u5de5\u4e0d\u5728\u60a8\u7684\u7ba1\u7406\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"EntryImportDataBuilder_18", (String)"hr-hdm-business", (Object[])new Object[0]));
                    return;
                }
                ArrayList<EntryImportWrapper> entryImportWrappers = (ArrayList<EntryImportWrapper>)personnumber.get(ermanfilenumber);
                if (entryImportWrappers == null) {
                    entryImportWrappers = new ArrayList<EntryImportWrapper>(16);
                }
                entryImportWrappers.add((EntryImportWrapper)temp);
                personnumber.put(ermanfilenumber, entryImportWrappers);
            });
            List<Map<String, Object>> ermanfileList = PersonExternalService.getInstance().invokeGetCardFields(permErmanfileIds);
            if (null == ermanfileList || ermanfileList.isEmpty()) {
                personnumber.forEach((personNumber, entryImportWrappers) -> entryImportWrappers.forEach(temp -> temp.getValidateContext().setCompleteValidResult("getPeopleRecordByNumber", ResManager.loadKDString((String)"\u65e0\u5339\u914d\u7684\u4eba\u5458\uff0c\u8be5\u4eba\u5458\u53ef\u80fd\u5df2\u79bb\u804c\u6216\u8f93\u5165\u7684\u5de5\u53f7\u6709\u8bef\u3002", (String)"EntryImportDataBuilder_2", (String)"hr-hdm-business", (Object[])new Object[0]))));
                return importSource;
            }
            Map<String, Map> resultMap = ermanfileList.stream().collect(Collectors.toMap(temp -> (String)temp.get("number"), temp -> temp));
            personnumber.forEach((personNumber, entryImportWrappers) -> {
                Map ermanfile = (Map)resultMap.get(personNumber);
                if (null == ermanfile) {
                    entryImportWrappers.forEach(temp -> temp.getValidateContext().setCompleteValidResult("getPeopleRecordByNumber", ResManager.loadKDString((String)"\u65e0\u5339\u914d\u7684\u4eba\u5458\uff0c\u8be5\u4eba\u5458\u53ef\u80fd\u5df2\u79bb\u804c\u6216\u8f93\u5165\u7684\u5de5\u53f7\u6709\u8bef\u3002", (String)"EntryImportDataBuilder_2", (String)"hr-hdm-business", (Object[])new Object[0])));
                    return;
                }
                if ((Long)labrelstatusprdMap.get(personNumber) != 1010L) {
                    entryImportWrappers.forEach(temp -> temp.getValidateContext().setCompleteValidResult("getPeopleRecordByNumber", ResManager.loadKDString((String)"\u5f53\u524d\u5458\u5de5\u7684\u7528\u5de5\u5173\u7cfb\u9636\u6bb5\u4e0d\u662f\u201c\u7528\u5de5\u8fdb\u884c\u4e2d\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EntryImportDataBuilder_12", (String)"hr-hdm-business", (Object[])new Object[0])));
                    return;
                }
                entryImportWrappers.forEach(entryImportWrapper -> {
                    Date startdate;
                    Date effectdate;
                    JSONObject source = entryImportWrapper.getJsonObject();
                    String importName = (String)source.get((Object)"ename");
                    String ermanfileName = (String)ermanfile.get("name");
                    if (importName != null && !importName.equals(ermanfileName)) {
                        entryImportWrapper.getValidateContext().setCompleteValidResult("importname", String.format(ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5de5\u53f7\u4e0e\u59d3\u540d\u5339\u914d\u5931\u8d25\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"", (String)"hr-hdm-business", (Object[])new Object[0]), personNumber));
                    } else {
                        entryImportWrapper.getJsonObject().put("ename", (Object)ermanfileName);
                    }
                    ermanfileMap.forEach((transferMetaField, ermanfileField) -> source.put(transferMetaField, (Object)this.genJSONObject(ermanfile, (String)ermanfileField)));
                    source.put("positiontype", ermanfile.get("apositiontype"));
                    Long mainbillorg = source.getLong("mainbillorg");
                    Long entryOrgId = (Long)ermanfile.get("org_id");
                    if (!mainbillorg.equals(entryOrgId)) {
                        entryImportWrapper.setCompleteValidResult("orgValiate", ResManager.loadKDString((String)"\u517c\u804c\u4eba\u5458\u4e0d\u5728\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u7684\u7ba1\u7406\u6743\u9650\u8303\u56f4\u5185\uff1b", (String)"EntryImportDataBuilder_14", (String)"hr-hdm-business", (Object[])new Object[0]));
                    }
                    if ((effectdate = source.getDate("effectdate")).before(startdate = (Date)ermanfile.get("startdate"))) {
                        entryImportWrapper.setCompleteValidResult("validateStartdate", ResManager.loadKDString((String)"\u517c\u804c\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7528\u5de5\u5f00\u59cb\u65e5\u671f\u201c%s\u201d\u3002", (String)"EntryImportDataBuilder_13", (String)"hr-hdm-business", (Object[])new Object[]{DateUtils.dateToString((Date)startdate, (DatePattern)DatePattern.YYYY_MM_DD)}));
                    }
                });
            });
            return importSource;
        };
    }

    private List<Long> getPermErmanFileIds(DynamicObject[] dynamicObjects) {
        List<Long> ermanFileIds = Arrays.asList(dynamicObjects).stream().map(temp -> temp.getLong("id")).distinct().collect(Collectors.toList());
        HRBaseServiceHelper ermanfileHelper = new HRBaseServiceHelper("hspm_ermanfile");
        QFilter qf = new QFilter("id", "in", ermanFileIds);
        qf.and(new QFilter("initstatus", "=", (Object)"2"));
        QFilter resultQFilter = (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRuleForBdProp", (Object[])new Object[]{RequestContext.get().getCurrUserId(), BizAppServiceHelp.getAppIdByFormNum((String)"hdm_batchparttime"), "hdm_batchparttime", "partperson", "47150e89000000ac", null});
        if (!Objects.nonNull(resultQFilter)) {
            return ermanFileIds;
        }
        qf.and(resultQFilter);
        DynamicObject[] permErmanfiles = ermanfileHelper.queryOriginalArray("id", qf.toArray());
        if (permErmanfiles == null || permErmanfiles.length == 0) {
            return new ArrayList<Long>(0);
        }
        List<Long> permErmanfileIds = Arrays.stream(permErmanfiles).map(dy -> dy.getLong("id")).distinct().collect(Collectors.toList());
        return permErmanfileIds;
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setDefaultFieldValue() {
        return importSource -> importSource;
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> getBelongCompany() {
        return importSource -> {
            PartTimeOrgImportHandler orgImportHandler = (PartTimeOrgImportHandler)this.numberToIdBO.getExecuteHandler().get("PartTimeOrgImportHandler");
            List<Long> orgIds = orgImportHandler.getOrgIds().stream().distinct().collect(Collectors.toList());
            Map<String, Map<String, Object>> adminOrgInfoQuery = AdminOrgExternalService.getInstance().invokeAdminOrgInfoQuery(orgIds);
            AuthorizedOrgResult permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgsF7", (Object[])new Object[]{RequestContext.get().getCurrUserId(), "1WX49GDDDZ0V", "hdm_batchparttime", "47150e89000000ac", "aadminorg"});
            for (EntryImportWrapper temp : importSource) {
                try {
                    JSONObject jsonObject = temp.getJsonObject();
                    Long aadminorgBoid = JsonObjectUtil.jsonObject2Long.apply(temp.getJsonObject(), "aadminorg");
                    Map<String, Object> adminorg = adminOrgInfoQuery.get(aadminorgBoid.toString());
                    if (HRStringUtils.equals((String)(adminorg.get(IS_VIRTUAL_ORG) + ""), (String)"true")) {
                        temp.getValidateContext().setCompleteValidResult("getBelongCompany", ResManager.loadKDString((String)"\u517c\u804c\u90e8\u95e8\u4e0d\u80fd\u4e3a\u865a\u62df\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PartTimeEntryImportDataBuilder_4", (String)"hr-hdm-business", (Object[])new Object[0]));
                    }
                    Date establishmentdate = (Date)adminorg.get("establishmentdate");
                    Date effectdate = jsonObject.getDate("effectdate");
                    if (effectdate.before(establishmentdate)) {
                        temp.getValidateContext().setCompleteValidResult("getBelongCompany", String.format(ResManager.loadKDString((String)"\u517c\u804c\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u517c\u804c\u90e8\u95e8\u7684\u6210\u7acb\u65e5\u671f\u201c%s\u201d\u3002", (String)"EntryImportDataBuilder_15", (String)"hr-hdm-business", (Object[])new Object[0]), HRDateTimeUtils.format((Date)establishmentdate, (String)YYYY_MM_DD)));
                    }
                    if (!permResult.isHasAllOrgPerm() && !permResult.getHasPermOrgs().contains(aadminorgBoid)) {
                        temp.getValidateContext().setCompleteValidResult("getBelongCompany", String.format(ResManager.loadKDString((String)"\u517c\u804c\u90e8\u95e8 \u201c%s\u201d \u4e0d\u5728\u60a8\u7684\u5f53\u524d\u7684\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EntryImportDataBuilder_16", (String)"hr-hdm-business", (Object[])new Object[0]), adminorg.get("number")));
                    }
                    Long belongCompany = (Long)adminorg.get("belongcompany");
                    jsonObject.put("acompany", (Object)JsonObjectUtil.genJSONObject.apply(belongCompany));
                }
                catch (Exception exception) {
                    JSONObject jsonObject = temp.getJsonObject();
                    String orgId = jsonObject.getJSONObject("aadminorg").getString("number");
                    temp.getValidateContext().setCompleteValidResult("getBelongCompany", String.format(ResManager.loadKDString((String)"\u90e8\u95e8\u7f16\u7801\u201c%1$s\u201d\u6ca1\u6709\u5339\u914d\u5230\u5bf9\u5e94\u7684\u516c\u53f8\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntryImportDataBuilder_5", (String)"hr-hdm-business", (Object[])new Object[0]), orgId));
                }
            }
            return importSource;
        };
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> getOrgChargers() {
        return importSource -> importSource;
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setPositionJob() {
        return importSource -> {
            PartTimePositionImportHandler positionimporthandler = (PartTimePositionImportHandler)this.numberToIdBO.getExecuteHandler().get("PartTimePositionImportHandler");
            List<Long> positionIds = positionimporthandler.getPositionIds();
            if (positionIds.isEmpty()) {
                return importSource;
            }
            Map<String, Object> positionHis = AdminOrgExternalService.getInstance().invokeQueryPositionHis(positionIds, new Date());
            LOGGER.info("EntryImportValidateServiceImpl start validatePositionBelongsToOrg inoke result info :  {} ", (Object)positionHis.toString());
            Map data = (Map)positionHis.get("data");
            if (null == data) {
                LOGGER.info("EntryImportValidateServiceImpl setPositionVid data is null");
                importSource.forEach(temp -> temp.getValidateContext().setCompleteValidResult("validatePositionBelongsToOrg", ResManager.loadKDString((String)"\u5c97\u4f4d\u7f16\u7801\u65e0\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599", (String)"", (String)"hr-hdm-business", (Object[])new Object[0])));
                return importSource;
            }
            List hisdata = (List)data.get("hisdata");
            if (null == hisdata) {
                LOGGER.info("EntryImportValidateServiceImpl setPositionVid hisdata is null");
                importSource.forEach(temp -> temp.getValidateContext().setCompleteValidResult("validatePositionBelongsToOrg", ResManager.loadKDString((String)"\u5c97\u4f4d\u7f16\u7801\u65e0\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599", (String)"", (String)"hr-hdm-business", (Object[])new Object[0])));
                return importSource;
            }
            HashMap positionBelongOrgMap = new HashMap(hisdata.size());
            HashMap positionAndJob = new HashMap(16);
            hisdata.forEach(temp -> {
                Long adminorg = (Long)temp.get("adminorg");
                positionAndJob.put((Long)temp.get("boid"), (Long)temp.get("job"));
                positionBelongOrgMap.put((Long)temp.get("boid"), adminorg);
            });
            importSource.forEach(entryImportWrapper -> {
                JSONObject jsonObject = entryImportWrapper.getJsonObject();
                if (!jsonObject.getString("apositiontype").equals(ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"EntryImportDataBuilder_11", (String)"hr-hdm-business", (Object[])new Object[0]))) {
                    return;
                }
                Long inputOrg = JsonObjectUtil.jsonObject2Long.apply(jsonObject, "aadminorg");
                Long apositionId = JsonObjectUtil.jsonObject2Long.apply(jsonObject, "aposition");
                Long jobId = (Long)positionAndJob.get(apositionId);
                if (jobId != null) {
                    jsonObject.put("bjob", (Object)this.genJSONObject(jobId));
                }
                if (StringUtils.isEmpty((String)jsonObject.getString("aadminorg_no")) || StringUtils.isEmpty((String)jsonObject.getString("aposition_no"))) {
                    return;
                }
                if (!positionBelongOrgMap.containsKey(apositionId) || ((Long)positionBelongOrgMap.get(apositionId)).longValue() != inputOrg.longValue()) {
                    entryImportWrapper.getValidateContext().setCompleteValidResult("validatePositionBelongsToOrg", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u517c\u804c\u90e8\u95e8\u201c%1$s\uff0c%2$s\u201d\u4e0b\u4e0d\u5b58\u5728\u5c97\u4f4d\u201c%3$s\uff0c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EntryImportDataBuilder_17", (String)"hr-hdm-business", (Object[])new Object[0]), jsonObject.getString("aadminorg_no"), jsonObject.getString("aadminorg_name"), jsonObject.getString("aposition_no"), jsonObject.getString("aposition_name")));
                }
            });
            return importSource;
        };
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setStpositionJob() {
        return importSource -> {
            PartTimeStpositionImportHandler positionimporthandler = (PartTimeStpositionImportHandler)this.numberToIdBO.getExecuteHandler().get("PartTimeStpositionImportHandler");
            List<Long> positionIds = positionimporthandler.getStpositionIds();
            if (positionIds.isEmpty()) {
                return importSource;
            }
            Map<String, Object> stdMap = AdminOrgExternalService.getInstance().invokeQueryStandardPosition(positionIds);
            Object data = stdMap.get("data");
            if (!positionIds.isEmpty() && data == null) {
                importSource.forEach(temp -> temp.getValidateContext().setCompleteValidResult("setStpositionJob", "invokeQueryStandardPosition error"));
                return importSource;
            }
            List resultList = (List)data;
            Map<Long, Long> stpositionAndJobIdMap = resultList.stream().collect(Collectors.toMap(temp -> (Long)temp.get("boid"), temp -> (Long)temp.get("job.id"), (k1, k2) -> k1));
            importSource.forEach(temp -> {
                JSONObject jsonObject = temp.getJsonObject();
                if (!jsonObject.getString("apositiontype").equals(ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"EntryImportDataBuilder_7", (String)"hr-hdm-business", (Object[])new Object[0]))) {
                    return;
                }
                Long jobId = (Long)stpositionAndJobIdMap.get(JsonObjectUtil.jsonObject2Long.apply(jsonObject, "stdposition"));
                if (null != jobId) {
                    jsonObject.put("bjob", (Object)this.genJSONObject(jobId));
                }
            });
            return importSource;
        };
    }

    @Override
    public Predicate<List<EntryImportWrapper>> validateStdPosition() {
        return temp -> true;
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setBJobInfo() {
        return importSource -> importSource;
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setRealityDate() {
        return importSource -> importSource;
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setAppremoveInfo() {
        return importSource -> importSource;
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> genBillNo() {
        return importSource -> {
            DynamicObject dynamicObject = BatchTransferBillRepository.getServiceHelper().generateEmptyDynamicObject();
            importSource.forEach(temp -> {
                List hdm_transferbatchentry = CodeRuleServiceHelper.getNumbers((String)"hdm_parttimebillentry", Collections.singletonList(dynamicObject));
                temp.getJsonObject().put("ebillno", hdm_transferbatchentry.get(0));
            });
            return importSource;
        };
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setAffaction() {
        return importSource -> {
            this.setAffactionId((CopyOnWriteArrayList<EntryImportWrapper>)importSource, "hdm_parttime_hpfs_new", ResManager.loadKDString((String)"\u53d8\u52a8\u64cd\u4f5c\u586b\u5199\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EntryImportDataBuilder_9", (String)"hr-hdm-business", (Object[])new Object[0]));
            return importSource;
        };
    }

    @Override
    public Map<String, String> getErmanfileMappingMap() {
        return ermanfileMap;
    }

    static {
        ermanfileMap.put("company", "company_id");
        ermanfileMap.put("adminorg", "adminorg_id");
        ermanfileMap.put("positiontype", "apositiontype");
        ermanfileMap.put("primarycity", "location_id");
        ermanfileMap.put("stdposition", "stdposition_id");
        ermanfileMap.put("position", "position_id");
        ermanfileMap.put("job", "job_id");
        ermanfileMap.put("blaborreltype", "laborreltype_id");
        ermanfileMap.put("blaborrelstatus", "laborrelstatus_id");
        ermanfileMap.put("primaryhrbu", "org_id");
        ermanfileMap.put("primaryaftadminorg", "affiliateadminorg_id");
        ermanfileMap.put("primaryempgroup", "empgroup_id");
        ermanfileMap.put("person", "person_id");
        ermanfileMap.put("primaryemployee", "employee_id");
        ermanfileMap.put("primarydepemp", "depemp_id");
        ermanfileMap.put("primarycmpemp", "cmpemp_id");
        ermanfileMap.put("pcmpemp", "managingscope_id");
        ermanfileMap.put("partperson", "id");
    }
}

