/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.parttime.batchimport;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.batch.EntryImportValidator;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.domain.parttime.PerChgBizUtils;
import kd.hr.hdm.business.domain.parttime.batchimport.PartTimeEntryImportValidateService;
import kd.hr.hdm.business.domain.parttime.repository.ParttimeBatchRepository;
import kd.hr.hdm.business.domain.parttime.validate.BatchParttimeValidateHelper;
import kd.hr.hdm.business.domain.transfer.service.external.AdminOrgExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.JobExternalService;
import kd.hr.hdm.common.parttime.enums.PartTimeStatusEnum;
import kd.hr.hdm.common.parttime.enums.PosTypeEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hpfs.business.service.cert.HRCertValidateServiceHelper;

public class PartTimeEntryImportValidateServiceImpl
implements PartTimeEntryImportValidateService {
    private static final Log LOGGER = LogFactory.getLog(PartTimeEntryImportValidateServiceImpl.class);
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String KEY_CROSSVALIDATERANGE = "crossValidNoti";
    private static final String KEY_ACTIONID = "actionId";
    private static final String KEY_BILLNO = "billNo";
    private static final String CROSSVALIDATERANGE_WARN = "2";
    private static final String CROSSVALIDATERANGE_BAN = "3";
    private static final String KEY_ACTIONNAME = "actionName";

    @Override
    public Predicate<List<EntryImportWrapper>> beforeDataInitValidate() {
        return entryImportWrappers -> {
            entryImportWrappers.forEach(temp -> this.doCommonValiddate().test((EntryImportWrapper)temp));
            this.validateEntryRepeat().test((List<EntryImportWrapper>)entryImportWrappers);
            List collect = entryImportWrappers.stream().filter(temp -> temp.getValidateContext().getValidateResult().size() < 1).collect(Collectors.toList());
            this.validateBusinessFieldDate().test(collect);
            return true;
        };
    }

    @Override
    public Predicate<List<EntryImportWrapper>> afterDataInitValidate() {
        return temp -> {
            List validImportData = temp.stream().filter(importWrapper -> importWrapper.getValidateContext().getValidateResult().size() < 1).collect(Collectors.toList());
            this.validatePartTimeRepeatByProcessStatus().test(validImportData);
            this.validateApositiontype().and(this.validateLicence()).test(validImportData);
            this.crossValidateBatch().test(validImportData);
            return true;
        };
    }

    public Predicate<List<EntryImportWrapper>> validateLicence() {
        return entryImportWrapper -> {
            try {
                Map<Long, EntryImportWrapper> personIdMap = entryImportWrapper.stream().collect(Collectors.toMap(temp -> JsonObjectUtil.jsonObject2Long.apply(temp.getJsonObject(), "person"), temp -> temp, (k1, k2) -> k1));
                Map licenseMap = HRCertValidateServiceHelper.checkPersonLicenses(new ArrayList<Long>(personIdMap.keySet()));
                if (licenseMap == null || licenseMap.isEmpty()) {
                    String message = ResManager.loadKDString((String)"\u672a\u68c0\u67e5\u5230\u8bb8\u53ef\u4eba\u5458\u3002", (String)"PartTimeEntryImportValidateServiceImpl_20", (String)"hr-hdm-business", (Object[])new Object[0]);
                    personIdMap.forEach((personId, entryImportData) -> entryImportData.getValidateContext().setCompleteValidResult("validateLicence", message));
                } else {
                    personIdMap.forEach((personId, entryImportData) -> {
                        Map personInfo = (Map)licenseMap.get(personId);
                        if (personInfo != null && personInfo.size() > 0 && !((Boolean)personInfo.get("status")).booleanValue()) {
                            String name = (String)personInfo.get("name");
                            String number = (String)personInfo.get("number");
                            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u53d1\u8d77\u517c\u804c\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"PartTimeEntryImportValidateServiceImpl_21", (String)"hr-hdm-business", (Object[])new Object[0]), name, number);
                            entryImportData.getValidateContext().setCompleteValidResult("validateLicence", message);
                        }
                    });
                }
            }
            catch (Exception exception) {
                String message = ResManager.loadKDString((String)"\u672a\u68c0\u67e5\u5230\u8bb8\u53ef\u4eba\u5458\u3002", (String)"PartTimeEntryImportValidateServiceImpl_20", (String)"hr-hdm-business", (Object[])new Object[0]);
                entryImportWrapper.forEach(temp -> temp.getValidateContext().setCompleteValidResult("validateLicence", message));
                LOGGER.error((Throwable)exception);
            }
            return true;
        };
    }

    @Override
    public Predicate<EntryImportWrapper> doCommonValiddate() {
        return temp -> {
            String apositiontype = temp.getJsonObject().getString("apositiontype");
            Predicate<EntryImportWrapper> validate = EntryImportValidator.NOT_EMPTY.testOnNotEmpty("ermanfilenumber", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5de5\u53f7\u201d\u3002", (String)"EntryImportValidateServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0])).and(EntryImportValidator.NOT_EMPTY.testOnNotEmpty("affaction", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u517c\u804c\u64cd\u4f5c\u201d\u3002", (String)"PartTimeEntryImportValidateServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]))).and(EntryImportValidator.NOT_EMPTY.testOnNotEmpty("parttimereason", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u517c\u804c\u539f\u56e0\u201d\u3002", (String)"PartTimeEntryImportValidateServiceImpl_2", (String)"hr-hdm-business", (Object[])new Object[0]))).and(EntryImportValidator.NOT_EMPTY.testOnNotEmpty("aadminorg", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u517c\u804c\u90e8\u95e8\u201d\u3002", (String)"PartTimeEntryImportValidateServiceImpl_3", (String)"hr-hdm-business", (Object[])new Object[0]))).and(EntryImportValidator.NOT_EMPTY.testOnNotEmpty("apositiontype", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4efb\u5c97\u6a21\u5f0f\u201d\u3002", (String)"PartTimeEntryImportValidateServiceImpl_4", (String)"hr-hdm-business", (Object[])new Object[0]))).and(EntryImportValidator.NOT_EMPTY.testOnNotEmpty("effectdate", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u517c\u804c\u5f00\u59cb\u65e5\u671f\u201d\u3002", (String)"PartTimeEntryImportValidateServiceImpl_5", (String)"hr-hdm-business", (Object[])new Object[0])));
            if (apositiontype == null) {
                validate.test((EntryImportWrapper)temp);
                return true;
            }
            LOGGER.info("doCommonValiddate position system translate : {} ,excel translate :{}", (Object)ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"EntryImportValidateServiceImpl_28", (String)"hr-hdm-business", (Object[])new Object[0]), (Object)apositiontype);
            LOGGER.info("doCommonValiddate stposition system translate : {} ,excel translate :{}", (Object)ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"EntryImportValidateServiceImpl_29", (String)"hr-hdm-business", (Object[])new Object[0]), (Object)apositiontype);
            LOGGER.info("doCommonValiddate job system translate : {} ,excel translate :{}", (Object)ResManager.loadKDString((String)"\u804c\u4f4d", (String)"EntryImportValidateServiceImpl_30", (String)"hr-hdm-business", (Object[])new Object[0]), (Object)apositiontype);
            if (ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"EntryImportValidateServiceImpl_28", (String)"hr-hdm-business", (Object[])new Object[0]).equals(apositiontype)) {
                validate.and(EntryImportValidator.NOT_EMPTY.testOnNotEmpty("aposition", ResManager.loadKDString((String)"\u517c\u804c\u4efb\u5c97\u6a21\u5f0f\u4e3a\u201c\u5c97\u4f4d\u201d\u65f6\uff0c\u5fc5\u987b\u586b\u5199\u201c\u517c\u804c\u5c97\u4f4d\u201d\u3002", (String)"PartTimeEntryImportValidateServiceImpl_6", (String)"hr-hdm-business", (Object[])new Object[0]))).test((EntryImportWrapper)temp);
            } else if (ResManager.loadKDString((String)"\u804c\u4f4d", (String)"EntryImportValidateServiceImpl_30", (String)"hr-hdm-business", (Object[])new Object[0]).equals(apositiontype)) {
                validate.and(EntryImportValidator.NOT_EMPTY.testOnNotEmpty("bjob", ResManager.loadKDString((String)"\u517c\u804c\u4efb\u5c97\u6a21\u5f0f\u4e3a\u201c\u804c\u4f4d\u201d\uff0c\u5fc5\u987b\u586b\u5199\u201c\u517c\u804c\u804c\u4f4d\u201d\u3002", (String)"PartTimeEntryImportValidateServiceImpl_7", (String)"hr-hdm-business", (Object[])new Object[0]))).test((EntryImportWrapper)temp);
            } else if (ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"EntryImportValidateServiceImpl_29", (String)"hr-hdm-business", (Object[])new Object[0]).equals(apositiontype)) {
                validate.and(EntryImportValidator.NOT_EMPTY.testOnNotEmpty("astdposition", ResManager.loadKDString((String)"\u517c\u804c\u4efb\u5c97\u6a21\u5f0f\u4e3a\u201c\u6807\u51c6\u5c97\u4f4d\u201d\u65f6\uff0c\u5fc5\u987b\u586b\u5199\u201c\u517c\u804c\u6807\u51c6\u5c97\u4f4d\u201d\u3002", (String)"PartTimeEntryImportValidateServiceImpl_8", (String)"hr-hdm-business", (Object[])new Object[0]))).test((EntryImportWrapper)temp);
            } else {
                validate.test((EntryImportWrapper)temp);
            }
            return true;
        };
    }

    @Override
    public Predicate<EntryImportWrapper> doBusinessValiddate() {
        return null;
    }

    public Predicate<List<EntryImportWrapper>> validatePartTimeRepeatByProcessStatus() {
        return entryImportWrappers -> {
            Set<Long> personIds;
            HashSet<Long> adminorgs;
            Map<String, List<DynamicObject>> partFileMap;
            LOGGER.info("start validatePartTimeRepeatByProcessStatus");
            HashSet<Long> erMainFileIds = new HashSet<Long>(entryImportWrappers.size());
            HashSet<Long> aadminorgIds = new HashSet<Long>(entryImportWrappers.size());
            Consumer<EntryImportWrapper> getIds = entryImportWrapper -> {
                JSONObject data = entryImportWrapper.getJsonObject();
                erMainFileIds.add(data.getJSONObject("partperson").getLong("id"));
                aadminorgIds.add(data.getJSONObject("aadminorg").getLong("boid"));
            };
            Map importSoureceMap = entryImportWrappers.stream().peek(getIds).collect(Collectors.toMap(entryImportWrapper -> this.getKey(entryImportWrapper.getJsonObject()), Function.identity(), (oldV, newV) -> newV));
            Map<String, List<DynamicObject>> existBillMap = BatchParttimeValidateHelper.getExistBatchParttimeBills(erMainFileIds, null, aadminorgIds);
            HashMap<Long, List<EntryImportWrapper>> errorMaps = new HashMap<Long, List<EntryImportWrapper>>(8);
            ArrayList needQueryPartFiles = new ArrayList(8);
            importSoureceMap.forEach((key, entryImportWrapper) -> {
                if (existBillMap.containsKey(key)) {
                    List existBills = (List)existBillMap.get(key);
                    HashSet<String> parttimestatusSet = new HashSet<String>(0);
                    for (DynamicObject existBill : existBills) {
                        String parttimestatus = existBill.getString("parttimestatus");
                        parttimestatusSet.add(parttimestatus);
                        long mid = existBill.getLong("mid");
                        if (!PartTimeStatusEnum.PROCESS.getCode().equals(parttimestatus)) continue;
                        PartTimeEntryImportValidateServiceImpl.setErrorInfo(entryImportWrapper, mid, existBill, errorMaps);
                        break;
                    }
                    if (!parttimestatusSet.contains(PartTimeStatusEnum.PROCESS.getCode()) && parttimestatusSet.contains(PartTimeStatusEnum.ALREADY.getCode())) {
                        needQueryPartFiles.add(entryImportWrapper);
                    }
                }
            });
            if (!needQueryPartFiles.isEmpty() && (partFileMap = BatchParttimeValidateHelper.getPartFileMap(adminorgs = new HashSet<Long>(needQueryPartFiles.size()), personIds = needQueryPartFiles.stream().peek(entryImportWrapper -> adminorgs.add(entryImportWrapper.getJsonObject().getJSONObject("aadminorg").getLong("boid"))).map(entryImportWrapper -> entryImportWrapper.getJsonObject().getJSONObject("person").getLong("id")).collect(Collectors.toSet()))) != null) {
                for (EntryImportWrapper validate : needQueryPartFiles) {
                    Optional<DynamicObject> existBill;
                    JSONObject data = validate.getJsonObject();
                    String key2 = this.getKey(data);
                    if (!partFileMap.containsKey(key2) || !(existBill = existBillMap.get(key2).stream().filter(exist -> PartTimeStatusEnum.ALREADY.getCode().equals(exist.getString("parttimestatus"))).findFirst()).isPresent()) continue;
                    long mid = existBill.get().getLong("mid");
                    PartTimeEntryImportValidateServiceImpl.setErrorInfo(validate, mid, existBill.get(), errorMaps);
                }
            }
            if (!errorMaps.isEmpty()) {
                DynamicObject[] dys;
                for (DynamicObject dy : dys = ParttimeBatchRepository.getInstance().queryOriginalArray("billno, id", new QFilter("id", "in", errorMaps.keySet()).toArray())) {
                    long mid = dy.getLong("id");
                    List validates = (List)errorMaps.get(mid);
                    validates.forEach(entryImportWrapper -> entryImportWrapper.setCompleteValidResult("validatePartTimeRepeatByProcessStatus", ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c{0}\u201d\u5df2\u5b58\u5728\u76f8\u540c\u7684\u517c\u804c\u4e8b\u52a1\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c{1}\u201d\uff0c\u4e0d\u53ef\u4e3a\u540c\u4e00\u4eba\u5458\u91cd\u590d\u53d1\u8d77\u76f8\u540c\u517c\u804c\u3002", (String)"ParttimeValidateHelper_0", (String)"hr-hdm-business", (Object[])new Object[]{entryImportWrapper.getJsonObject().getString("ename"), dy.getString("billno")})));
                }
            }
            return true;
        };
    }

    private String getKey(JSONObject importSource) {
        Long personId = importSource.getJSONObject("person").getLong("id");
        String posType = this.postPatternMapping(importSource);
        long aadminorgId = JsonObjectUtil.jsonObject2BoidLong.apply(importSource, "aadminorg");
        String key = personId + posType + aadminorgId;
        if (PosTypeEnum.POS.getCode().equals(posType)) {
            return key + JsonObjectUtil.jsonObject2BoidLong.apply(importSource, "aposition");
        }
        if (PosTypeEnum.STD_POS.getCode().equals(posType)) {
            return key + JsonObjectUtil.jsonObject2BoidLong.apply(importSource, "astdposition");
        }
        if (PosTypeEnum.JOB.getCode().equals(posType)) {
            return key + JsonObjectUtil.jsonObject2BoidLong.apply(importSource, "bjob");
        }
        return "";
    }

    private String postPatternMapping(JSONObject jsonObject) {
        String postPattern = jsonObject.getString("apositiontype");
        if (ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"EntryImportValidateServiceImpl_28", (String)"hr-hdm-business", (Object[])new Object[0]).equals(postPattern)) {
            return "1";
        }
        if (ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"EntryImportValidateServiceImpl_29", (String)"hr-hdm-business", (Object[])new Object[0]).equals(postPattern)) {
            return "0";
        }
        if (ResManager.loadKDString((String)"\u804c\u4f4d", (String)"EntryImportValidateServiceImpl_30", (String)"hr-hdm-business", (Object[])new Object[0]).equals(postPattern)) {
            return CROSSVALIDATERANGE_WARN;
        }
        return "-1";
    }

    private Predicate<List<EntryImportWrapper>> validateEntryRepeat() {
        return entryImportWrapper -> {
            Map<String, List<EntryImportWrapper>> personnumber = entryImportWrapper.stream().filter(temp -> temp.getValidateContext().getValidateResult().size() < 1).collect(Collectors.groupingBy(temp -> {
                String ermanfilenumber = temp.getJsonObject().getString("ermanfilenumber");
                String apositiontype = temp.getJsonObject().getString("apositiontype");
                String aadminorg = temp.getJsonObject().getJSONObject("aadminorg").getString("number");
                return ermanfilenumber + apositiontype + aadminorg;
            }));
            personnumber.forEach((key, value) -> {
                if (value.size() > 1) {
                    Map<String, List<EntryImportWrapper>> groupByPostpattern = value.stream().collect(Collectors.groupingBy(temp -> {
                        String postPattern = temp.getJsonObject().getString("apositiontype");
                        JSONObject aposition = temp.getJsonObject().getJSONObject("aposition");
                        JSONObject astdposition = temp.getJsonObject().getJSONObject("astdposition");
                        JSONObject bjob = temp.getJsonObject().getJSONObject("bjob");
                        if (ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"EntryImportValidateServiceImpl_28", (String)"hr-hdm-business", (Object[])new Object[0]).equals(postPattern)) {
                            return aposition.getString("number");
                        }
                        if (ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"EntryImportValidateServiceImpl_29", (String)"hr-hdm-business", (Object[])new Object[0]).equals(postPattern)) {
                            return astdposition.getString("number");
                        }
                        if (ResManager.loadKDString((String)"\u804c\u4f4d", (String)"EntryImportValidateServiceImpl_30", (String)"hr-hdm-business", (Object[])new Object[0]).equals(postPattern)) {
                            return bjob.getString("number");
                        }
                        return "-1";
                    }));
                    groupByPostpattern.forEach((postPatternNumber, data) -> {
                        if (!postPatternNumber.equals("-1") && data.size() > 1) {
                            for (EntryImportWrapper importWrapper : data) {
                                importWrapper.getValidateContext().setCompleteValidResult("repeat", String.format(ResManager.loadKDString((String)"\u8be5\u5458\u5de5\uff08\u5de5\u53f7\uff1a%s\uff09\u5728\u5f53\u524d\u6a21\u677f\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u517c\u804c\u4efb\u804c\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PartTimeEntryImportValidateServiceImpl_11", (String)"hr-hdm-business", (Object[])new Object[0]), importWrapper.getJsonObject().getString("ermanfilenumber")));
                            }
                        }
                    });
                }
            });
            return true;
        };
    }

    public Predicate<List<EntryImportWrapper>> validateBusinessFieldDate() {
        return entryImportWrappers -> {
            int size = entryImportWrappers.size();
            HashSet<String> stpostionSet = new HashSet<String>(size);
            HashSet<String> postionSet = new HashSet<String>(size);
            HashSet<String> jobSet = new HashSet<String>(size);
            for (EntryImportWrapper entryImportWrapper : entryImportWrappers) {
                JSONObject jsonObject = entryImportWrapper.getJsonObject();
                String apositiontype = jsonObject.getString("apositiontype");
                if (ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"EntryImportValidateServiceImpl_28", (String)"hr-hdm-business", (Object[])new Object[0]).equals(apositiontype)) {
                    String positionNumber = jsonObject.getJSONObject("aposition").getString("number");
                    postionSet.add(positionNumber);
                    continue;
                }
                if (ResManager.loadKDString((String)"\u804c\u4f4d", (String)"EntryImportValidateServiceImpl_30", (String)"hr-hdm-business", (Object[])new Object[0]).equals(apositiontype)) {
                    String jobNumber = jsonObject.getJSONObject("bjob").getString("number");
                    jobSet.add(jobNumber);
                    continue;
                }
                if (!ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"EntryImportValidateServiceImpl_29", (String)"hr-hdm-business", (Object[])new Object[0]).equals(apositiontype)) continue;
                String stpositionNumber = jsonObject.getJSONObject("astdposition").getString("number");
                stpostionSet.add(stpositionNumber);
            }
            Date date = new Date();
            Map<String, Object> stposition = AdminOrgExternalService.getInstance().queryStdPositionByNumber(new ArrayList<String>(stpostionSet), date);
            Map<String, Object> position = AdminOrgExternalService.getInstance().queryPositionHisByNumber(new ArrayList<String>(postionSet), date);
            Map<String, Object> jobHisSimpleInfo = JobExternalService.getInstance().invokeQueryJobHisSimpleInfo(new ArrayList<String>(jobSet), null);
            Map<String, Date> stpostionNumberAndDate = this.preResolveDate(stposition);
            Map<String, Date> positionNumberAndDate = this.preResolveDate(position);
            Map<String, Date> jobNumberAndDate = this.preResolveDate(jobHisSimpleInfo);
            this.compareDate((List<EntryImportWrapper>)entryImportWrappers, stpostionNumberAndDate, positionNumberAndDate, jobNumberAndDate);
            return true;
        };
    }

    private void compareDate(List<EntryImportWrapper> entryImportWrappers, Map<String, Date> stpostionNumberAndDate, Map<String, Date> positionNumberAndDate, Map<String, Date> jobNumberAndDate) {
        entryImportWrappers.forEach(entryImportWrapper -> {
            boolean before;
            String stpositionNumber;
            Date firstBsed;
            Date effectdate;
            JSONObject jsonObject = entryImportWrapper.getJsonObject();
            try {
                effectdate = jsonObject.getDate("effectdate");
            }
            catch (NumberFormatException exception) {
                entryImportWrapper.getValidateContext().setCompleteValidResult("validateBusinessFieldDate", String.format(ResManager.loadKDString((String)"\u517c\u804c\u5f00\u59cb\u65e5\u671f\u201c%s\u201d\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"PartTimeEntryImportValidateServiceImpl_19", (String)"hr-hdm-business", (Object[])new Object[0]), jsonObject.get((Object)"effectdate")));
                return;
            }
            String apositiontype = jsonObject.getString("apositiontype");
            if (ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"EntryImportValidateServiceImpl_28", (String)"hr-hdm-business", (Object[])new Object[0]).equals(apositiontype)) {
                boolean postionBefore;
                String positionNumber = jsonObject.getJSONObject("aposition").getString("number");
                Date positionFirstBesd = (Date)positionNumberAndDate.get(positionNumber);
                if (positionFirstBesd != null && (postionBefore = effectdate.before(positionFirstBesd))) {
                    entryImportWrapper.getValidateContext().setCompleteValidResult("validateBusinessFieldDate", String.format(ResManager.loadKDString((String)"\u517c\u804c\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u5c97\u4f4d\u7684\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"PartTimeEntryImportValidateServiceImpl_16", (String)"hr-hdm-business", (Object[])new Object[0]), HRDateTimeUtils.format((Date)positionFirstBesd, (String)YYYY_MM_DD)));
                }
            } else if (ResManager.loadKDString((String)"\u804c\u4f4d", (String)"EntryImportValidateServiceImpl_30", (String)"hr-hdm-business", (Object[])new Object[0]).equals(apositiontype)) {
                boolean jobBefore;
                String jobNumber = jsonObject.getJSONObject("bjob").getString("number");
                Date jobFirstBesd = (Date)jobNumberAndDate.get(jobNumber);
                if (jobFirstBesd != null && (jobBefore = effectdate.before(jobFirstBesd))) {
                    entryImportWrapper.getValidateContext().setCompleteValidResult("validateBusinessFieldDate", String.format(ResManager.loadKDString((String)"\u517c\u804c\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u804c\u4f4d\u7684\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"PartTimeEntryImportValidateServiceImpl_17", (String)"hr-hdm-business", (Object[])new Object[0]), HRDateTimeUtils.format((Date)jobFirstBesd, (String)YYYY_MM_DD)));
                }
            } else if (ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"EntryImportValidateServiceImpl_29", (String)"hr-hdm-business", (Object[])new Object[0]).equals(apositiontype) && (firstBsed = (Date)stpostionNumberAndDate.get(stpositionNumber = jsonObject.getJSONObject("astdposition").getString("number"))) != null && (before = effectdate.before(firstBsed))) {
                entryImportWrapper.getValidateContext().setCompleteValidResult("validateBusinessFieldDate", String.format(ResManager.loadKDString((String)"\u517c\u804c\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u6807\u51c6\u5c97\u4f4d\u7684\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"PartTimeEntryImportValidateServiceImpl_18", (String)"hr-hdm-business", (Object[])new Object[0]), HRDateTimeUtils.format((Date)firstBsed, (String)YYYY_MM_DD)));
            }
        });
    }

    private Map<String, Date> preResolveDate(Map<String, Object> invokeResult) {
        if (invokeResult == null) {
            return new HashMap<String, Date>(16);
        }
        Object data = invokeResult.get("data");
        if (data instanceof DynamicObjectCollection) {
            DynamicObjectCollection maps = (DynamicObjectCollection)data;
            Map<String, Date> collect = maps.stream().filter(temp -> temp.get("firstbsed") != null && temp.get("number") != null).collect(Collectors.toMap(temp -> (String)temp.get("number"), temp -> (Date)temp.get("firstbsed"), (k1, k2) -> k1));
            return collect;
        }
        if (data instanceof List) {
            List maps = (List)data;
            Map<String, Date> collect = maps.stream().filter(temp -> temp.get("firstbsed") != null && temp.get("number") != null).collect(Collectors.toMap(temp -> (String)temp.get("number"), temp -> (Date)temp.get("firstbsed"), (k1, k2) -> k1));
            return collect;
        }
        return new HashMap<String, Date>(16);
    }

    public Predicate<List<EntryImportWrapper>> validateApositiontype() {
        return entryImportWrappers -> {
            Map<String, Object> standardPositionByOrg;
            List<Long> queryOrgIdList = entryImportWrappers.stream().filter(wrapper -> PosTypeEnum.STD_POS.getName().equals(wrapper.getJsonObject().getString("apositiontype"))).map(wraper -> wraper.getJsonObject().getJSONObject("aadminorg").getLong("id")).distinct().collect(Collectors.toList());
            HashMap standardPositionMap = new HashMap(queryOrgIdList.size());
            if (queryOrgIdList != null && !queryOrgIdList.isEmpty() && (standardPositionByOrg = AdminOrgExternalService.getInstance().queryStandardPositionByOrg(queryOrgIdList)) != null && new Integer(200).equals(standardPositionByOrg.get("code"))) {
                List data = (List)standardPositionByOrg.get("data");
                for (Map map : data) {
                    List standardPositions = (List)map.get("standardPositions");
                    if (ObjectUtils.isEmpty((Collection)standardPositions) || ObjectUtils.isEmpty((Collection)standardPositions)) continue;
                    standardPositionMap.put((Long)map.get("orgId"), standardPositions.stream().map(standardPosition -> standardPosition.getLong("id")).collect(Collectors.toSet()));
                }
            }
            for (EntryImportWrapper entryImportWrapper : entryImportWrappers) {
                long astdpositionId;
                Set standardPositions;
                Long aadmingBoid;
                long jobId;
                long bjobId;
                JSONObject jsonObject = entryImportWrapper.getJsonObject();
                String apositiontype = jsonObject.getString("apositiontype");
                String positiontype = jsonObject.getString("positiontype");
                long aadminorg = jsonObject.getJSONObject("aadminorg").getLong("id");
                long adminorg = jsonObject.getJSONObject("adminorg").getLong("id");
                if (PosTypeEnum.POS.getName().equals(apositiontype) && PosTypeEnum.POS.getCode().equals(positiontype)) {
                    long positionId;
                    long apositionId = jsonObject.getJSONObject("aposition").getLongValue("id");
                    if (apositionId == (positionId = jsonObject.getJSONObject("position").getLongValue("id"))) {
                        entryImportWrapper.getValidateContext().setCompleteValidResult("validateApositiontype", String.format(ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5728\u5c97\u4f4d\u201c%s\u201d\u4e0a\u5df2\u5b58\u5728\u4efb\u804c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PartTimeEntryImportValidateServiceImpl_12", (String)"hr-hdm-business", (Object[])new Object[0]), jsonObject.get((Object)"aposition_no")));
                    }
                } else if (PosTypeEnum.STD_POS.getName().equals(apositiontype) && PosTypeEnum.STD_POS.getCode().equals(positiontype) && aadminorg == adminorg) {
                    long stdpositionId;
                    long astdpositionId2 = jsonObject.getJSONObject("astdposition").getLong("id");
                    if (astdpositionId2 == (stdpositionId = jsonObject.getJSONObject("stdposition").getLong("id").longValue())) {
                        entryImportWrapper.getValidateContext().setCompleteValidResult("validateApositiontype", String.format(ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5728\u6807\u51c6\u5c97\u4f4d\u201c%s\u201d\u4e0a\u5df2\u5b58\u5728\u4efb\u804c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PartTimeEntryImportValidateServiceImpl_13", (String)"hr-hdm-business", (Object[])new Object[0]), jsonObject.get((Object)"astdposition_no")));
                    }
                } else if (PosTypeEnum.JOB.getName().equals(apositiontype) && PosTypeEnum.JOB.getCode().equals(positiontype) && aadminorg == adminorg && (bjobId = jsonObject.getJSONObject("bjob").getLong("id").longValue()) == (jobId = jsonObject.getJSONObject("job").getLong("id").longValue())) {
                    entryImportWrapper.getValidateContext().setCompleteValidResult("validateApositiontype", String.format(ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5728\u804c\u4f4d\u201c%s\u201d\u4e0a\u5df2\u5b58\u5728\u4efb\u804c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PartTimeEntryImportValidateServiceImpl_14", (String)"hr-hdm-business", (Object[])new Object[0]), jsonObject.get((Object)"bjob_no")));
                }
                if (!PosTypeEnum.STD_POS.getName().equals(apositiontype) || !standardPositionMap.containsKey(aadmingBoid = jsonObject.getJSONObject("aadminorg").getLong("id")) || (standardPositions = (Set)standardPositionMap.get(aadmingBoid)).contains(astdpositionId = jsonObject.getJSONObject("astdposition").getLong("id").longValue())) continue;
                entryImportWrapper.getValidateContext().setCompleteValidResult("validateApositiontype", String.format(ResManager.loadKDString((String)"\u8be5\u517c\u804c\u6807\u51c6\u5c97\u4f4d\u7684\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u6ca1\u6709\u5305\u542b\u517c\u804c\u90e8\u95e8\uff1a%1$s(%2$s)\u3002", (String)"PartTimeEntryImportValidateServiceImpl_15", (String)"hr-hdm-business", (Object[])new Object[0]), jsonObject.get((Object)"aadminorg_name"), jsonObject.get((Object)"aadminorg_no")));
            }
            return true;
        };
    }

    public static void setErrorInfo(EntryImportWrapper entryImportWrapper, long mid, DynamicObject existBill, Map<Long, List<EntryImportWrapper>> errorMaps) {
        if (mid == 0L) {
            entryImportWrapper.setCompleteValidResult("compareAPositionByPosType", ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c{0}\u201d\u5df2\u5b58\u5728\u76f8\u540c\u7684\u517c\u804c\u4e8b\u52a1\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c{1}\u201d\uff0c\u4e0d\u53ef\u4e3a\u540c\u4e00\u4eba\u5458\u91cd\u590d\u53d1\u8d77\u76f8\u540c\u517c\u804c\u3002", (String)"ParttimeValidateHelper_0", (String)"hr-hdm-business", (Object[])new Object[]{existBill.get("partperson.name"), existBill.getString("billno")}));
        } else {
            List orDefault = errorMaps.getOrDefault(mid, new ArrayList());
            orDefault.add(entryImportWrapper);
            errorMaps.put(mid, orDefault);
        }
    }

    public Predicate<List<EntryImportWrapper>> crossValidateBatch() {
        return entryImportWrappers -> {
            ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(entryImportWrappers.size());
            HashMap entryMap = new HashMap();
            entryImportWrappers.forEach(entryImportWrapper -> {
                HashMap<String, Object> param = new HashMap<String, Object>();
                JSONObject entry = entryImportWrapper.getJsonObject();
                Long depEmpId = entry.getJSONObject("primarydepemp").getLong("id");
                param.put(KEY_BILLNO, entry.getString("ebillno"));
                param.put(KEY_ACTIONID, entry.getJSONObject("affaction").getString("id"));
                param.put("effectTime", entry.getDate("effectdate").getTime());
                param.put("personId", entry.getJSONObject("person").getString("id"));
                param.put("employeeId", entry.getJSONObject("primaryemployee").getString("id"));
                param.put("managingScopeId", entry.getJSONObject("primarycmpemp").getString("id"));
                param.put("depEmpId", depEmpId.toString());
                entryMap.put(entry.getString("ebillno"), entryImportWrapper);
                params.add(param);
            });
            Map<Long, List<Map<String, Object>>> batchCrossValidateResult = PerChgBizUtils.getBatchCrossValidateResult(params);
            for (Map.Entry<Long, List<Map<String, Object>>> result : batchCrossValidateResult.entrySet()) {
                if (ObjectUtils.isEmpty(result.getValue())) continue;
                List<Map<String, Object>> crossList = result.getValue();
                Map<String, List<Map>> crossMap = crossList.stream().collect(Collectors.groupingBy(cross -> String.valueOf(cross.get("billNoSource"))));
                for (Map.Entry<String, List<Map>> cross2 : crossMap.entrySet()) {
                    String ebillNo = cross2.getKey();
                    List<Map<String, Object>> crossValidateList = cross2.getValue();
                    if (ObjectUtils.isEmpty(crossValidateList) || !entryMap.containsKey(ebillNo)) continue;
                    this.dealCrossValidate(crossValidateList, (EntryImportWrapper)entryMap.get(ebillNo));
                }
            }
            return true;
        };
    }

    private void dealCrossValidate(List<Map<String, Object>> crossValidateList, EntryImportWrapper entryImportWrapper) {
        StringBuilder errorMsg = new StringBuilder();
        for (Map<String, Object> crossMap : crossValidateList) {
            String crossValidateRange = (String)crossMap.get(KEY_CROSSVALIDATERANGE);
            String actionName = (String)crossMap.get(KEY_ACTIONNAME);
            String crossBillNo = (String)crossMap.get(KEY_BILLNO);
            StringBuilder sb = new StringBuilder().append(actionName).append("\uff08").append(crossBillNo).append("\uff09").append("\u3001");
            if (!HRStringUtils.equals((String)CROSSVALIDATERANGE_BAN, (String)crossValidateRange)) continue;
            errorMsg.append((CharSequence)sb);
        }
        if (errorMsg.length() > 0) {
            entryImportWrapper.getValidateContext().setCompleteValidResult("dealCrossValidate", String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c%1$s\u201d\u5df2\u53d1\u751f\u201c%2$s\u201d\uff0c\u4e0d\u53ef\u53d1\u8d77\u517c\u804c\u3002", (String)"PartTimeEntryImportValidateServiceImpl_22", (String)"hr-hdm-business", (Object[])new Object[0]), entryImportWrapper.getJsonObject().getString("ename"), errorMsg.substring(0, errorMsg.length() - 1)));
        }
    }
}

